/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.nonliving;

import com.telepathicgrunt.the_bumblezone.entities.mobs.RootminEntity;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modinit.BzDamageSources;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzParticles;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1307;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1331;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3857;
import net.minecraft.class_3966;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9331;
import net.minecraft.class_9701;
import org.joml.Vector2d;

public class DirtPelletEntity
extends class_3857 {
    private boolean eventBased = false;
    private class_1297 homingTarget = null;
    private static final class_2940<Optional<UUID>> DATA_HOMING_TARGET_UUID = class_2945.method_12791(DirtPelletEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> DATA_IS_HOMING = class_2945.method_12791(DirtPelletEntity.class, (class_2941)class_2943.field_13323);

    public DirtPelletEntity(class_1299<? extends DirtPelletEntity> entityType, class_1937 world) {
        super(entityType, world);
    }

    public DirtPelletEntity(class_1937 world, class_1309 livingEntity) {
        super((class_1299)BzEntities.DIRT_PELLET_ENTITY.get(), livingEntity, world);
    }

    public DirtPelletEntity(class_1937 world, double x, double y, double z) {
        super((class_1299)BzEntities.DIRT_PELLET_ENTITY.get(), x, y, z, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DATA_HOMING_TARGET_UUID, Optional.empty());
        builder.method_56912(DATA_IS_HOMING, (Object)false);
    }

    public boolean isEventBased() {
        return this.eventBased;
    }

    public void setEventBased(boolean eventBased) {
        this.eventBased = eventBased;
    }

    public boolean isHoming() {
        return (Boolean)this.field_6011.method_12789(DATA_IS_HOMING);
    }

    public void setHoming(boolean homing) {
        this.field_6011.method_12778(DATA_IS_HOMING, (Object)homing);
    }

    public UUID getHomingTargetUUID() {
        return ((Optional)this.field_6011.method_12789(DATA_HOMING_TARGET_UUID)).orElse(null);
    }

    public void setHomingTargetUUID(UUID homingTargetUUID) {
        this.field_6011.method_12778(DATA_HOMING_TARGET_UUID, Optional.of(homingTargetUUID));
    }

    protected class_1792 method_16942() {
        return (class_1792)BzItems.DIRT_PELLET.get();
    }

    private class_2394 getParticle() {
        class_1799 itemStack = this.method_7495();
        return itemStack.method_7960() ? new class_2392(class_2398.field_11218, this.method_16942().method_7854()) : new class_2392(class_2398.field_11218, itemStack);
    }

    protected class_2394 getTrailParticle() {
        return this.getParticle();
    }

    protected class_238 method_33332() {
        return super.method_33332().method_989(0.0, (double)-0.1f, 0.0);
    }

    public void method_5773() {
        class_1657 player;
        if (this.isHoming() && this.homingTarget == null && this.getHomingTargetUUID() != null && (player = this.method_37908().method_18470(this.getHomingTargetUUID())) != null) {
            this.homingTarget = player;
        }
        if ((this.field_6012 + 2) % 5 == 0) {
            class_243 futurePos = this.method_19538().method_1019(this.method_18798());
            this.method_37908().method_8406(this.getTrailParticle(), futurePos.method_10216(), futurePos.method_10214() + 0.1, futurePos.method_10215(), 0.0, 0.0, 0.0);
        }
        super.method_5773();
        if (this.homingTarget != null && this.method_24921() != null) {
            double magicSideGravityConstant;
            double demoninatorDotProduct;
            double numeratorDotProduct;
            class_243 projectionPoint;
            class_243 deltaMovement = this.method_18798();
            class_243 shooterProjectileDiff = this.method_24921().method_19538().method_1020(this.method_19538());
            class_243 shooterVictimDiff = this.method_24921().method_19538().method_1020(this.homingTarget.method_19538());
            class_243 vectorToProjectionPoint = (shooterProjectileDiff = shooterProjectileDiff.method_1023(0.0, shooterProjectileDiff.method_10214(), 0.0)).method_1020(projectionPoint = (shooterVictimDiff = shooterVictimDiff.method_1023(0.0, shooterVictimDiff.method_10214(), 0.0)).method_1021((numeratorDotProduct = shooterProjectileDiff.method_10216() * shooterVictimDiff.method_10216() + shooterProjectileDiff.method_10215() * shooterVictimDiff.method_10215()) / (demoninatorDotProduct = shooterVictimDiff.method_10216() * shooterVictimDiff.method_10216() + shooterVictimDiff.method_10215() * shooterVictimDiff.method_10215())));
            class_243 sideGravityVector = vectorToProjectionPoint.method_1021(magicSideGravityConstant = 0.022);
            if (Double.isFinite(sideGravityVector.method_10216()) && Double.isFinite(sideGravityVector.method_10215())) {
                this.method_18799(deltaMovement.method_1019(sideGravityVector));
            }
        }
    }

    public void method_5711(byte flag) {
        if (flag == 3) {
            class_2394 particleOptions = this.getParticle();
            for (int i = 0; i < 8; ++i) {
                this.method_37908().method_8406(particleOptions, this.method_23317(), this.method_23318(), this.method_23321(), this.field_5974.method_43059() * 0.1, this.field_5974.method_43059() * 0.1, this.field_5974.method_43059() * 0.1);
            }
        }
    }

    protected boolean method_26958(class_1297 entity) {
        if (entity instanceof DirtPelletEntity) {
            DirtPelletEntity dirtPelletEntity2 = (DirtPelletEntity)entity;
            if (dirtPelletEntity2.method_24921() == this.method_24921()) {
                return false;
            }
            if (this.method_19538().method_24802((class_2374)dirtPelletEntity2.method_19538(), 0.5)) {
                return super.method_26958(entity);
            }
            return false;
        }
        return super.method_26958(entity);
    }

    protected void method_7454(class_3966 entityHitResult) {
        class_1309 livingEntity;
        RootminEntity rootminEntity;
        super.method_7454(entityHitResult);
        class_1297 entity = entityHitResult.method_17782();
        class_1299 type = entity.method_5864();
        class_2960 resourceLocation = class_7923.field_41177.method_10221((Object)type);
        int damage = 1;
        if (entity instanceof DirtPelletEntity) {
            DirtPelletEntity hitDirtPelletEntity = (DirtPelletEntity)entity;
            if (!this.method_37908().field_9236) {
                hitDirtPelletEntity.method_37908().method_8421((class_1297)this, (byte)3);
                hitDirtPelletEntity.method_37908().method_8396(null, this.method_24515(), (class_3414)BzSounds.DIRT_PELLET_HIT.get(), class_3419.field_15254, 1.0f, 1.0f);
                hitDirtPelletEntity.method_31472();
            }
        }
        if (!type.method_20210(BzTags.DIRT_PELLET_FORCE_NO_EXTRA_DAMAGE)) {
            class_1308 mob;
            if (type.method_20210(BzTags.DIRT_PELLET_EXTRA_DAMAGE)) {
                damage = 6;
            } else if (!resourceLocation.method_12836().equals("minecraft") && !resourceLocation.method_12836().equals("the_bumblezone") && (entity instanceof class_1307 || entity instanceof class_1308 && (mob = (class_1308)entity).method_5962() instanceof class_1331)) {
                damage = 6;
            }
        }
        if (this.eventBased || entity instanceof RootminEntity && (rootminEntity = (RootminEntity)entity).getEssenceController() != null) {
            if (entity instanceof RootminEntity) {
                damage = 1;
            } else if (entity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)entity;
                float maxHeart = Math.max(serverPlayer.method_6032(), serverPlayer.method_6063());
                damage = !EssenceOfTheBees.hasEssence(serverPlayer) ? (int)(maxHeart / 2.0f) : (int)(maxHeart / 4.0f);
            } else {
                damage = 5;
            }
        }
        class_1282 damageSource = this.eventBased ? this.method_48923().method_48797(BzDamageSources.EVENT_DIRT_PELLET_TYPE, (class_1297)this, this.method_24921()) : this.method_48923().method_48797(BzDamageSources.DIRT_PELLET_TYPE, (class_1297)this, this.method_24921());
        entity.method_5643(damageSource, (float)damage);
        if (entity instanceof class_1309 && !(livingEntity = (class_1309)entity).method_7325()) {
            Object object;
            class_1657 player;
            if (livingEntity instanceof class_1657 && (player = (class_1657)livingEntity).method_7337()) {
                return;
            }
            Vector2d direction = new Vector2d(this.method_18798().method_10216(), this.method_18798().method_10215()).normalize();
            double yRotHitRadian = class_3532.method_15349((double)direction.x(), (double)direction.y());
            double knockbackStrength = 1.0;
            if (livingEntity instanceof RootminEntity) {
                knockbackStrength = this.isEventBased() ? 0.0 : 0.1;
            }
            livingEntity.method_6005(knockbackStrength, (double)(-class_3532.method_15374((float)((float)yRotHitRadian))), (double)(-class_3532.method_15362((float)((float)yRotHitRadian))));
            if (this.eventBased && (object = this.method_37908()) instanceof class_3218) {
                class_3218 serverLevel = (class_3218)object;
                for (class_6880 mobEffect : new HashSet(livingEntity.method_6088().keySet())) {
                    if (!((class_1291)mobEffect.comp_349()).method_5573()) continue;
                    livingEntity.method_6016(mobEffect);
                }
                if (this.field_5974.method_43056()) {
                    int slotStartIndex = this.field_5974.method_43048(4);
                    for (int i = 0; i < 4; ++i) {
                        int slotIndex = (slotStartIndex + i) % 4;
                        class_1304 equipmentSlot = switch (slotIndex) {
                            case 1 -> class_1304.field_6174;
                            case 2 -> class_1304.field_6172;
                            case 3 -> class_1304.field_6166;
                            default -> class_1304.field_6169;
                        };
                        class_1799 armorItem = livingEntity.method_6118(equipmentSlot);
                        if (armorItem.method_7960() || class_1890.method_60142((class_1799)armorItem, (class_9331)class_9701.field_51656) || armorItem.method_31573(BzTags.LIFE_ARENA_ARMOR_CANNOT_BE_KNOCKED_OFF)) continue;
                        livingEntity.method_5673(equipmentSlot, class_1799.field_8037);
                        this.dropItemFromEntity(livingEntity, armorItem, false, true);
                        break;
                    }
                }
                serverLevel.method_14199((class_2394)((class_2400)BzParticles.DUST_PARTICLE.get()), livingEntity.method_23317(), livingEntity.method_23320(), livingEntity.method_23321(), 15, this.field_5974.method_43059() * 0.2, this.field_5974.method_43059() * 0.25 + 0.1, this.field_5974.method_43059() * 0.2, 0.0);
            }
        }
    }

    private class_1542 dropItemFromEntity(class_1309 livingEntity, class_1799 itemStack, boolean randomMovement, boolean setOwner) {
        if (itemStack.method_7960()) {
            return null;
        }
        double d = livingEntity.method_23320() - (double)0.3f;
        class_1542 itemEntity = new class_1542(livingEntity.method_37908(), livingEntity.method_23317(), d, livingEntity.method_23321(), itemStack);
        itemEntity.method_35190();
        itemEntity.method_6982(40);
        if (setOwner) {
            itemEntity.method_6981((class_1297)livingEntity);
        }
        if (randomMovement) {
            float f = this.field_5974.method_43057() * 0.5f;
            float g = this.field_5974.method_43057() * ((float)Math.PI * 2);
            itemEntity.method_18800((double)(-class_3532.method_15374((float)g) * f), (double)0.2f, (double)(class_3532.method_15362((float)g) * f));
        } else {
            float g = class_3532.method_15374((float)(livingEntity.method_36455() * ((float)Math.PI / 180)));
            float h = class_3532.method_15362((float)(livingEntity.method_36455() * ((float)Math.PI / 180)));
            float i = class_3532.method_15374((float)(livingEntity.method_36454() * ((float)Math.PI / 180)));
            float j = class_3532.method_15362((float)(livingEntity.method_36454() * ((float)Math.PI / 180)));
            float k = this.field_5974.method_43057() * ((float)Math.PI * 2);
            float l = 0.02f * this.field_5974.method_43057();
            itemEntity.method_18800((double)(-i * h * 0.3f) + Math.cos(k) * (double)l, (double)(-g * 0.3f + 0.1f + (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.1f), (double)(j * h * 0.3f) + Math.sin(k) * (double)l);
        }
        livingEntity.method_37908().method_8649((class_1297)itemEntity);
        if (livingEntity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)livingEntity;
            serverPlayer.method_7342(class_3468.field_15405.method_14956((Object)itemStack.method_7909()), itemStack.method_7947());
            serverPlayer.method_7281(class_3468.field_15406);
        }
        return itemEntity;
    }

    protected void method_7488(class_239 hitResult) {
        super.method_7488(hitResult);
        if (!this.method_37908().field_9236) {
            this.method_37908().method_8421((class_1297)this, (byte)3);
            this.method_37908().method_8396(null, this.method_24515(), (class_3414)BzSounds.DIRT_PELLET_HIT.get(), class_3419.field_15254, 1.0f, 1.0f);
            this.method_31472();
        }
    }

    public boolean method_5863() {
        return true;
    }

    public float method_5871() {
        double speed = this.method_18798().method_1033();
        return (float)Math.max(speed, 8.0);
    }

    public boolean method_5643(class_1282 damageSource, float f) {
        if (this.method_5679(damageSource)) {
            return false;
        }
        this.method_5785();
        class_1297 entity = damageSource.method_5529();
        if (entity != null) {
            if (!this.method_37908().field_9236) {
                class_243 vec3 = entity.method_5720();
                this.method_18799(vec3);
                if (this.isHoming() && this.method_24921() != null) {
                    this.setHomingTargetUUID(this.method_24921().method_5667());
                    this.homingTarget = this.method_24921();
                } else {
                    this.setHoming(false);
                }
                this.method_7432(entity);
            }
            return true;
        }
        return false;
    }

    public void method_5652(class_2487 compoundTag) {
        super.method_5652(compoundTag);
        compoundTag.method_10556("isEvent", this.isEventBased());
    }

    public void method_5749(class_2487 compoundTag) {
        super.method_5749(compoundTag);
        this.setEventBased(compoundTag.method_10577("isEvent"));
    }
}

