/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.entities.controllers.HoneySlimeMoveController;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeAngerAttackingGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeBreedGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeFaceRandomGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeFloatGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeHopGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeRevengeGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.HoneySlimeTemptGoal;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.mixin.entities.AgeableMobAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEntities;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1352;
import net.minecraft.class_1429;
import net.minecraft.class_1621;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5425;
import net.minecraft.class_6019;

public class HoneySlimeEntity
extends class_1429
implements class_5354 {
    private static final class_2940<Boolean> IN_HONEY = class_2945.method_12791(HoneySlimeEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> IN_HONEY_GROWTH_TIME = class_2945.method_12791(HoneySlimeEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> ANGRY_TIMER = class_2945.method_12791(HoneySlimeEntity.class, (class_2941)class_2943.field_13327);
    private static final class_6019 MAX_ANGER_DURATION = class_4802.method_24505((int)22, (int)36);
    private UUID target_UUID;
    private static final HashSet<class_2248> HONEY_BASED_BLOCKS = new HashSet();
    public float squishAmount;
    public float squishFactor;
    public float prevSquishFactor;
    private boolean wasOnGround;

    public HoneySlimeEntity(class_1937 worldIn) {
        super((class_1299)BzEntities.HONEY_SLIME.get(), worldIn);
    }

    public HoneySlimeEntity(class_1299<? extends HoneySlimeEntity> type, class_1937 worldIn) {
        super(type, worldIn);
        this.field_6207 = new HoneySlimeMoveController(this);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new HoneySlimeFloatGoal(this));
        this.field_6185.method_6277(1, (class_1352)new HoneySlimeRevengeGoal(this));
        this.field_6185.method_6277(1, (class_1352)new HoneySlimeAngerAttackingGoal(this));
        this.field_6201.method_6277(2, (class_1352)new HoneySlimeBreedGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new HoneySlimeTemptGoal(this));
        this.field_6201.method_6277(4, (class_1352)new HoneySlimeHopGoal(this));
        this.field_6201.method_6277(4, (class_1352)new HoneySlimeFaceRandomGoal(this));
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn) {
        this.setupHoneySlime(this.method_6109(), true);
        return super.method_5943(worldIn, difficultyIn, reason, spawnDataIn);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(IN_HONEY, (Object)true);
        builder.method_56912(IN_HONEY_GROWTH_TIME, (Object)0);
        builder.method_56912(ANGRY_TIMER, (Object)0);
    }

    public void method_5674(class_2940<?> key) {
        if (AgeableMobAccessor.bumblezone$getDATA_BABY_ID().equals(key)) {
            this.method_18382();
            if (!this.method_5765()) {
                this.method_36456(this.field_6241);
                this.method_5636(this.field_6241);
            }
            if (this.method_5799() && this.field_5974.method_43048(20) == 0) {
                this.method_5746();
            }
        }
        super.method_5674(key);
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("inHoney", this.isInHoney());
        compound.method_10569("inHoneyGrowthTimer", this.getInHoneyGrowthTime());
        compound.method_10556("wasOnGround", this.wasOnGround);
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setInHoney(compound.method_10577("inHoney"));
        this.setInHoneyGrowthTime(compound.method_10550("inHoneyGrowthTimer"));
        this.wasOnGround = compound.method_10577("wasOnGround");
    }

    public static class_5132.class_5133 getAttributeBuilder() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 2.0).method_26868(class_5134.field_23721, 1.0);
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return true;
    }

    protected void setupHoneySlime(boolean isBaby, boolean resetHealth) {
        this.method_23311();
        this.method_18382();
        Objects.requireNonNull(this.method_5996(class_5134.field_23716)).method_6192(isBaby ? 2.0 : 8.0);
        Objects.requireNonNull(this.method_5996(class_5134.field_23719)).method_6192((double)((0.2f + 0.1f * (float)(isBaby ? 1 : 2)) * 2.0f));
        Objects.requireNonNull(this.method_5996(class_5134.field_23721)).method_6192(isBaby ? 1.0 : 3.0);
        if (resetHealth) {
            this.method_6033(this.method_6063());
        }
        this.field_6194 = isBaby ? 1 : 2;
    }

    public void method_5650(class_1297.class_5529 removalReason) {
        if (!this.method_37908().method_8608() && this.method_29504()) {
            class_1657 player;
            class_1309 flag2;
            if (!this.method_6109()) {
                class_2561 component = this.method_5797();
                boolean flag2 = this.method_5987();
                int splitAmount = 2 + this.field_5974.method_43048(3);
                ArrayList<class_1308> children = new ArrayList<class_1308>();
                for (int currentNewSlime = 0; currentNewSlime < splitAmount; ++currentNewSlime) {
                    float xOffset = ((float)(currentNewSlime % 2) - 0.5f) * 0.5f;
                    float zOffset = ((float)(currentNewSlime / 2) - 0.5f) * 0.5f;
                    if (this.isInHoney()) {
                        HoneySlimeEntity honeySlime = (HoneySlimeEntity)((class_1299)BzEntities.HONEY_SLIME.get()).method_5883(this.method_37908());
                        if (honeySlime == null) continue;
                        if (this.method_5947()) {
                            honeySlime.method_5971();
                        }
                        honeySlime.method_7217(true);
                        honeySlime.method_5665(component);
                        honeySlime.method_5977(flag2);
                        honeySlime.method_5684(this.method_5655());
                        honeySlime.setupHoneySlime(honeySlime.method_6109(), true);
                        honeySlime.method_5808(this.method_23317() + (double)xOffset, this.method_23318() + 0.5, this.method_23321() + (double)zOffset, this.field_5974.method_43057() * 360.0f, 0.0f);
                        children.add((class_1308)honeySlime);
                        continue;
                    }
                    class_1621 slime = (class_1621)class_1299.field_6069.method_5883(this.method_37908());
                    if (slime == null) continue;
                    if (this.method_5947()) {
                        slime.method_5971();
                    }
                    slime.method_5665(component);
                    slime.method_5977(flag2);
                    slime.method_5684(this.method_5655());
                    slime.method_7161(1, true);
                    slime.method_5808(this.method_23317() + (double)xOffset, this.method_23318() + 0.5, this.method_23321() + (double)zOffset, this.field_5974.method_43057() * 360.0f, 0.0f);
                    children.add((class_1308)slime);
                }
                if (PlatformHooks.shouldMobSplit((class_1308)this, children)) {
                    children.forEach(arg_0 -> ((class_1937)this.method_37908()).method_8649(arg_0));
                }
            }
            if (!(this.method_49107() == null || (flag2 = this.method_49107()) instanceof class_1657 && (player = (class_1657)flag2).method_7337())) {
                List honeySlimes = this.method_37908().method_18467(HoneySlimeEntity.class, this.method_5829().method_1014(24.0));
                for (HoneySlimeEntity honeySlime : honeySlimes) {
                    honeySlime.method_29509();
                    honeySlime.method_29513(this.method_49107().method_5667());
                    honeySlime.method_5980(this.method_49107());
                }
            }
        }
        super.method_5650(removalReason);
    }

    public boolean isInHoney() {
        return (Boolean)this.field_6011.method_12789(IN_HONEY);
    }

    public void setInHoney(boolean value) {
        this.field_6011.method_12778(IN_HONEY, (Object)value);
    }

    public int getInHoneyGrowthTime() {
        return (Integer)this.field_6011.method_12789(IN_HONEY_GROWTH_TIME);
    }

    public void setInHoneyGrowthTime(int value) {
        this.field_6011.method_12778(IN_HONEY_GROWTH_TIME, (Object)value);
    }

    public boolean method_5747(float distance, float damageMultiplier, class_1282 damageSource) {
        if (distance > 1.0f) {
            this.method_5783(this.method_6109() ? (class_3414)BzSounds.HONEY_SLIME_SQUISH_SMALL.get() : (class_3414)BzSounds.HONEY_SLIME_SQUISH.get(), 0.4f, 1.0f);
        }
        int fallDamage = this.method_23329(distance, damageMultiplier);
        if (this.isInHoney()) {
            fallDamage = (int)((float)fallDamage * 0.35f - 3.0f);
        }
        if (fallDamage <= 0) {
            return false;
        }
        this.method_5643(damageSource, fallDamage);
        this.method_23328();
        return true;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemstack = player.method_5998(hand);
        if (!this.method_6109() && this.isInHoney() && itemstack.method_7909() == class_1802.field_8469) {
            this.method_37908().method_43128(player, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14779, class_3419.field_15248, 1.0f, 1.0f);
            GeneralUtils.givePlayerItem(player, hand, new class_1799((class_1935)class_1802.field_20417), false, true);
            this.getHoneyFromSlime((class_1309)this);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                if (!EssenceOfTheBees.hasEssence(serverPlayer)) {
                    this.method_6015((class_1309)player);
                }
                ((GenericTrigger)((Object)BzCriterias.HONEY_SLIME_HARVEST_TRIGGER.get())).trigger(serverPlayer);
            }
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    private void getHoneyFromSlime(class_1309 entity) {
        if (entity instanceof HoneySlimeEntity) {
            this.setInHoney(false);
            this.setInHoneyGrowthTime(-14400);
        }
    }

    public void method_5773() {
        this.squishFactor += (this.squishAmount - this.squishFactor) * 0.5f;
        this.prevSquishFactor = this.squishFactor;
        super.method_5773();
        if (this.method_24828() && !this.wasOnGround) {
            int i = 2;
            if (this.spawnCustomParticles()) {
                i = 0;
            }
            for (int j = 0; j < i * 8; ++j) {
                float f = this.field_5974.method_43057() * ((float)Math.PI * 2);
                float f1 = this.field_5974.method_43057() * 0.5f + 0.5f;
                float f2 = class_3532.method_15374((float)f) * (float)i * 0.5f * f1;
                float f3 = class_3532.method_15362((float)f) * (float)i * 0.5f * f1;
                this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)class_2246.field_21211)), this.method_23317() + (double)f2, this.method_23318(), this.method_23321() + (double)f3, 0.0, 0.0, 0.0);
            }
            this.method_5783(this.getSquishSound(), this.method_6107(), ((this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f) / 0.8f);
            this.squishAmount = -0.5f;
        } else if (!this.method_24828() && this.wasOnGround) {
            this.squishAmount = 1.0f;
        }
        this.wasOnGround = this.method_24828();
        this.alterSquishAmount();
    }

    public void method_6007() {
        super.method_6007();
        if (this.method_5805()) {
            if (!this.isInHoney()) {
                this.setInHoneyGrowthTime(this.getInHoneyGrowthTime() + 1);
                if (HONEY_BASED_BLOCKS.isEmpty()) {
                    HONEY_BASED_BLOCKS.addAll(Stream.of(class_2246.field_21211, (class_2248)BzBlocks.FILLED_POROUS_HONEYCOMB.get(), (class_2248)BzBlocks.HONEYCOMB_BROOD.get(), (class_2248)BzBlocks.STICKY_HONEY_REDSTONE.get(), (class_2248)BzBlocks.STICKY_HONEY_RESIDUE.get()).collect(Collectors.toCollection(HashSet::new)));
                }
                if (!this.method_37908().method_8608() && HONEY_BASED_BLOCKS.contains(this.method_37908().method_8320(this.method_24515().method_10074()).method_26204()) && (double)this.field_5974.method_43057() < 0.001) {
                    this.setInHoneyGrowthTime(0);
                }
            }
            this.setInHoney(this.getInHoneyGrowthTime() >= 0);
        }
    }

    protected void method_5958() {
        if (!this.method_37908().method_8608()) {
            this.method_29510((class_3218)this.method_37908(), false);
        }
    }

    public boolean method_6481(class_1799 stack) {
        return stack.method_31573(BzTags.HONEY_SLIME_DESIRED_ITEMS);
    }

    public class_1296 method_5613(class_3218 worldIn, class_1296 ageable) {
        HoneySlimeEntity childHoneySlimeEntity = (HoneySlimeEntity)((class_1299)BzEntities.HONEY_SLIME.get()).method_5883((class_1937)worldIn);
        if (childHoneySlimeEntity != null) {
            childHoneySlimeEntity.setupHoneySlime(true, true);
        }
        return childHoneySlimeEntity;
    }

    protected void method_5619() {
        super.method_5619();
        if (!this.method_6109()) {
            this.setupHoneySlime(false, true);
        }
    }

    protected void dealDamage(class_1309 entityIn) {
        if (this.method_5805()) {
            int i = 2;
            if (this.method_5858((class_1297)entityIn) < 0.6 * (double)i * 0.6 * (double)i && this.method_6057((class_1297)entityIn) && entityIn.method_5643(this.method_48923().method_48812((class_1309)this), this.getAttackStrength())) {
                this.method_5783((class_3414)BzSounds.HONEY_SLIME_ATTACK.get(), 1.0f, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2f + 1.0f);
                this.dealDamage(entityIn);
            }
        }
    }

    public boolean canDamagePlayer() {
        return !this.method_6109() && this.method_6034();
    }

    public void method_5694(class_1657 entityIn) {
        if (this.canDamagePlayer() && this.method_5968() == entityIn) {
            this.dealDamage((class_1309)entityIn);
        }
    }

    public class_1299<? extends HoneySlimeEntity> method_5864() {
        return super.method_5864();
    }

    public void method_18382() {
        double x = this.method_23317();
        double y = this.method_23318();
        double z = this.method_23321();
        super.method_18382();
        this.method_30634(x, y, z);
    }

    public boolean method_5931() {
        return !this.method_60953();
    }

    protected void alterSquishAmount() {
        this.squishAmount *= 0.6f;
    }

    public int getJumpDelay() {
        return this.field_5974.method_43048(20) + 10;
    }

    protected float getAttackStrength() {
        return (float)Objects.requireNonNull(this.method_5996(class_5134.field_23721)).method_6194();
    }

    protected boolean method_27071() {
        return true;
    }

    public float method_6107() {
        return 0.4f * (float)(this.method_6109() ? 1 : 2);
    }

    public int method_5978() {
        return 0;
    }

    public boolean makesSoundOnJump() {
        return !this.method_6109();
    }

    public void method_6043() {
        class_243 vec3d = this.method_18798();
        if (this.method_29511()) {
            this.method_18800(vec3d.field_1352 * 5.0, this.method_6106() * 1.3f, vec3d.field_1350 * 5.0);
        } else {
            this.method_18800(vec3d.field_1352, this.method_6106(), vec3d.field_1350);
        }
        this.field_6007 = true;
    }

    protected boolean spawnCustomParticles() {
        return false;
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(ANGRY_TIMER);
    }

    public void method_29514(int ticks) {
        this.field_6011.method_12778(ANGRY_TIMER, (Object)ticks);
    }

    public UUID method_29508() {
        return this.target_UUID;
    }

    public void method_29513(UUID uuid) {
        this.target_UUID = uuid;
    }

    public void method_29509() {
        this.method_29514(MAX_ANGER_DURATION.method_35008(this.field_5974));
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return this.method_6109() ? (class_3414)BzSounds.HONEY_SLIME_HURT_SMALL.get() : (class_3414)BzSounds.HONEY_SLIME_HURT.get();
    }

    protected class_3414 method_6002() {
        return this.method_6109() ? (class_3414)BzSounds.HONEY_SLIME_DEATH_SMALL.get() : (class_3414)BzSounds.HONEY_SLIME_DEATH.get();
    }

    protected class_3414 getSquishSound() {
        return this.method_6109() ? (class_3414)BzSounds.HONEY_SLIME_SQUISH_SMALL.get() : (class_3414)BzSounds.HONEY_SLIME_SQUISH.get();
    }

    public class_3414 getJumpSound() {
        return this.method_6109() ? (class_3414)BzSounds.HONEY_SLIME_JUMP_SMALL.get() : (class_3414)BzSounds.HONEY_SLIME_JUMP.get();
    }
}

