/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.mobs;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzGeneralConfigs;
import com.telepathicgrunt.the_bumblezone.entities.BeeAggression;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.QueensTradeManager;
import com.telepathicgrunt.the_bumblezone.entities.datamanagers.queentrades.WeightedTradeResult;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAlwaysLookAtPlayerGoal;
import com.telepathicgrunt.the_bumblezone.entities.goals.BeeQueenAngerableMeleeAttackGoal;
import com.telepathicgrunt.the_bumblezone.entities.mobs.BeeQueenState;
import com.telepathicgrunt.the_bumblezone.entities.navigation.DirectPathNavigator;
import com.telepathicgrunt.the_bumblezone.mixin.entities.ItemEntityAccessor;
import com.telepathicgrunt.the_bumblezone.mixin.entities.PlayerAdvancementsAccessor;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzItems;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import com.telepathicgrunt.the_bumblezone.modules.PlayerDataHandler;
import com.telepathicgrunt.the_bumblezone.modules.base.ModuleHelper;
import com.telepathicgrunt.the_bumblezone.modules.registry.ModuleRegistry;
import com.telepathicgrunt.the_bumblezone.packets.TradeHintParticleSpawnPacket;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1542;
import net.minecraft.class_163;
import net.minecraft.class_1657;
import net.minecraft.class_167;
import net.minecraft.class_1680;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_3830;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4466;
import net.minecraft.class_4538;
import net.minecraft.class_4802;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5354;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6012;
import net.minecraft.class_6019;
import net.minecraft.class_7094;
import net.minecraft.class_8779;
import net.minecraft.class_8781;

public class BeeQueenEntity
extends class_1429
implements class_5354 {
    private static final class_4051 PLAYER_ACKNOWLEDGE_SIGHT = class_4051.method_36626().method_18418(10.0);
    public static final int TRADE_HINT_PARTICLE_LIFETIME = 200;
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 attackAnimationState = new class_7094();
    public final class_7094 itemThrownAnimationState = new class_7094();
    public final class_7094 itemRejectAnimationState = new class_7094();
    public static final class_2941<BeeQueenState> QUEEN_POSE_SERIALIZER = class_2941.method_56031(BeeQueenState.STREAM_CODEC);
    private static final class_2940<Integer> THROWCOOLDOWN = class_2945.method_12791(BeeQueenEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> BEESPAWNCOOLDOWN = class_2945.method_12791(BeeQueenEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> REMAINING_ANGER_TIME = class_2945.method_12791(BeeQueenEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<BeeQueenState> QUEEN_POSE = class_2945.method_12791(BeeQueenEntity.class, QUEEN_POSE_SERIALIZER);
    private static final class_6019 PERSISTENT_ANGER_TIME = class_4802.method_24505((int)60, (int)120);
    private UUID persistentAngerTarget;
    private int underWaterTicks;
    private int poseTicks;
    private int tradeHintCooldown = 0;
    private boolean isSpecialDay = false;
    private static final WeightedTradeResult ESSENCE_DROP = new WeightedTradeResult(null, Optional.of(List.of(((class_1792)BzItems.ESSENCE_OF_THE_BEES.get()).method_7854())), 1, 1000, 1);
    private static final class_2960 BEE_ESSENCE_ADVANCEMENT_RL = class_2960.method_60655((String)"the_bumblezone", (String)"essence/bee_essence_infusion");

    public BeeQueenEntity(class_1299<? extends BeeQueenEntity> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(THROWCOOLDOWN, (Object)0);
        builder.method_56912(REMAINING_ANGER_TIME, (Object)0);
        builder.method_56912(BEESPAWNCOOLDOWN, (Object)0);
        builder.method_56912(QUEEN_POSE, (Object)BeeQueenState.NONE);
    }

    public void method_5674(class_2940<?> entityDataAccessor) {
        if (QUEEN_POSE.equals(entityDataAccessor)) {
            BeeQueenState pose = this.getQueenPose();
            this.setAnimationState(pose, BeeQueenState.ATTACKING, this.attackAnimationState);
            this.setAnimationState(pose, BeeQueenState.ITEM_REJECT, this.itemRejectAnimationState);
            this.setAnimationState(pose, BeeQueenState.ITEM_THROW, this.itemThrownAnimationState);
        }
        super.method_5674(entityDataAccessor);
    }

    private void setAnimationState(BeeQueenState pose, BeeQueenState poseToCheckFor, class_7094 animationState) {
        if (pose == poseToCheckFor) {
            animationState.method_41322(this.field_6012);
        } else {
            animationState.method_41325();
        }
    }

    public static class_5132.class_5133 getAttributeBuilder() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 150.0).method_26868(class_5134.field_23719, 0.1).method_26868(class_5134.field_23721, 10.0);
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new BeeQueenAngerableMeleeAttackGoal(this));
        this.field_6201.method_6277(2, (class_1352)new BeeQueenAlwaysLookAtPlayerGoal((class_1308)this, class_1657.class, 60.0f));
        this.field_6201.method_6277(3, (class_1352)new class_1347((class_1308)this));
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("throwcooldown", this.getThrowCooldown());
        tag.method_10569("beespawncooldown", this.getBeeSpawnCooldown());
        this.method_29517(tag);
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setThrowCooldown(tag.method_10550("throwcooldown"));
        this.setBeeSpawnCooldown(tag.method_10550("beespawncooldown"));
        this.method_29512(this.method_37908(), tag);
    }

    public boolean method_6481(class_1799 itemStack) {
        return false;
    }

    public void setIsSpecialDay(boolean isSpecialDay) {
        this.isSpecialDay = isSpecialDay;
    }

    public boolean getIsSpecialDay() {
        return this.isSpecialDay;
    }

    public void setQueenPose(BeeQueenState beeQueenState) {
        this.field_6011.method_12778(QUEEN_POSE, (Object)beeQueenState);
    }

    public BeeQueenState getQueenPose() {
        return (BeeQueenState)((Object)this.field_6011.method_12789(QUEEN_POSE));
    }

    protected class_1408 method_5965(class_1937 pLevel) {
        return new DirectPathNavigator((class_1308)this, pLevel);
    }

    protected class_1297.class_5799 method_33570() {
        return class_1297.class_5799.field_28630;
    }

    public static boolean checkMobSpawnRules(class_1299<? extends class_1308> entityType, class_1936 iWorld, class_3730 spawnReason, class_2338 blockPos, class_5819 random) {
        return true;
    }

    public boolean method_5979(class_1936 world, class_3730 spawnReason) {
        return true;
    }

    public boolean method_5957(class_4538 worldReader) {
        class_238 box = this.method_5829();
        return !worldReader.method_22345(box) && worldReader.method_29546(box).noneMatch(state -> state.method_51366()) && worldReader.method_8606((class_1297)this);
    }

    public boolean method_5810() {
        return false;
    }

    protected class_243 method_52533(class_1297 entity, class_4048 entityDimensions, float f) {
        return new class_243(0.0, (double)(this.method_18377(class_4050.field_18076).comp_2186() * 0.9f), 0.0);
    }

    public void method_5865(class_1297 passenger, class_1297.class_4738 moveFunction) {
        if (passenger instanceof class_1309) {
            ((class_1309)passenger).field_6283 = this.field_6283;
        }
        if (this.method_5626(passenger)) {
            class_243 vec3 = this.method_52538(passenger);
            class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
            class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
            moveFunction.accept(passenger, vec3.method_10216() + sideVect.method_10216() - forwardVect.method_10216() * 0.5, vec3.method_10214() + 0.2 - passenger.method_55668((class_1297)this).method_10214(), vec3.method_10215() + sideVect.method_10215() - forwardVect.method_10215() * 0.5);
        }
    }

    public boolean method_5679(class_1282 damageSource) {
        if (damageSource == this.method_37908().method_48963().method_48835()) {
            return true;
        }
        return super.method_5679(damageSource);
    }

    public void method_5844(class_2680 blockState, class_243 speedMult) {
        if (blockState.method_26204() instanceof class_3830) {
            return;
        }
        super.method_5844(blockState, speedMult);
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1309 livingEntity;
        class_1297 entity;
        class_1680 snowball;
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1680 && (snowball = (class_1680)class_12972).method_5864() == class_1299.field_6068 && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)class_1802.field_8543)) {
            if (!this.method_37908().method_8608()) {
                class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
                class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
                class_1542 itemEntity = new class_1542(this.method_37908(), 0.0, 0.0, 0.0, class_1802.field_8543.method_7854());
                class_1297 class_12973 = snowball.method_24921();
                if (class_12973 instanceof class_1657) {
                    class_1657 player = (class_1657)class_12973;
                    itemEntity.method_6981((class_1297)player);
                }
                this.tradeItemEntity(itemEntity, forwardVect, sideVect);
            }
            return false;
        }
        if (this.method_5679(source)) {
            return false;
        }
        if (this.method_30230() && source == this.method_37908().method_48963().method_48822()) {
            this.spawnAngryParticles(6);
            this.method_6013(source);
            return false;
        }
        if (!(this.method_5987() || !((entity = source.method_5529()) instanceof class_1309) || (livingEntity = (class_1309)entity).method_7325() || livingEntity.method_5864().method_20210(BzTags.FORCED_BEE_CALM_AT) || BeeAggression.isBeelikeEntity((class_1297)livingEntity))) {
            if (livingEntity instanceof class_1657) {
                class_1657 player = (class_1657)livingEntity;
                if (this.method_37908().method_8407() == class_1267.field_5801 || player.method_7337()) {
                    this.spawnAngryParticles(6);
                    return super.method_5643(source, amount);
                }
            }
            if ((livingEntity.method_37908().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) || BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) && BzBeeAggressionConfigs.aggressiveBees) {
                if (livingEntity.method_6059(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
                    livingEntity.method_6016(BzEffects.PROTECTION_OF_THE_HIVE.holder());
                } else {
                    livingEntity.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 3, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                }
            }
            this.method_29509();
            this.method_29513(livingEntity.method_5667());
            this.method_5980(livingEntity);
        }
        this.spawnAngryParticles(6);
        return super.method_5643(source, amount);
    }

    protected void method_5958() {
        this.underWaterTicks = this.method_5869() ? ++this.underWaterTicks : 0;
        if (this.underWaterTicks > 100) {
            this.method_5643(this.method_37908().method_48963().method_48824(), 3.0f);
        }
        if (!this.method_37908().field_9236) {
            this.method_29510((class_3218)this.method_37908(), false);
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_5805()) {
            this.idleAnimationState.method_41324(this.field_6012);
        } else {
            this.idleAnimationState.method_41325();
        }
        BeeQueenState pose = this.getQueenPose();
        if (pose != BeeQueenState.NONE) {
            if (pose == BeeQueenState.ATTACKING && this.poseTicks > 17) {
                this.setQueenPose(BeeQueenState.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenState.ITEM_REJECT && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenState.NONE);
                this.poseTicks = 0;
            }
            if (pose == BeeQueenState.ITEM_THROW && this.poseTicks > 20) {
                this.setQueenPose(BeeQueenState.NONE);
                this.poseTicks = 0;
            }
            ++this.poseTicks;
        }
        if (!this.method_5987()) {
            if (!this.method_37908().method_8608() && this.method_37908().method_8510() % 200L == 0L && !this.method_29504()) {
                this.method_6025(1.0f);
            }
            if (!this.method_37908().method_8608()) {
                if (this.method_29511()) {
                    this.performAngryActions();
                } else {
                    this.performGroundTrades();
                }
            }
            if (!this.method_37908().method_8608()) {
                if (BzGeneralConfigs.beeQueenSpecialDayTrades && (this.field_6012 == 1 || ((long)this.field_6012 + this.method_5667().getLeastSignificantBits()) % 72000L == 0L)) {
                    Optional<List<class_1792>> specialDayItem = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItem();
                    List<class_1792> allowedSpecialDayTradeItems = ((List)specialDayItem.orElse(new ArrayList())).stream().filter(i -> i.method_45382(this.method_37908().method_45162())).toList();
                    this.setIsSpecialDay(!allowedSpecialDayTradeItems.isEmpty());
                }
                if (this.tradeHintCooldown == 0 && ((long)this.field_6012 + this.method_5667().getLeastSignificantBits()) % 40L == 0L) {
                    List nearbyPlayers = this.method_37908().method_18464(PLAYER_ACKNOWLEDGE_SIGHT, (class_1309)this, this.method_5829().method_1014(10.0));
                    for (class_1657 player : nearbyPlayers) {
                        if (!this.isLookingAtMeClose(player)) continue;
                        class_1792 wantItem = null;
                        List tradeResults = null;
                        if (this.getIsSpecialDay()) {
                            Optional<Pair<QueensTradeManager.SpecialDaysEntry, class_6012<WeightedTradeResult>>> specialDayRewards;
                            Optional<List<class_1792>> specialDayItem = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItem();
                            if (specialDayItem.isEmpty()) {
                                this.setIsSpecialDay(false);
                            }
                            if ((specialDayRewards = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItems(wantItem = specialDayItem.get().get(this.field_5974.method_43048(specialDayItem.get().size())))).isEmpty()) {
                                this.setIsSpecialDay(false);
                            } else {
                                tradeResults = ((class_6012)specialDayRewards.get().getSecond()).method_34994();
                            }
                        }
                        if (wantItem == null || tradeResults == null) {
                            ObjectSet keySet = QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.keySet();
                            wantItem = keySet.stream().skip(this.field_5974.method_43048(keySet.size())).findFirst().orElse(null);
                            tradeResults = ((class_6012)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)wantItem)).method_34994();
                        }
                        int maximumRewardsToShowAtATime = 5;
                        ArrayList<class_1799> allRewardItems = new ArrayList<class_1799>();
                        for (WeightedTradeResult weightedTradeResult : tradeResults) {
                            allRewardItems.addAll(weightedTradeResult.getItems());
                        }
                        Collections.shuffle(allRewardItems);
                        List<class_1799> slicedRewardItems = allRewardItems.subList(0, Math.min(maximumRewardsToShowAtATime, allRewardItems.size()));
                        TradeHintParticleSpawnPacket.sendToClient((class_1297)this, wantItem, slicedRewardItems);
                        this.tradeHintCooldown = 220;
                        break;
                    }
                }
                if (this.tradeHintCooldown > 0) {
                    --this.tradeHintCooldown;
                }
            }
        }
    }

    private void performAngryActions() {
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_5968() instanceof class_1657) {
            this.method_29922();
            return;
        }
        int beeCooldown = this.getBeeSpawnCooldown();
        if (beeCooldown <= 0 && !this.method_6062() && this.method_37908().method_8450().method_8355(class_1928.field_19390)) {
            this.setBeeSpawnCooldown(this.field_5974.method_43048(50) + 75);
            class_2338 spawnBlockPos = GeneralUtils.getRandomBlockposWithinRange((class_1309)this, 5, 0);
            if (!this.method_37908().method_8320(spawnBlockPos).method_26215()) {
                return;
            }
            class_4466 bee = (class_4466)class_1299.field_20346.method_5883(this.method_37908());
            if (bee == null) {
                return;
            }
            bee.method_29514(this.method_29507());
            bee.method_29513(this.method_29508());
            bee.method_5980(this.method_5968());
            bee.method_5641((double)spawnBlockPos.method_10263() + 0.5, (double)spawnBlockPos.method_10264() + 0.5, (double)spawnBlockPos.method_10260() + 0.5, this.field_5974.method_43057() * 360.0f, 0.0f);
            bee.method_5943((class_5425)((class_3218)this.method_37908()), this.method_37908().method_8404(spawnBlockPos), class_3730.field_16461, null);
            bee.method_6092(new class_1293(class_1294.field_5920, Integer.MAX_VALUE, 0, true, false, false));
            this.method_37908().method_8649((class_1297)bee);
            this.spawnAngryParticles(6);
            this.setQueenPose(BeeQueenState.ATTACKING);
        } else {
            this.setBeeSpawnCooldown(beeCooldown - 1);
        }
    }

    private void performGroundTrades() {
        if (!BzGeneralConfigs.beeQueenGroundPickup) {
            return;
        }
        int throwCooldown = this.getThrowCooldown();
        if (throwCooldown > 0) {
            this.setThrowCooldown(throwCooldown - 1);
        }
        if ((this.method_37908().method_8510() + this.method_5667().getLeastSignificantBits()) % 20L == 0L && throwCooldown <= 0) {
            class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
            class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
            class_238 scanArea = this.method_5829().method_35580(0.45, 0.9, 0.45).method_989(forwardVect.method_10216() * 0.5, -0.95, forwardVect.method_10215() * 0.5);
            List items = this.method_37908().method_18467(class_1542.class, scanArea);
            items.stream().filter(ie -> !ie.method_6977()).findFirst().ifPresent(itemEntity -> this.tradeItemEntity((class_1542)itemEntity, forwardVect, sideVect));
        }
    }

    private void tradeItemEntity(class_1542 itemEntity, class_243 forwardVect, class_243 sideVect) {
        class_1657 class_16572;
        Optional reward;
        int tradedItems = 0;
        class_1792 item = itemEntity.method_6983().method_7909();
        boolean didSpecialDayTrade = false;
        if (this.getIsSpecialDay() && QueensTradeManager.QUEENS_TRADE_MANAGER.specialDayQueenTrades.containsKey((Object)item)) {
            Optional<Pair<QueensTradeManager.SpecialDaysEntry, class_6012<WeightedTradeResult>>> specialDayItems = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItems(item);
            if (specialDayItems.isPresent()) {
                reward = ((class_6012)specialDayItems.get().getSecond()).method_34992(this.field_5974);
                if (reward.isPresent()) {
                    this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), itemEntity.method_6983(), ((ItemEntityAccessor)itemEntity).bumblezone$getThrower(), (QueensTradeManager.SpecialDaysEntry)specialDayItems.get().getFirst());
                    ++tradedItems;
                }
            } else {
                this.setIsSpecialDay(false);
            }
        }
        if (!didSpecialDayTrade && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
            for (int i = 0; i < itemEntity.method_6983().method_7947(); ++i) {
                reward = ((class_6012)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).method_34992(this.field_5974);
                if (!reward.isPresent()) continue;
                this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), itemEntity.method_6983(), ((ItemEntityAccessor)itemEntity).bumblezone$getThrower());
                ++tradedItems;
            }
        }
        if (tradedItems > 0) {
            itemEntity.method_5650(class_1297.class_5529.field_26999);
        } else {
            itemEntity.method_5650(class_1297.class_5529.field_26999);
            class_1542 rejectedItemEntity = new class_1542(this.method_37908(), this.method_23317() + sideVect.method_10216() * 1.75 + forwardVect.method_10216() * 1.0, this.method_23318() + 0.3, this.method_23321() + sideVect.method_10215() * 1.75 + forwardVect.method_10216() * 1.0, itemEntity.method_6983(), (double)((this.field_5974.method_43057() - 0.5f) / 10.0f) + forwardVect.method_10216() / 3.0, (double)0.4f, (double)((this.field_5974.method_43057() - 0.5f) / 10.0f) + forwardVect.method_10215() / 3.0);
            this.method_37908().method_8649((class_1297)rejectedItemEntity);
            rejectedItemEntity.method_6988();
            this.spawnAngryParticles(2);
            this.setQueenPose(BeeQueenState.ITEM_REJECT);
        }
        this.setThrowCooldown(50);
        if (tradedItems > 0 && itemEntity.method_24921() != null && (class_16572 = this.method_37908().method_18470(itemEntity.method_24921().method_5667())) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            ((GenericTrigger)((Object)BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.get())).trigger(serverPlayer);
            PlayerDataHandler.onQueenBeeTrade((class_1657)serverPlayer, tradedItems);
            if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                ModuleHelper.getModule((class_1297)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                    if (!capability.receivedEssencePrize) {
                        this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, class_1799.field_8037, serverPlayer.method_5667());
                        capability.receivedEssencePrize = true;
                        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.mention_reset").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                    }
                });
            }
        }
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_5987()) {
            return class_1269.field_5811;
        }
        if (this.method_29511() || hand == class_1268.field_5810) {
            return class_1269.field_5814;
        }
        class_1799 stack = player.method_5998(hand);
        class_1792 item = stack.method_7909();
        if (stack.method_7960() && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                ModuleHelper.getModule((class_1297)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                    if (!capability.receivedEssencePrize) {
                        class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
                        class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
                        this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, class_1799.field_8037, serverPlayer.method_5667());
                        capability.receivedEssencePrize = true;
                        serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.mention_reset").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                    } else {
                        long timeDiff = this.method_37908().method_8510() - capability.tradeResetPrimedTime;
                        if (timeDiff < 200L && timeDiff > 10L) {
                            this.resetAdvancementTree(serverPlayer, BzCriterias.QUEENS_DESIRE_ROOT_ADVANCEMENT);
                            capability.resetAllTrackerStats();
                            serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.reset_advancements").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                        } else {
                            capability.tradeResetPrimedTime = this.method_37908().method_8510();
                            serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.advancements_warning").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                        }
                    }
                });
            }
            return class_1269.field_5811;
        }
        boolean traded = false;
        if (QueensTradeManager.QUEENS_TRADE_MANAGER.specialDayQueenTrades.containsKey((Object)item)) {
            Optional<Pair<QueensTradeManager.SpecialDaysEntry, class_6012<WeightedTradeResult>>> specialDayItems = QueensTradeManager.QUEENS_TRADE_MANAGER.getSpecialDayItems(item);
            if (specialDayItems.isPresent()) {
                if (this.method_37908().method_8608()) {
                    return class_1269.field_5812;
                }
                class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
                class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
                Optional reward = ((class_6012)specialDayItems.get().getSecond()).method_34992(this.field_5974);
                if (reward.isPresent()) {
                    this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), stack, player.method_5667(), (QueensTradeManager.SpecialDaysEntry)specialDayItems.get().getFirst());
                    traded = true;
                }
            } else {
                this.setIsSpecialDay(false);
            }
        }
        if (!traded && QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.containsKey((Object)item)) {
            if (this.method_37908().method_8608()) {
                return class_1269.field_5812;
            }
            class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
            class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
            Optional reward = ((class_6012)QueensTradeManager.QUEENS_TRADE_MANAGER.queenTrades.get((Object)item)).method_34992(this.field_5974);
            if (reward.isPresent()) {
                this.spawnReward(forwardVect, sideVect, (WeightedTradeResult)reward.get(), stack, player.method_5667());
                traded = true;
            }
        }
        if (!this.method_37908().method_8608()) {
            if (!traded) {
                this.spawnAngryParticles(2);
                this.setQueenPose(BeeQueenState.ITEM_REJECT);
            } else {
                this.setThrowCooldown(50);
                stack.method_7934(1);
                player.method_6122(hand, stack);
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    ((GenericTrigger)((Object)BzCriterias.BEE_QUEEN_FIRST_TRADE_TRIGGER.get())).trigger(serverPlayer);
                    PlayerDataHandler.onQueenBeeTrade((class_1657)serverPlayer);
                    if (BeeQueenEntity.finalbeeQueenAdvancementDone(serverPlayer)) {
                        ModuleHelper.getModule((class_1297)serverPlayer, ModuleRegistry.PLAYER_DATA).ifPresent(capability -> {
                            if (!capability.receivedEssencePrize) {
                                class_243 forwardVect = class_243.method_1030((float)0.0f, (float)this.method_43078());
                                class_243 sideVect = class_243.method_1030((float)0.0f, (float)(this.method_43078() - 90.0f));
                                this.spawnReward(forwardVect, sideVect, ESSENCE_DROP, class_1799.field_8037, serverPlayer.method_5667());
                                capability.receivedEssencePrize = true;
                                serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"entity.the_bumblezone.bee_queen.mention_reset").method_27692(class_124.field_1056).method_27692(class_124.field_1065), false);
                            }
                        });
                    }
                }
                return class_1269.field_5812;
            }
        }
        return class_1269.field_5811;
    }

    private void resetAdvancementTree(class_3222 serverPlayer, class_2960 advancementRL) {
        class_163 tree = serverPlayer.field_13995.method_3851().method_53646();
        class_8779 parentAdvancement = serverPlayer.field_13995.method_3851().method_12896(advancementRL);
        if (parentAdvancement == null) {
            return;
        }
        class_8781 advancementParentNode = tree.method_53690(parentAdvancement);
        if (advancementParentNode == null) {
            return;
        }
        class_8779 beeEssenceAdvancementHolder = serverPlayer.field_13995.method_3851().method_12896(BEE_ESSENCE_ADVANCEMENT_RL);
        Iterable advancements = advancementParentNode.method_53653();
        for (class_8781 advancementChildNode : advancements) {
            if (advancementChildNode.method_53649().equals((Object)beeEssenceAdvancementHolder)) continue;
            class_167 advancementprogress = serverPlayer.method_14236().method_12882(advancementChildNode.method_53649());
            for (String criteria : advancementprogress.method_734()) {
                serverPlayer.method_14236().method_12883(advancementChildNode.method_53649(), criteria);
            }
            this.resetAdvancementTree(serverPlayer, advancementChildNode.method_53649().comp_1919());
        }
    }

    private static boolean finalbeeQueenAdvancementDone(class_3222 serverPlayer) {
        class_8779 advancementHolder = serverPlayer.field_13995.method_3851().method_12896(BzCriterias.QUEENS_DESIRE_FINAL_ADVANCEMENT);
        if (advancementHolder == null) {
            return false;
        }
        Map<class_8779, class_167> advancementsProgressMap = ((PlayerAdvancementsAccessor)serverPlayer.method_14236()).bumblezone$getProgress();
        return advancementsProgressMap.containsKey(advancementHolder) && advancementsProgressMap.get(advancementHolder).method_740();
    }

    private void spawnReward(class_243 forwardVect, class_243 sideVect, WeightedTradeResult reward, class_1799 originalItem, UUID playerUUID) {
        this.spawnReward(forwardVect, sideVect, reward, originalItem, playerUUID, null);
    }

    private void spawnReward(class_243 forwardVect, class_243 sideVect, WeightedTradeResult reward, class_1799 originalItem, UUID playerUUID, QueensTradeManager.SpecialDaysEntry specialDaysEntry) {
        int currentItemStackCount;
        class_1657 player;
        int rewardMultiplier = 1;
        if (specialDaysEntry != null && playerUUID != null && (player = this.method_37908().method_18470(playerUUID)) != null) {
            player.method_7353((class_2561)class_2561.method_43471((String)specialDaysEntry.specialMessage()).method_27692(specialDaysEntry.textColor()), true);
        }
        class_1799 chosenItem = reward.getItems().get(this.field_5974.method_43048(reward.getItems().size()));
        int itemStackMaxSize = chosenItem.method_7914();
        for (int remainingItemToSpawn = reward.count * rewardMultiplier; remainingItemToSpawn > 0; remainingItemToSpawn -= currentItemStackCount) {
            class_1937 class_19372;
            class_1799 rewardItem = chosenItem.method_46651(1);
            this.setQueenPose(BeeQueenState.ITEM_THROW);
            currentItemStackCount = Math.min(remainingItemToSpawn, itemStackMaxSize);
            rewardItem.method_7939(currentItemStackCount);
            class_1542 rewardItemEntity = new class_1542(this.method_37908(), this.method_23317() + sideVect.method_10216() * 0.9 + forwardVect.method_10216() * 1.0, this.method_23318() + 0.3, this.method_23321() + sideVect.method_10215() * 0.9 + forwardVect.method_10216() * 1.0, rewardItem, (double)((this.field_5974.method_43057() - 0.5f) / 10.0f) + forwardVect.method_10216() / 4.0, (double)0.3f, (double)((this.field_5974.method_43057() - 0.5f) / 10.0f) + forwardVect.method_10215() / 4.0);
            this.method_37908().method_8649((class_1297)rewardItemEntity);
            rewardItemEntity.method_6988();
            this.spawnHappyParticles();
            if (reward.xpReward <= 0 || !((class_19372 = this.method_37908()) instanceof class_3218)) continue;
            class_3218 serverLevel = (class_3218)class_19372;
            class_1303.method_31493((class_3218)serverLevel, (class_243)new class_243(this.method_23317() + forwardVect.method_10216() * 1.0, this.method_23318() + 0.3, this.method_23321() + forwardVect.method_10216() * 1.0), (int)reward.xpReward);
        }
        this.method_37908().method_8396(null, this.method_24515(), (class_3414)BzSounds.BEE_QUEEN_HAPPY.get(), class_3419.field_15254, 1.0f, this.method_59922().method_43057() * 0.2f + 0.6f);
    }

    boolean isLookingAtMeClose(class_1657 player) {
        class_243 normalizedPlayerView = player.method_5828(1.0f).method_1029();
        class_243 diff = new class_243(this.method_23317() - player.method_23317(), this.method_23320() - 0.2 - player.method_23320(), this.method_23321() - player.method_23321());
        double d = diff.method_1033();
        double dotProduct = normalizedPlayerView.method_1026(diff = diff.method_1029());
        return dotProduct > 0.9 - 0.025 / d && player.method_6057((class_1297)this);
    }

    public void spawnAngryParticles(int particles) {
        if (!this.method_37908().method_8608()) {
            ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11231, this.method_23317(), this.method_23318() + (double)0.45f, this.method_23321(), particles, (double)(this.method_59922().method_43057() - 0.5f), (double)(this.method_59922().method_43057() * 0.4f + 0.4f), (double)(this.method_59922().method_43057() - 0.5f), (double)(this.method_59922().method_43057() * 0.8f + 0.4f));
        }
    }

    private void spawnHappyParticles() {
        ((class_3218)this.method_37908()).method_14199((class_2394)class_2398.field_11211, this.method_23317(), this.method_23318() + 0.75, this.method_23321(), 5, 0.8, 0.75, 0.8, (double)this.method_59922().method_43057() + 0.5);
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageableEntity) {
        class_4466 bee = (class_4466)class_1299.field_20346.method_5883((class_1937)serverWorld);
        bee.method_7217(true);
        return bee;
    }

    public int method_20240() {
        return 1;
    }

    public int method_5978() {
        return 90;
    }

    public int getThrowCooldown() {
        return (Integer)this.field_6011.method_12789(THROWCOOLDOWN);
    }

    public void setThrowCooldown(Integer cooldown) {
        this.field_6011.method_12778(THROWCOOLDOWN, (Object)cooldown);
    }

    public int getBeeSpawnCooldown() {
        return (Integer)this.field_6011.method_12789(BEESPAWNCOOLDOWN);
    }

    public void setBeeSpawnCooldown(Integer cooldown) {
        this.field_6011.method_12778(BEESPAWNCOOLDOWN, (Object)cooldown);
    }

    public int method_29507() {
        return (Integer)this.field_6011.method_12789(REMAINING_ANGER_TIME);
    }

    public void method_29514(int remainingPersistentAngerTime) {
        this.field_6011.method_12778(REMAINING_ANGER_TIME, (Object)remainingPersistentAngerTime);
    }

    public UUID method_29508() {
        return this.persistentAngerTarget;
    }

    public void method_29513(UUID uuid) {
        this.persistentAngerTarget = uuid;
    }

    public void method_29509() {
        this.method_29514(PERSISTENT_ANGER_TIME.method_35008(this.field_5974));
    }

    public void method_29922() {
        super.method_29922();
        this.setBeeSpawnCooldown(0);
        this.method_5980(null);
    }

    protected void method_5712(class_2338 pos, class_2680 blockState) {
    }

    protected class_3414 method_5994() {
        return (class_3414)BzSounds.BEE_QUEEN_LOOP.get();
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return (class_3414)BzSounds.BEE_QUEEN_HURT.get();
    }

    protected class_3414 method_6002() {
        return (class_3414)BzSounds.BEE_QUEEN_DEATH.get();
    }

    public boolean method_5931() {
        return false;
    }

    public class_243 method_29919() {
        return new class_243(0.0, (double)(0.5f * this.method_5751()), (double)(this.method_17681() * 0.2f));
    }
}

