/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities.datamanagers.pollenpuffentityflowers;

import com.google.gson.JsonElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.utils.BzNbtPredicate;
import com.telepathicgrunt.the_bumblezone.utils.LenientUnboundedMapCodec;
import com.telepathicgrunt.the_bumblezone.utils.PlatformHooks;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_4657;
import net.minecraft.class_7922;
import net.minecraft.class_7923;

public class PollenPuffEntityPollinateManager
extends class_4309 {
    public static final PollenPuffEntityPollinateManager POLLEN_PUFF_ENTITY_POLLINATE_MANAGER = new PollenPuffEntityPollinateManager();
    public static final Codec<Map<class_1299<?>, List<EntryObject>>> CODEC = new LenientUnboundedMapCodec(class_2960.field_25139.comapFlatMap(r -> {
        Optional entityTypeOptional = class_7923.field_41177.method_17966(r);
        if (entityTypeOptional.isPresent()) {
            return DataResult.success((Object)((class_1299)entityTypeOptional.get()));
        }
        if (PlatformHooks.isModLoaded(r.method_12836())) {
            Bumblezone.LOGGER.error("Bz Pollination File Reading Error - Unknown EntityType:  " + String.valueOf(r));
            return DataResult.error(() -> "Bz Error - Unknown EntityType:  " + String.valueOf(r) + "  - ");
        }
        return DataResult.error(() -> "Bz Error - Target mod not present");
    }, arg_0 -> ((class_7922)class_7923.field_41177).method_10221(arg_0)), Codec.list(EntryObject.ENTRY_CODEC));
    public final Map<class_1299<?>, List<EntryObject>> mobToPlants = new Object2ObjectArrayMap();

    public PollenPuffEntityPollinateManager() {
        super(Bumblezone.GSON, "bz_pollen_puff_entity_flowers");
    }

    protected void apply(Map<class_2960, JsonElement> loader, class_3300 manager, class_3695 profiler) {
        this.mobToPlants.clear();
        loader.forEach((fileIdentifier, jsonElement) -> {
            try {
                DataResult mapDataResult = CODEC.parse((DynamicOps)JsonOps.INSTANCE, jsonElement);
                mapDataResult.error().ifPresent(e -> {
                    if (!e.message().contains("Bz Error - Target mod not present")) {
                        Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse pollen puff entity to flower file {} - Error: {}", fileIdentifier, e);
                    }
                });
                Map newMap = mapDataResult.resultOrPartial(s -> {}).orElse(new HashMap());
                newMap.forEach((e, v) -> {
                    if (this.mobToPlants.containsKey(e)) {
                        this.mobToPlants.get(e).addAll((Collection<EntryObject>)v);
                    } else {
                        this.mobToPlants.put((class_1299<?>)e, (List<EntryObject>)v);
                    }
                });
            }
            catch (Exception e2) {
                Bumblezone.LOGGER.error("Bumblezone Error: Couldn't parse pollen puff entity to flower file: {}", fileIdentifier, (Object)e2);
            }
        });
    }

    public class_4657 getPossiblePlants(class_1297 entity) {
        if (this.mobToPlants.containsKey(entity.method_5864())) {
            for (EntryObject entryObject : this.mobToPlants.get(entity.method_5864())) {
                if (!entryObject.nbtPredicate().matches(entity)) continue;
                return entryObject.weightedStateProvider();
            }
        }
        return null;
    }

    public record EntryObject(BzNbtPredicate nbtPredicate, class_4657 weightedStateProvider) {
        public static final Codec<EntryObject> ENTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)BzNbtPredicate.CODEC.fieldOf("nbt_match").orElse((Object)BzNbtPredicate.ANY).forGetter(config -> config.nbtPredicate), (App)class_4657.field_24946.fieldOf("plants_to_spawn").forGetter(config -> config.weightedStateProvider)).apply((Applicative)instance, instance.stable(EntryObject::new)));
    }
}

