/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.entities;

import com.telepathicgrunt.the_bumblezone.Bumblezone;
import com.telepathicgrunt.the_bumblezone.advancements.EntitySpecificTrigger;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.client.MusicHandler;
import com.telepathicgrunt.the_bumblezone.configs.BzBeeAggressionConfigs;
import com.telepathicgrunt.the_bumblezone.configs.BzClientConfigs;
import com.telepathicgrunt.the_bumblezone.effects.WrathOfTheHiveEffect;
import com.telepathicgrunt.the_bumblezone.events.block.BzBlockBreakEvent;
import com.telepathicgrunt.the_bumblezone.events.entity.BzEntityHurtEvent;
import com.telepathicgrunt.the_bumblezone.events.player.BzPlayerPickupItemEvent;
import com.telepathicgrunt.the_bumblezone.events.player.BzPlayerTickEvent;
import com.telepathicgrunt.the_bumblezone.items.FlowerHeadwearHelmet;
import com.telepathicgrunt.the_bumblezone.items.essence.EssenceOfTheBees;
import com.telepathicgrunt.the_bumblezone.modcompat.ModChecker;
import com.telepathicgrunt.the_bumblezone.modcompat.ModCompat;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEffects;
import com.telepathicgrunt.the_bumblezone.modinit.BzTags;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3483;
import net.minecraft.class_4466;
import net.minecraft.class_5138;
import net.minecraft.class_5250;
import net.minecraft.class_6025;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_9636;

public class BeeAggression {
    private static final Set<String> LIST_OF_BEE_HATING_NAMES = Set.of("bear", "panda", "wasp", "spider");
    private static final Set<class_1299<?>> SET_OF_BEE_HATED_NAMED_ENTITIES = new HashSet();
    private static final Set<class_1299<?>> SET_OF_BEE_NAMED_ENTITIES = new HashSet();

    public static void setupBeeHatingList() {
        for (class_2960 id : class_7923.field_41177.method_10235()) {
            String mobName = id.method_12832();
            if (mobName.contains("bee") || mobName.contains("bumble_beast")) {
                SET_OF_BEE_NAMED_ENTITIES.add((class_1299)class_7923.field_41177.method_10223(id));
            }
            if (!LIST_OF_BEE_HATING_NAMES.stream().anyMatch(mobName::contains)) continue;
            SET_OF_BEE_HATED_NAMED_ENTITIES.add((class_1299)class_7923.field_41177.method_10223(id));
        }
    }

    public static void minedBlockAnger(boolean cancelled, BzBlockBreakEvent event) {
        if (cancelled) {
            return;
        }
        class_1657 player = event.player();
        class_2680 blockState = event.state();
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (blockState.method_26164(BzTags.WRATH_ACTIVATING_BLOCKS_WHEN_MINED)) {
                if (blockState.method_27852((class_2248)BzBlocks.HONEYCOMB_BROOD.get()) && class_1890.method_60138((class_1799)serverPlayer.method_6047(), (class_6862)class_9636.field_51553)) {
                    return;
                }
                BeeAggression.angerBees(serverPlayer, blockState.method_27852((class_2248)BzBlocks.HONEYCOMB_BROOD.get()));
            }
        }
    }

    public static void pickupItemAnger(BzPlayerPickupItemEvent event) {
        class_1657 player = event.player();
        class_1799 itemStack = event.item();
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            if (itemStack.method_31573(BzTags.WRATH_ACTIVATING_ITEMS_WHEN_PICKED_UP)) {
                BeeAggression.angerBees(serverPlayer, false);
            }
        }
    }

    private static void angerBees(class_3222 player, boolean removesProt) {
        if ((player.method_37908().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) || BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) && BzBeeAggressionConfigs.aggressiveBees && !player.method_7337() && !player.method_7325()) {
            if (!player.method_6059(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
                if (!EssenceOfTheBees.hasEssence(player) && player.method_37908().method_8407() != class_1267.field_5801) {
                    class_5250 message = class_2561.method_43471((String)"system.the_bumblezone.no_protection").method_27692(class_124.field_1067).method_27692(class_124.field_1061);
                    player.method_7353((class_2561)message, true);
                    player.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                }
            } else {
                ((GenericTrigger)((Object)BzCriterias.HONEY_PERMISSION_TRIGGER.get())).trigger(player);
                if (removesProt) {
                    player.method_6016(BzEffects.PROTECTION_OF_THE_HIVE.holder());
                }
            }
        }
    }

    public static void onLivingEntityHurt(BzEntityHurtEvent event) {
        class_1309 livingEntity = event.entity();
        if (event.amount() > 0.0f && livingEntity != null && !livingEntity.method_37908().method_8608() && livingEntity instanceof class_4466 && event.source() != null && event.source().method_5529() != null && livingEntity.method_37908().method_8407() != class_1267.field_5801) {
            BeeAggression.beeHitAndAngered((class_1297)livingEntity, event.source().method_5529());
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static void beeHitAndAngered(class_1297 entity, class_1297 attackerEntity) {
        if (attackerEntity instanceof class_1657) {
            class_1657 player = (class_1657)attackerEntity;
            if (!((class_1657)attackerEntity).method_7337() && !attackerEntity.method_7325()) {
                if (player.method_6059(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
                    player.method_6016(BzEffects.PROTECTION_OF_THE_HIVE.holder());
                    WrathOfTheHiveEffect.calmTheBees(player.method_37908(), (class_1309)player);
                    return;
                }
                if (!entity.method_37908().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
                    if (!BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) return;
                }
                if (!BzBeeAggressionConfigs.aggressiveBees) return;
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    ((EntitySpecificTrigger)((Object)BzCriterias.BEE_HIT_WRATH_OF_THE_HIVE_TRIGGER.get())).trigger(serverPlayer, attackerEntity);
                }
                player.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
                return;
            }
        }
        if (!(attackerEntity instanceof class_1308)) return;
        class_1308 mob = (class_1308)attackerEntity;
        if (mob.method_6059(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
            mob.method_6016(BzEffects.PROTECTION_OF_THE_HIVE.holder());
            WrathOfTheHiveEffect.calmTheBees(mob.method_37908(), (class_1309)mob);
            return;
        }
        if (!entity.method_37908().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            if (!BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone) return;
        }
        if (!BzBeeAggressionConfigs.aggressiveBees) return;
        mob.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, true));
    }

    public static void entityTypeBeeAnger(class_1297 entity) {
        if (BeeAggression.doesBeesHateEntity(entity)) {
            ((class_1308)entity).method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 1, false, true));
        }
        if (entity != null && entity.method_37908() != null && !entity.method_37908().method_8608() && entity.method_37908().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
            for (ModCompat compat : ModChecker.DIM_SPAWN_COMPATS) {
                compat.onEntitySpawnInDimension(entity);
            }
        }
    }

    public static boolean doesBeesHateEntity(class_1297 entity) {
        class_6025 ownableEntity;
        class_1308 mobEntity;
        if (entity != null && entity.method_37908() != null && !entity.method_37908().method_8608() && entity.method_37908().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID) && BzBeeAggressionConfigs.aggressiveBees && entity instanceof class_1308 && !(mobEntity = (class_1308)entity).method_5987() && (!(entity instanceof class_6025) || (ownableEntity = (class_6025)entity).method_6139() == null)) {
            if (mobEntity.method_5864().method_20210(BzTags.FORCED_BEE_CALM_AT)) {
                return false;
            }
            if (mobEntity.method_5864().method_20210(BzTags.FORCED_BEE_ANGRY_AT)) {
                return true;
            }
            return SET_OF_BEE_HATED_NAMED_ENTITIES.contains(entity.method_5864()) || !SET_OF_BEE_NAMED_ENTITIES.contains(entity.method_5864()) && mobEntity.method_5864().method_20210(class_3483.field_48289);
        }
        return false;
    }

    public static boolean isBeelikeEntity(class_1297 entity) {
        return SET_OF_BEE_NAMED_ENTITIES.contains(entity.method_5864());
    }

    public static boolean isBeelikeEntityType(class_1299<?> type) {
        return SET_OF_BEE_NAMED_ENTITIES.contains(type);
    }

    public static void playerTick(BzPlayerTickEvent event) {
        class_1657 playerEntity = event.player();
        if (!playerEntity.method_37908().method_8608() && playerEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE.holder())) {
            if (playerEntity.method_37908().method_8407() == class_1267.field_5801) {
                playerEntity.method_6016(BzEffects.WRATH_OF_THE_HIVE.holder());
                WrathOfTheHiveEffect.calmTheBees(playerEntity.method_37908(), (class_1309)playerEntity);
            } else if (!BzBeeAggressionConfigs.allowWrathOfTheHiveOutsideBumblezone && !playerEntity.method_37908().method_27983().method_29177().equals((Object)Bumblezone.MOD_DIMENSION_ID)) {
                playerEntity.method_6016(BzEffects.WRATH_OF_THE_HIVE.holder());
                WrathOfTheHiveEffect.calmTheBees(playerEntity.method_37908(), (class_1309)playerEntity);
            }
        }
        if (playerEntity.method_37908().method_8608()) {
            boolean wrathEffect = playerEntity.method_6059(BzEffects.WRATH_OF_THE_HIVE.holder());
            if (wrathEffect) {
                MusicHandler.playStopAngryBeeMusic(playerEntity, BzClientConfigs.playWrathOfHiveEffectMusic);
            }
            if (!WrathOfTheHiveEffect.ACTIVE_WRATH && wrathEffect) {
                WrathOfTheHiveEffect.ACTIVE_WRATH = true;
            } else if (WrathOfTheHiveEffect.ACTIVE_WRATH && !wrathEffect) {
                MusicHandler.playStopAngryBeeMusic(playerEntity, false);
                WrathOfTheHiveEffect.calmTheBees(playerEntity.method_37908(), (class_1309)playerEntity);
                WrathOfTheHiveEffect.ACTIVE_WRATH = false;
            }
        }
    }

    public static void applyAngerIfInTaggedStructures(class_3222 serverPlayer) {
        class_5138 structureManager = ((class_3218)serverPlayer.method_37908()).method_27056();
        if (structureManager.method_57560(serverPlayer.method_24515(), BzTags.WRATH_CAUSING).method_16657()) {
            if (!FlowerHeadwearHelmet.getFlowerHeadwear((class_1309)serverPlayer).method_7960()) {
                ((GenericTrigger)((Object)BzCriterias.FLOWER_HEADWEAR_WRATH_STRUCTURE_TRIGGER.get())).trigger(serverPlayer);
                return;
            }
            if (serverPlayer.method_7337() || serverPlayer.method_7325() || EssenceOfTheBees.hasEssence(serverPlayer)) {
                return;
            }
            if (!BzBeeAggressionConfigs.aggressiveBees || serverPlayer.method_37908().method_8407() == class_1267.field_5801) {
                return;
            }
            if (!serverPlayer.method_6059(BzEffects.PROTECTION_OF_THE_HIVE.holder())) {
                if (!serverPlayer.method_6059(BzEffects.WRATH_OF_THE_HIVE.holder())) {
                    class_5250 message = class_2561.method_43471((String)"system.the_bumblezone.no_protection").method_27692(class_124.field_1067).method_27692(class_124.field_1061);
                    serverPlayer.method_7353((class_2561)message, true);
                }
                serverPlayer.method_6092(new class_1293(BzEffects.WRATH_OF_THE_HIVE.holder(), BzBeeAggressionConfigs.howLongWrathOfTheHiveLasts, 2, false, BzBeeAggressionConfigs.showWrathOfTheHiveParticles, true));
            }
        }
    }

    public static void preventAngerOnEssencedPlayers(List<class_4466> beeList, List<class_1657> playerList) {
        for (int i = playerList.size() - 1; i >= 0; --i) {
            class_3222 serverPlayer;
            class_1657 player = playerList.get(i);
            if (!(player instanceof class_3222) || !EssenceOfTheBees.hasEssence(serverPlayer = (class_3222)player)) continue;
            for (class_4466 bee : beeList) {
                if (bee.method_5968() != player) continue;
                bee.method_5980(null);
            }
            playerList.remove(i);
        }
    }

    public static void preventAngerOnEssencedPlayers(class_1657 player, List<class_1297> entityList) {
        class_3222 serverPlayer;
        if (player != null && player.method_37908().method_8608() || player instanceof class_3222 && EssenceOfTheBees.hasEssence(serverPlayer = (class_3222)player)) {
            entityList.clear();
        }
    }
}

