/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.enchantments;

import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.enchantments.datacomponents.CombCutterMarker;
import com.telepathicgrunt.the_bumblezone.events.player.BzPlayerBreakSpeedEvent;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzEnchantments;
import com.telepathicgrunt.the_bumblezone.utils.EnchantmentUtils;
import com.telepathicgrunt.the_bumblezone.utils.GeneralUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_4481;
import net.minecraft.class_7923;
import net.minecraft.class_9331;

public class CombCutterEnchantmentApplication {
    private static final GeneralUtils.Lazy<Set<class_2248>> TARGET_BLOCKS = new GeneralUtils.Lazy();
    private static final GeneralUtils.Lazy<Set<class_2248>> LESSER_TARGET_BLOCKS = new GeneralUtils.Lazy();

    public static Pair<CombCutterMarker, Integer> getCombCutterEnchantLevel(class_1799 stack) {
        return class_1890.method_60174((class_1799)stack, (class_9331)((class_9331)BzEnchantments.COMB_CUTTER_MARKER.get()));
    }

    public static Set<class_2248> getTargetBlocks() {
        return TARGET_BLOCKS.getOrCompute(() -> {
            HashSet<class_2248> validBlocks = new HashSet<class_2248>();
            for (class_2960 key : class_7923.field_41175.method_10235()) {
                String path = key.method_12832();
                if (!path.contains("comb") && !path.contains("luminescent_wax") && !path.contains("ancient_wax")) continue;
                validBlocks.add((class_2248)class_7923.field_41175.method_10223(key));
            }
            return validBlocks;
        });
    }

    public static Set<class_2248> getLesserTargetBlocks() {
        return LESSER_TARGET_BLOCKS.getOrCompute(() -> {
            HashSet<class_2248> validBlocks = new HashSet<class_2248>();
            for (class_2960 key : class_7923.field_41175.method_10235()) {
                String path = key.method_12832();
                class_2248 block = (class_2248)class_7923.field_41175.method_10223(key);
                if (!(block instanceof class_4481) && !path.contains("hive") && !path.contains("nest") && (!path.contains("wax") || path.contains("waxed"))) continue;
                validBlocks.add(block);
            }
            return validBlocks;
        });
    }

    public static void attemptFasterMining(BzPlayerBreakSpeedEvent event) {
        if (CombCutterEnchantmentApplication.getTargetBlocks().contains(event.state().method_26204())) {
            CombCutterEnchantmentApplication.mineFaster(event, false);
        } else if (CombCutterEnchantmentApplication.getLesserTargetBlocks().contains(event.state().method_26204())) {
            CombCutterEnchantmentApplication.mineFaster(event, true);
        }
    }

    private static void mineFaster(BzPlayerBreakSpeedEvent event, boolean lesserTarget) {
        class_1657 playerEntity = event.player();
        class_1799 itemStack = playerEntity.method_6047();
        Pair<CombCutterMarker, Integer> enchantAndLevel = CombCutterEnchantmentApplication.getCombCutterEnchantLevel(itemStack);
        if (enchantAndLevel != null && (Integer)enchantAndLevel.getSecond() > 0 && !itemStack.method_7960()) {
            int destroyModifier = (int)Math.max(Math.ceil(event.state().method_26204().method_36555()), 0.0);
            double newSpeed = Math.min(Math.pow(((Integer)enchantAndLevel.getSecond()).intValue(), 2 + destroyModifier) + (double)(lesserTarget ? ((CombCutterMarker)enchantAndLevel.getFirst()).lesserTargetBlockBaseSpeedAddition() : ((CombCutterMarker)enchantAndLevel.getFirst()).mainTargetBlockBaseSpeedAddition()), 50.0);
            if (playerEntity.method_6059(class_1294.field_5901)) {
                int amplifier = playerEntity.method_6112(class_1294.field_5901).method_5578();
                if (amplifier < 0) {
                    amplifier = 3;
                }
                newSpeed /= (Math.pow(amplifier, 6.0) + 2.0) * 20.0;
            }
            event.speed().addAndGet(newSpeed);
        }
    }

    public static void increasedCombDrops(class_1657 playerEntity, class_1937 world, class_2338 pos) {
        class_1799 itemStack = playerEntity.method_6047();
        int equipmentLevel = class_1890.method_8203(EnchantmentUtils.getEnchantmentHolder(BzEnchantments.COMB_CUTTER, playerEntity.method_37908()), (class_1309)playerEntity);
        if (equipmentLevel > 0 && !itemStack.method_7960()) {
            class_2248.method_9577((class_1937)world, (class_2338)pos, (class_1799)new class_1799((class_1935)class_1802.field_20414, equipmentLevel * 3));
            if (playerEntity instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)playerEntity;
                ((GenericTrigger)((Object)BzCriterias.COMB_CUTTER_EXTRA_DROPS_TRIGGER.get())).trigger(serverPlayer);
            }
        }
    }
}

