/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.the_bumblezone.blocks;

import com.mojang.serialization.MapCodec;
import com.telepathicgrunt.the_bumblezone.advancements.GenericTrigger;
import com.telepathicgrunt.the_bumblezone.modinit.BzBlocks;
import com.telepathicgrunt.the_bumblezone.modinit.BzCriterias;
import com.telepathicgrunt.the_bumblezone.modinit.BzSounds;
import com.telepathicgrunt.the_bumblezone.platform.BlockExtension;
import com.telepathicgrunt.the_bumblezone.utils.OptionalBoolean;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1688;
import net.minecraft.class_1690;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2373;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2498;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3620;
import net.minecraft.class_3726;
import net.minecraft.class_4970;

public class RoyalJellyBlock
extends class_2373
implements BlockExtension {
    protected static final class_265 SHAPE = class_2248.method_9541((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0);
    public static final MapCodec<RoyalJellyBlock> CODEC = class_2248.method_54094(RoyalJellyBlock::new);

    public RoyalJellyBlock() {
        this(class_4970.class_2251.method_9637().method_31710(class_3620.field_16014).method_23351(0.4f).method_23352(0.5f).method_22488().method_9626(class_2498.field_21214));
    }

    public RoyalJellyBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    public MapCodec<? extends RoyalJellyBlock> method_53969() {
        return CODEC;
    }

    @Override
    public boolean bz$isStickyBlock(class_2680 state) {
        return state.method_26204() == BzBlocks.ROYAL_JELLY_BLOCK.get();
    }

    @Override
    public OptionalBoolean bz$canStickTo(class_2680 state, class_2680 other) {
        if (state.method_26204() == BzBlocks.ROYAL_JELLY_BLOCK.get()) {
            if (other.method_26204() == class_2246.field_21211 || other.method_26204() == class_2246.field_10030) {
                return OptionalBoolean.FALSE;
            }
            return OptionalBoolean.TRUE;
        }
        return OptionalBoolean.EMPTY;
    }

    public static boolean isValidMoveDirection(class_2350 pushDirection, class_2350 pistonDirection) {
        return pushDirection == null || pushDirection != pistonDirection;
    }

    private static boolean doesEntityDoHoneyBlockSlideEffects(class_1297 entity) {
        return entity instanceof class_1309 || entity instanceof class_1688 || entity instanceof class_1541 || entity instanceof class_1690;
    }

    public class_265 method_9549(class_2680 blockState, class_1922 blockGetter, class_2338 blockPos, class_3726 collisionContext) {
        return SHAPE;
    }

    public void method_9554(class_1937 level, class_2680 blockState, class_2338 blockPos, class_1297 entity, float fallDistance) {
        entity.method_5783((class_3414)BzSounds.ROYAL_JELLY_BLOCK_SLIDE.get(), 1.0f, 1.0f);
        if (!level.field_9236) {
            RoyalJellyBlock.showJumpParticles((class_3218)level, entity);
        }
        if (entity.method_5747(fallDistance, 0.2f, level.method_48963().method_48827())) {
            entity.method_5783(this.field_23162.method_10593(), this.field_23162.method_10597() * 0.5f, this.field_23162.method_10599() * 0.75f);
        }
    }

    public void method_9548(class_2680 blockState, class_1937 level, class_2338 blockPos, class_1297 entity) {
        if (this.isSlidingDown(blockPos, entity)) {
            this.maybeDoSlideAchievement(entity, blockPos);
            this.doSlideMovement(entity);
            this.maybeDoSlideEffects(level, entity);
        }
        super.method_9548(blockState, level, blockPos, entity);
    }

    private boolean isSlidingDown(class_2338 blockPos, class_1297 entity) {
        if (entity.method_24828()) {
            return false;
        }
        if (entity.method_23318() > (double)blockPos.method_10264() + 0.9375 - 1.0E-7) {
            return false;
        }
        if (entity.method_18798().field_1351 >= -0.08) {
            return false;
        }
        double d0 = Math.abs((double)blockPos.method_10263() + 0.5 - entity.method_23317());
        double d1 = Math.abs((double)blockPos.method_10260() + 0.5 - entity.method_23321());
        double d2 = 0.4375 + (double)(entity.method_17681() / 2.0f);
        return d0 + 1.0E-7 > d2 || d1 + 1.0E-7 > d2;
    }

    private void maybeDoSlideAchievement(class_1297 entity, class_2338 blockPos) {
        class_3222 serverPlayer;
        if (entity instanceof class_3222 && (serverPlayer = (class_3222)entity).method_37908().method_8510() % 20L == 17L) {
            class_174.field_21628.method_23909(serverPlayer, serverPlayer.method_37908().method_8320(blockPos));
        }
    }

    public void method_9567(class_1937 level, class_2338 pos, class_2680 blockState, class_1309 entity, class_1799 itemStack) {
        if (entity instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)entity;
            boolean nextToStickyPiston = false;
            for (class_2350 direction : class_2350.values()) {
                if (!level.method_8320(pos.method_10093(direction)).method_27852(class_2246.field_10615)) continue;
                nextToStickyPiston = true;
                break;
            }
            if (nextToStickyPiston) {
                ((GenericTrigger)((Object)BzCriterias.ROYAL_JELLY_BLOCK_PISTON_TRIGGER.get())).trigger(serverPlayer);
            }
        }
    }

    private void doSlideMovement(class_1297 entity) {
        class_243 vec3 = entity.method_18798();
        if (vec3.field_1351 < -0.13) {
            double d0 = -0.05 / vec3.field_1351;
            entity.method_18799(new class_243(vec3.field_1352 * d0, -0.05, vec3.field_1350 * d0));
        } else {
            entity.method_18799(new class_243(vec3.field_1352, -0.05, vec3.field_1350));
        }
        entity.method_38785();
    }

    private void maybeDoSlideEffects(class_1937 level, class_1297 entity) {
        if (RoyalJellyBlock.doesEntityDoHoneyBlockSlideEffects(entity)) {
            if (level.method_8409().method_43048(5) == 0) {
                entity.method_5783((class_3414)BzSounds.ROYAL_JELLY_BLOCK_SLIDE.get(), 1.0f, 1.0f);
            }
            if (!level.field_9236 && level.method_8409().method_43048(5) == 0) {
                RoyalJellyBlock.showSlideParticles((class_3218)level, entity);
            }
        }
    }

    public static void showSlideParticles(class_3218 serverLevel, class_1297 entity) {
        RoyalJellyBlock.showParticles(serverLevel, entity, 5);
    }

    public static void showJumpParticles(class_3218 serverLevel, class_1297 entity) {
        RoyalJellyBlock.showParticles(serverLevel, entity, 10);
    }

    private static void showParticles(class_3218 serverLevel, class_1297 entity, int particleNumber) {
        class_2680 blockstate = ((class_2248)BzBlocks.ROYAL_JELLY_BLOCK.get()).method_9564();
        for (int i = 0; i < particleNumber; ++i) {
            serverLevel.method_8406((class_2394)new class_2388(class_2398.field_11217, blockstate), entity.method_23317(), entity.method_23318(), entity.method_23321(), 0.0, 0.0, 0.0);
        }
    }
}

