/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.util;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;

public class DelayedExecutor {
    private static final List<DelayedTask> tasks = new ArrayList<DelayedTask>();

    public static void init() {
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            ArrayList<DelayedTask> toRun = new ArrayList<DelayedTask>(tasks);
            for (DelayedTask task : toRun) {
                --task.ticksLeft;
                if (task.ticksLeft > 0) continue;
                task.runnable.run();
                tasks.remove(task);
            }
        });
    }

    public static void runLater(Runnable runnable, int delayTicks) {
        tasks.add(new DelayedTask(runnable, delayTicks));
    }

    private static class DelayedTask {
        Runnable runnable;
        int ticksLeft;

        DelayedTask(Runnable runnable, int ticksLeft) {
            this.runnable = runnable;
            this.ticksLeft = ticksLeft;
        }
    }
}

