/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkTracker;
import net.pixeldreamstudios.kevslibrary.util.DelayedExecutor;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class SoulLinkHandler {
    private static final int BASE_LINK_DURATION_TICKS = 200;
    private static final int MAX_LINKS = 4;
    private static final double LINK_RADIUS = 8.0;
    private static final int PULL_INTERVAL_TICKS = 10;
    private static final Set<UUID> linkedEntities = new HashSet<UUID>();

    public static void triggerSoulLink(class_1309 attacker, class_1309 primaryTarget) {
        class_3218 world = (class_3218)attacker.method_37908();
        if (SoulLinkTracker.getGroup(primaryTarget).isPresent()) {
            return;
        }
        List found = world.method_8390(class_1309.class, primaryTarget.method_5829().method_1014(8.0), e -> SoulLinkHandler.isValidTarget(e, attacker) && !linkedEntities.contains(e.method_5667()));
        if (found.isEmpty()) {
            return;
        }
        Collections.shuffle(found);
        ArrayList<class_1309> linked = new ArrayList<class_1309>();
        linked.add(primaryTarget);
        linkedEntities.add(primaryTarget.method_5667());
        for (class_1309 mob : found) {
            linked.add(mob);
            linkedEntities.add(mob.method_5667());
            if (linked.size() < 4) continue;
            break;
        }
        SoulLinkHandler.playLinkParticles(world, primaryTarget.method_19538());
        world.method_43128(null, primaryTarget.method_23317(), primaryTarget.method_23318(), primaryTarget.method_23321(), class_3417.field_43154, class_3419.field_15248, 0.8f, 1.2f);
        float soulPower = (float)SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (class_1309)attacker).baseValue();
        LinkedGroup group = new LinkedGroup(attacker, linked, soulPower);
        group.start();
        SoulLinkTracker.linkGroup(linked, attacker, soulPower, group);
    }

    public static void tryExtendLink(class_1309 attacker, class_1309 fromEntity) {
        Optional<SoulLinkTracker.LinkedGroupData> opt = SoulLinkTracker.getGroup(fromEntity);
        if (opt.isEmpty()) {
            return;
        }
        SoulLinkTracker.LinkedGroupData groupData = opt.get();
        List<class_1309> group = groupData.group();
        class_3218 world = (class_3218)attacker.method_37908();
        List candidates = world.method_8390(class_1309.class, fromEntity.method_5829().method_1014(8.0), e -> SoulLinkHandler.isValidTarget(e, attacker) && !group.contains(e) && !linkedEntities.contains(e.method_5667()));
        class_1309 nearest = candidates.stream().min(Comparator.comparingDouble(e -> e.method_5858((class_1297)fromEntity))).orElse(null);
        if (nearest == null) {
            return;
        }
        group.add(nearest);
        linkedEntities.add(nearest.method_5667());
        SoulLinkTracker.linkGroup(group, groupData.attacker(), groupData.soulPower(), groupData.handler());
        groupData.handler().extendLifetime();
        SoulLinkHandler.playLinkParticles(world, nearest.method_19538());
        world.method_43128(null, nearest.method_23317(), nearest.method_23318(), nearest.method_23321(), class_3417.field_43154, class_3419.field_15248, 0.6f, 1.0f);
    }

    public static void handleLinkedDamage(class_1309 attacker, class_1309 damaged, float originalDamage, List<class_1309> linked, float soulPower) {
        HashSet<class_1309> alreadyHit = new HashSet<class_1309>();
        for (class_1309 entity : linked) {
            class_1324 dmgAttr;
            boolean isCrit;
            if (!entity.method_5805()) continue;
            class_1324 soulLinkDamage = attacker.method_5996(KevsLibrary.SOUL_LINK_DAMAGE);
            SpellPower.Result soul = SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (class_1309)attacker);
            float spreadDamage = (float)(soulLinkDamage.method_6194() + soul.baseValue() * (double)0.4f * 5.0);
            boolean bl = isCrit = (double)attacker.method_59922().method_43057() < soul.criticalChance();
            if (isCrit) {
                spreadDamage = (float)((double)spreadDamage * soul.criticalDamage());
            }
            if ((dmgAttr = attacker.method_5996(KevsLibrary.DAMAGE)) != null) {
                spreadDamage = (float)((double)spreadDamage * dmgAttr.method_6194());
            }
            if (alreadyHit.contains(entity)) continue;
            alreadyHit.add(entity);
            entity.method_5643(attacker.method_48923().method_48831(), spreadDamage);
            class_243 pos = entity.method_19538();
            ((class_3218)attacker.method_37908()).method_14199((class_2394)class_2398.field_11205, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, 4, 0.2, 0.2, 0.2, 0.01);
        }
    }

    private static void playLinkParticles(class_3218 world, class_243 center) {
        for (int i = 0; i < 24; ++i) {
            double angle = 0.2617993877991494 * (double)i;
            double radius = 2.0;
            double x = center.field_1352 + Math.cos(angle) * radius;
            double z = center.field_1350 + Math.sin(angle) * radius;
            double y = center.field_1351 + 0.5;
            world.method_14199((class_2394)class_2398.field_11215, x, y, z, 1, 0.01, 0.01, 0.01, 0.01);
        }
    }

    private static boolean isValidTarget(class_1309 entity, class_1309 attacker) {
        class_1321 tameable;
        return entity.method_5805() && !entity.equals((Object)attacker) && !entity.method_5722((class_1297)attacker) && !(entity instanceof class_1657) && entity.method_5864().method_5891().method_6136() && (!(entity instanceof class_1321) || !(tameable = (class_1321)entity).method_6181());
    }

    public static class LinkedGroup {
        private final List<class_1309> members;
        private final class_1309 attacker;
        private final float soulPower;
        private int ticks = 0;
        private float currentExtension = 20.0f;

        LinkedGroup(class_1309 attacker, List<class_1309> members, float soulPower) {
            this.attacker = attacker;
            this.members = members;
            this.soulPower = soulPower;
        }

        void start() {
            this.tick();
        }

        void extendLifetime() {
            this.ticks -= (int)this.currentExtension;
            if (this.ticks < 0) {
                this.ticks = 0;
            }
            this.currentExtension *= 0.9f;
            if (this.currentExtension < 2.0f) {
                this.currentExtension = 2.0f;
            }
        }

        private void tick() {
            DelayedExecutor.runLater(() -> {
                if (this.ticks >= 200) {
                    this.members.forEach(e -> linkedEntities.remove(e.method_5667()));
                    SoulLinkTracker.clearLinks(this.members);
                    return;
                }
                if (this.ticks % 10 == 0) {
                    this.pullEntities();
                }
                this.drawArcs();
                ++this.ticks;
                this.tick();
            }, 1);
        }

        private void pullEntities() {
            if (this.members.isEmpty()) {
                return;
            }
            class_1309 anchor = this.members.get(0);
            class_243 center = anchor.method_19538();
            for (class_1309 entity : this.members) {
                if (!entity.method_5805() || entity.equals((Object)anchor)) continue;
                class_243 pull = center.method_1020(entity.method_19538()).method_1029().method_1021(0.5);
                entity.method_5762(pull.field_1352, 0.1, pull.field_1350);
            }
        }

        private void drawArcs() {
            class_3218 world = (class_3218)this.attacker.method_37908();
            class_243 a = this.members.get(0).method_19538();
            for (class_1309 b : this.members) {
                if (!b.method_5805() || b == this.members.get(0)) continue;
                class_243 bPos = b.method_19538();
                class_243 diff = bPos.method_1020(a);
                for (int i = 0; i <= 10; ++i) {
                    class_243 point = a.method_1019(diff.method_1021((double)i / 10.0));
                    world.method_14199((class_2394)class_2398.field_29644, point.field_1352, point.field_1351 + 1.0, point.field_1350, 1, 0.0, 0.0, 0.0, 0.001);
                }
            }
        }
    }
}

