/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.handler;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;

public class PiercingHandler {
    private static final Map<UUID, Long> activePiercers = new HashMap<UUID, Long>();
    private static final Map<UUID, Long> cooldownUntil = new HashMap<UUID, Long>();
    private static final long DURATION_MILLIS = 3000L;
    private static final long COOLDOWN_MILLIS = 250L;

    public static void tryActivatePiercing(class_1309 attacker) {
        double chance = attacker.method_45325(KevsLibrary.PIERCING_CHANCE);
        if (attacker.method_59922().method_43058() < chance) {
            activePiercers.put(attacker.method_5667(), System.currentTimeMillis());
            class_1937 class_19372 = attacker.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                class_243 pos = attacker.method_19538().method_1031(0.0, (double)attacker.method_5751(), 0.0);
                serverWorld.method_14199((class_2394)class_2398.field_11215, pos.field_1352, pos.field_1351, pos.field_1350, 20, 0.5, 0.5, 0.5, 0.1);
                serverWorld.method_14199((class_2394)class_2398.field_11207, pos.field_1352, pos.field_1351, pos.field_1350, 10, 0.2, 0.2, 0.2, 0.01);
            }
        }
    }

    public static boolean isPiercingActive(class_1309 attacker) {
        boolean expired;
        Long time = activePiercers.get(attacker.method_5667());
        if (time == null) {
            return false;
        }
        boolean bl = expired = System.currentTimeMillis() - time > 3000L;
        if (expired) {
            activePiercers.remove(attacker.method_5667());
        }
        return !expired;
    }

    public static void consumePiercing(class_1309 attacker) {
        activePiercers.remove(attacker.method_5667());
    }

    public static void applyLineDamage(class_1309 attacker, float baseDamage, float range, float width) {
        class_1937 class_19372 = attacker.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)class_19372;
        UUID uuid = attacker.method_5667();
        long now = System.currentTimeMillis();
        if (cooldownUntil.containsKey(uuid) && now < cooldownUntil.get(uuid)) {
            return;
        }
        cooldownUntil.put(uuid, now + 250L);
        PiercingHandler.consumePiercing(attacker);
        class_243 origin = attacker.method_19538().method_1031(0.0, (double)attacker.method_5751(), 0.0);
        class_243 forward = attacker.method_5828(1.0f).method_1029();
        class_243 end = origin.method_1019(forward.method_1021((double)range));
        for (class_1309 target : serverWorld.method_8390(class_1309.class, new class_238(origin, end).method_1014((double)width), e -> e != attacker && e.method_5805())) {
            class_243 toTarget = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0).method_1020(origin);
            double distance = forward.method_1026(toTarget.method_1029()) * toTarget.method_1033();
            if (!(distance > 0.0) || !(distance <= (double)range)) continue;
            target.method_5643(attacker.method_48923().method_48812(attacker), baseDamage);
            class_243 hitPos = target.method_19538().method_1031(0.0, (double)(target.method_17682() / 2.0f), 0.0);
            serverWorld.method_14199((class_2394)class_2398.field_17909, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            serverWorld.method_14199((class_2394)class_2398.field_29644, hitPos.field_1352, hitPos.field_1351, hitPos.field_1350, 6, 0.1, 0.1, 0.1, 0.05);
        }
        int steps = (int)(range * 12.0f);
        double spiralRadius = 0.25;
        class_243 loweredOrigin = origin.method_1023(0.0, 0.15, 0.0);
        class_243 loweredEnd = end.method_1023(0.0, 0.15, 0.0);
        for (int i = 0; i <= steps; ++i) {
            double progress = (double)i / (double)steps;
            class_243 point = loweredOrigin.method_35590(loweredEnd, progress);
            serverWorld.method_14199((class_2394)class_2398.field_11207, point.field_1352, point.field_1351, point.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            double angle = progress * Math.PI * 16.0;
            double offsetX = Math.cos(angle) * spiralRadius;
            double offsetZ = Math.sin(angle) * spiralRadius;
            class_243 spiral = point.method_1031(offsetX, 0.0, offsetZ);
            serverWorld.method_14199((class_2394)class_2398.field_29644, spiral.field_1352, spiral.field_1351, spiral.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            if (i % 4 != 0) continue;
            serverWorld.method_14199((class_2394)class_2398.field_11251, point.field_1352, point.field_1351, point.field_1350, 1, 0.01, 0.01, 0.01, 0.01);
        }
        serverWorld.method_14199((class_2394)class_2398.field_38908, loweredEnd.field_1352, loweredEnd.field_1351, loweredEnd.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        serverWorld.method_14199((class_2394)class_2398.field_11205, loweredEnd.field_1352, loweredEnd.field_1351, loweredEnd.field_1350, 8, 0.2, 0.1, 0.2, 0.1);
    }
}

