/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkHandler;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkTracker;
import net.pixeldreamstudios.kevslibrary.util.DelayedExecutor;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class FireTornadoHandler {
    private static final int BASE_TICKS = 60;
    private static final double BASE_RADIUS = 4.0;
    private static final float BASE_DAMAGE = 3.0f;
    private static final int FIRE_DURATION = 60;
    private static final Map<UUID, Long> LAST_TORNADO_CAST = new HashMap<UUID, Long>();
    private static final int COOLDOWN_TICKS = 20;

    public static void spawnFireTornado(class_1309 attacker, class_1309 centerEntity) {
        boolean isOverloaded;
        class_3218 world = (class_3218)centerEntity.method_37908();
        class_243 center = centerEntity.method_19538();
        UUID attackerId = attacker.method_5667();
        long currentTime = world.method_8510();
        if (currentTime - LAST_TORNADO_CAST.getOrDefault(attackerId, 0L) < 20L) {
            return;
        }
        LAST_TORNADO_CAST.put(attackerId, currentTime);
        double overloadChance = attacker.method_5996(KevsLibrary.FIRE_TORNADO_OVERLOAD_CHANCE) != null ? attacker.method_45325(KevsLibrary.FIRE_TORNADO_OVERLOAD_CHANCE) : 0.0;
        boolean bl = isOverloaded = attacker.method_59922().method_43058() < overloadChance;
        if (isOverloaded) {
            world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_14865, attacker.method_5634(), 1.0f, 1.4f);
            world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_14991, attacker.method_5634(), 0.6f, 0.7f);
        }
        int ticks = isOverloaded ? 120 : 60;
        double radius = isOverloaded ? 8.0 : 4.0;
        double baseInwardStrength = isOverloaded ? 0.16 : 0.08;
        world.method_43128(null, center.field_1352, center.field_1351, center.field_1350, class_3417.field_15013, attacker.method_5634(), 1.0f, 1.0f);
        int tick = 0;
        while (tick < ticks) {
            int currentTick = tick++;
            DelayedExecutor.runLater(() -> {
                class_243 tornadoCenter = center.method_1031(0.0, 0.5, 0.0);
                double baseY = center.field_1351;
                double topY = baseY + 3.0;
                List affected = world.method_8390(class_1309.class, centerEntity.method_5829().method_1014(radius + 2.0), e -> FireTornadoHandler.isValidTarget(e, attacker));
                for (class_1309 target : affected) {
                    class_243 velocity;
                    SpellPower.Result result = SpellPower.getSpellPower((SpellSchool)SpellSchools.FIRE, (class_1309)attacker);
                    SpellPower.Vulnerability vuln = SpellPower.getVulnerability((class_1309)target, (SpellSchool)SpellSchools.FIRE);
                    SpellPower.Result.Value rawResult = result.nonCritical();
                    float base = 3.0f + (float)result.baseValue() * (1.0f + vuln.powerBaseMultiplier());
                    boolean isCrit = attacker.method_59922().method_43058() < result.criticalChance() + (double)vuln.criticalChanceBonus();
                    float critMultiplier = isCrit ? (float)(result.criticalDamage() + (double)vuln.criticalDamageBonus()) : 1.0f;
                    float critApplied = base * critMultiplier;
                    class_1324 dmgAttr = attacker.method_5996(KevsLibrary.DAMAGE);
                    float multiplier = dmgAttr != null ? (float)dmgAttr.method_6194() : 1.0f;
                    float damage = critApplied * multiplier;
                    if (isOverloaded) {
                        damage *= 2.0f;
                    }
                    class_243 targetPos = target.method_19538();
                    class_243 toCenter = tornadoCenter.method_1020(targetPos);
                    double distance = toCenter.method_1033();
                    class_243 pull = new class_243(toCenter.field_1352, 0.0, toCenter.field_1350).method_1029();
                    if (distance > radius) {
                        velocity = pull.method_1021(0.07);
                    } else {
                        double currentY;
                        double inwardStrength = baseInwardStrength + (1.0 - distance / radius) * 0.1;
                        inwardStrength = Math.min(inwardStrength, 0.25);
                        class_243 orbit = new class_243(-pull.field_1350, 0.0, pull.field_1352).method_1029().method_1021(0.05);
                        class_243 inward = pull.method_1021(inwardStrength);
                        velocity = orbit.method_1019(inward);
                        double speedLimit = 0.3;
                        double horizontalSpeed = Math.sqrt(velocity.field_1352 * velocity.field_1352 + velocity.field_1350 * velocity.field_1350);
                        if (horizontalSpeed > speedLimit) {
                            double scale = speedLimit / horizontalSpeed;
                            velocity = new class_243(velocity.field_1352 * scale, velocity.field_1351, velocity.field_1350 * scale);
                        }
                        double verticalMotion = (currentY = targetPos.field_1351) < topY - 0.3 ? 0.07 + Math.random() * 0.03 : (currentY > topY ? -0.1 : Math.sin((double)(target.field_6012 + currentTick) * 0.3) * 0.05);
                        velocity = new class_243(velocity.field_1352, verticalMotion, velocity.field_1350);
                        target.method_5639(3.0f);
                        target.method_5643(attacker.method_48923().method_48794(), damage);
                        float finalDamage = damage;
                        SoulLinkTracker.getGroup(target).ifPresent(linkData -> {
                            if (!attacker.method_5667().equals(linkData.attacker().method_5667())) {
                                return;
                            }
                            SoulLinkHandler.handleLinkedDamage(linkData.attacker(), target, finalDamage, linkData.group(), linkData.soulPower());
                        });
                        if (isCrit) {
                            world.method_14199((class_2394)class_2398.field_11205, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 6, 0.2, 0.2, 0.2, 0.02);
                            world.method_14199((class_2394)class_2398.field_11240, target.method_23317(), target.method_23318() + 1.2, target.method_23321(), 4, 0.2, 0.2, 0.2, 0.01);
                            if (isOverloaded) {
                                world.method_14199((class_2394)class_2398.field_22246, target.method_23317(), target.method_23318() + 1.3, target.method_23321(), 2, 0.2, 0.2, 0.2, 0.01);
                            }
                        }
                    }
                    target.method_5762(velocity.field_1352, velocity.field_1351, velocity.field_1350);
                }
                for (int i = 0; i < 20; ++i) {
                    double angle = Math.toRadians(i * 18 + currentTick * 15);
                    double spiralRadius = 1.0 + 0.05 * (double)currentTick;
                    double x = center.field_1352 + Math.cos(angle) * spiralRadius;
                    double y = center.field_1351 + 0.1 * (double)currentTick;
                    double z = center.field_1350 + Math.sin(angle) * spiralRadius;
                    world.method_14199((class_2394)class_2398.field_11240, x, y, z, 0, 0.0, 0.0, 0.0, 0.0);
                    world.method_14199((class_2394)class_2398.field_11251, x, y, z, 0, 0.0, 0.0, 0.0, 0.01);
                    if (!isOverloaded) continue;
                    world.method_14199((class_2394)class_2398.field_29644, x, y + 0.1, z, 1, 0.0, 0.0, 0.0, 0.01);
                    world.method_14199((class_2394)class_2398.field_11215, x, y + 0.2, z, 1, 0.0, 0.0, 0.0, 0.01);
                }
            }, currentTick);
        }
    }

    private static boolean isValidTarget(class_1309 entity, class_1309 attacker) {
        class_1321 tameable;
        if (!entity.method_5805()) {
            return false;
        }
        if (entity.equals((Object)attacker)) {
            return false;
        }
        if (entity.method_5722((class_1297)attacker)) {
            return false;
        }
        if (!(entity instanceof class_1657) && entity.method_5864().method_5891().method_6136()) {
            return false;
        }
        return !(entity instanceof class_1321) || !(tameable = (class_1321)entity).method_6181();
    }
}

