/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.handler;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkHandler;
import net.pixeldreamstudios.kevslibrary.handler.SoulLinkTracker;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class ChainLightningHandler {
    private static final double MAX_DISTANCE = 8.0;

    public static void spawnChainLightning(class_1309 attacker, class_1309 initialTarget) {
        class_1309 current;
        List candidates;
        class_1937 class_19372 = attacker.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        int bounceCount = attacker.method_5996(KevsLibrary.CHAIN_LIGHTNING_COUNT) != null ? (int)attacker.method_45325(KevsLibrary.CHAIN_LIGHTNING_COUNT) : 3;
        double overloadChance = attacker.method_5996(KevsLibrary.CHAIN_LIGHTNING_OVERLOAD_CHANCE) != null ? attacker.method_45325(KevsLibrary.CHAIN_LIGHTNING_OVERLOAD_CHANCE) : 0.0;
        SpellPower.Result spellResult = SpellPower.getSpellPower((SpellSchool)SpellSchools.LIGHTNING, (class_1309)attacker);
        class_1324 dmgAttr = attacker.method_5996(KevsLibrary.DAMAGE);
        float bonus = dmgAttr != null ? (float)dmgAttr.method_6194() : 1.0f;
        float baseDamage = 3.0f;
        HashSet<class_1309> visited = new HashSet<class_1309>();
        visited.add(attacker);
        visited.add(initialTarget);
        ChainLightningHandler.spawnArcParticles(world, attacker, initialTarget);
        world.method_43128(null, initialTarget.method_23317(), initialTarget.method_23318(), initialTarget.method_23321(), class_3417.field_14956, class_3419.field_15248, 0.2f, 0.2f);
        SpellPower.Vulnerability vuln = SpellPower.getVulnerability((class_1309)initialTarget, (SpellSchool)SpellSchools.LIGHTNING);
        SpellPower.Result.Value value = spellResult.random(vuln);
        float raw = baseDamage + (float)spellResult.baseValue();
        boolean isCrit = attacker.method_59922().method_43058() < spellResult.criticalChance();
        float critApplied = isCrit ? raw * (float)spellResult.criticalDamage() : raw;
        float damage = critApplied * bonus;
        initialTarget.method_5643(attacker.method_48923().method_48831(), damage);
        if (isCrit) {
            world.method_14199((class_2394)class_2398.field_11205, initialTarget.method_23317(), initialTarget.method_23318() + 1.0, initialTarget.method_23321(), 5, 0.2, 0.2, 0.2, 0.01);
        }
        if (attacker.method_59922().method_43058() < overloadChance) {
            ChainLightningHandler.spawnOverloadVisuals(world, initialTarget.method_19538());
            ChainLightningHandler.triggerOverloadDoT(attacker, initialTarget, damage * 0.2f, bounceCount);
        }
        LinkedList<class_1309> queue = new LinkedList<class_1309>();
        queue.add(initialTarget);
        int jumps = 0;
        while (!queue.isEmpty() && jumps < bounceCount && !(candidates = world.method_8390(class_1309.class, (current = (class_1309)queue.poll()).method_5829().method_1014(8.0), e -> ChainLightningHandler.isValidBounceTarget(e, attacker, visited))).isEmpty()) {
            class_1309 next = (class_1309)candidates.get(0);
            visited.add(next);
            queue.add(next);
            ++jumps;
            ChainLightningHandler.spawnArcParticles(world, current, next);
            world.method_43128(null, next.method_23317(), next.method_23318(), next.method_23321(), class_3417.field_14956, class_3419.field_15248, 0.2f, 0.2f);
            SpellPower.Vulnerability nextVuln = SpellPower.getVulnerability((class_1309)next, (SpellSchool)SpellSchools.LIGHTNING);
            SpellPower.Result.Value nextValue = spellResult.random(nextVuln);
            float nextRaw = baseDamage + (float)spellResult.baseValue();
            boolean nextCrit = attacker.method_59922().method_43058() < spellResult.criticalChance();
            float nextCritApplied = nextCrit ? nextRaw * (float)spellResult.criticalDamage() : nextRaw;
            float nextDamage = nextCritApplied * bonus;
            next.method_5643(attacker.method_48923().method_48831(), nextDamage);
            if (nextCrit) {
                SoulLinkTracker.getGroup(next).ifPresent(linkData -> {
                    if (!attacker.method_5667().equals(linkData.attacker().method_5667())) {
                        return;
                    }
                    SoulLinkHandler.handleLinkedDamage(linkData.attacker(), next, nextDamage, linkData.group(), linkData.soulPower());
                });
                world.method_14199((class_2394)class_2398.field_11205, next.method_23317(), next.method_23318() + 1.0, next.method_23321(), 5, 0.2, 0.2, 0.2, 0.01);
            }
            if (!(attacker.method_59922().method_43058() < overloadChance)) continue;
            ChainLightningHandler.spawnOverloadVisuals(world, next.method_19538());
            ChainLightningHandler.triggerOverloadDoT(attacker, next, nextDamage * 0.2f, bounceCount);
        }
    }

    private static boolean isValidBounceTarget(class_1309 entity, class_1309 attacker, Set<class_1309> visited) {
        class_1321 tameable;
        if (!entity.method_5805()) {
            return false;
        }
        if (entity.equals((Object)attacker)) {
            return false;
        }
        if (visited.contains(entity)) {
            return false;
        }
        if (entity.method_5722((class_1297)attacker)) {
            return false;
        }
        if (!(entity instanceof class_1657) && entity.method_5864().method_5891().method_6136()) {
            return false;
        }
        if (entity.method_5864().method_5891().method_6136()) {
            return false;
        }
        return !(entity instanceof class_1321) || !(tameable = (class_1321)entity).method_6181();
    }

    private static void spawnArcParticles(class_3218 world, class_1309 from, class_1309 to) {
        class_243 start = from.method_19538().method_1031(0.0, (double)from.method_17682() * 0.6, 0.0);
        class_243 end = to.method_19538().method_1031(0.0, (double)to.method_17682() * 0.6, 0.0);
        class_243 diff = end.method_1020(start);
        int steps = 10;
        for (int i = 0; i <= steps; ++i) {
            double progress = (double)i / (double)steps;
            class_243 point = start.method_1019(diff.method_1021(progress));
            world.method_14199((class_2394)class_2398.field_29644, point.field_1352, point.field_1351, point.field_1350, 1, 0.0, 0.0, 0.0, 0.01);
        }
    }

    private static void spawnOverloadVisuals(class_3218 world, class_243 pos) {
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_14891, class_3419.field_15248, 0.6f, 1.8f);
        world.method_14199((class_2394)class_2398.field_11207, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, 10, 0.3, 0.3, 0.3, 0.01);
        world.method_14199((class_2394)class_2398.field_11215, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 8, 0.3, 0.3, 0.3, 0.01);
    }

    private static void triggerOverloadDoT(class_1309 attacker, class_1309 target, float tickDamage, int ticks) {
        class_1937 class_19372 = attacker.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        new Thread(() -> {
            int i;
            for (i = 0; i < 20; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!target.method_5805()) {
                    return;
                }
                class_243 pos = target.method_19538();
                world.method_8503().execute(() -> {
                    world.method_14199((class_2394)class_2398.field_11205, pos.field_1352, pos.field_1351 + 1.0, pos.field_1350, 3, 0.2, 0.3, 0.2, 0.01);
                    world.method_14199((class_2394)class_2398.field_29644, pos.field_1352, pos.field_1351 + 0.5, pos.field_1350, 2, 0.1, 0.2, 0.1, 0.01);
                });
            }
            for (i = 0; i < ticks; ++i) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!target.method_5805()) {
                    return;
                }
                world.method_8503().execute(() -> {
                    target.field_6008 = 0;
                    target.field_6235 = 0;
                    target.method_5643(attacker.method_48923().method_48831(), tickDamage);
                    SoulLinkTracker.getGroup(target).ifPresent(linkData -> {
                        if (!attacker.method_5667().equals(linkData.attacker().method_5667())) {
                            return;
                        }
                        SoulLinkHandler.handleLinkedDamage(linkData.attacker(), target, tickDamage, linkData.group(), linkData.soulPower());
                    });
                    world.method_14199((class_2394)class_2398.field_11207, target.method_23317(), target.method_23318() + 1.2, target.method_23321(), 6, 0.3, 0.4, 0.3, 0.01);
                });
            }
        }).start();
    }
}

