/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.kevslibrary.handler;

import java.util.List;
import java.util.WeakHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1321;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.pixeldreamstudios.kevslibrary.KevsLibrary;
import net.pixeldreamstudios.kevslibrary.entity.ArcaneShardEntity;
import net.pixeldreamstudios.kevslibrary.handler.ArcaneRuptureTracker;
import net.pixeldreamstudios.kevslibrary.util.DelayedExecutor;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class ArcaneRuptureHandler {
    private static final int SWIRL_DURATION_TICKS = 60;
    private static final int SPIKE_COUNT = 30;
    private static final double SWIRL_RADIUS = 1.5;
    private static final long COOLDOWN_MS = 500L;
    private static final WeakHashMap<class_1309, Long> cooldowns = new WeakHashMap();

    public static void trigger(class_1309 attacker, class_1309 center) {
        class_1937 class_19372 = attacker.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 world = (class_3218)class_19372;
        long now = System.currentTimeMillis();
        long lastUsed = cooldowns.getOrDefault(attacker, 0L);
        if (now - lastUsed < 500L) {
            return;
        }
        cooldowns.put(attacker, now);
        if (ArcaneRuptureTracker.hasBeenRuptured(center)) {
            return;
        }
        ArcaneRuptureTracker.markRuptured(center, 60L);
        double pullRadius = 6.0;
        List targets = world.method_8390(class_1309.class, center.method_5829().method_1014(pullRadius), e -> ArcaneRuptureHandler.isValidTarget(e, attacker) && !e.equals((Object)center));
        for (class_1309 target : targets) {
            class_243 dir = center.method_19538().method_1020(target.method_19538());
            class_243 horizontalPull = new class_243(dir.field_1352, 0.0, dir.field_1350).method_1029().method_1021(0.2);
            target.method_5762(horizontalPull.field_1352, 0.0, horizontalPull.field_1350);
        }
        for (int tick = 0; tick < 60; ++tick) {
            int currentTick = tick;
            DelayedExecutor.runLater(() -> {
                class_243 swirlCenter = center.method_19538().method_1031(0.0, 1.0, 0.0);
                for (int i = 0; i < 16; ++i) {
                    double angle = Math.toRadians((double)i * 22.5 + (double)(currentTick * 15));
                    double radius = 1.5 - (double)currentTick * 0.025;
                    double x = swirlCenter.field_1352 + Math.cos(angle) * radius;
                    double z = swirlCenter.field_1350 + Math.sin(angle) * radius;
                    double y = swirlCenter.field_1351 + Math.sin((double)currentTick * 0.2 + (double)i * 0.1) * 0.3;
                    world.method_14199((class_2394)class_2398.field_11215, x, y, z, 0, 0.0, 0.0, 0.0, 0.01);
                    world.method_14199((class_2394)class_2398.field_11214, x, y, z, 0, 0.0, 0.0, 0.0, 0.01);
                }
                List swirlTargets = world.method_8390(class_1309.class, center.method_5829().method_1014(6.0), e -> ArcaneRuptureHandler.isValidTarget(e, attacker) && !e.equals((Object)center));
                for (class_1309 t : swirlTargets) {
                    class_243 dir = swirlCenter.method_1020(t.method_19538());
                    class_243 horizontalPull = new class_243(dir.field_1352, 0.0, dir.field_1350).method_1029().method_1021(0.05);
                    t.method_5762(horizontalPull.field_1352, 0.0, horizontalPull.field_1350);
                }
            }, tick);
        }
        DelayedExecutor.runLater(() -> {
            world.method_43128(null, center.method_23317(), center.method_23318(), center.method_23321(), class_3417.field_26979, class_3419.field_15248, 1.0f, 1.4f);
            float finalDamage = ArcaneRuptureHandler.computeScaledDamage(attacker, center, true);
            for (class_1309 target : targets) {
                target.field_6008 = 0;
                target.field_6235 = 0;
                target.method_5643(attacker.method_48923().method_48831(), finalDamage);
                if (!(finalDamage > 0.0f)) continue;
                world.method_14199((class_2394)class_2398.field_11205, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 5, 0.2, 0.2, 0.2, 0.01);
            }
            class_243 burstCenter = center.method_19538().method_1031(0.0, 1.0, 0.0);
            ArcaneRuptureHandler.spawnSpikes(world, burstCenter, attacker);
        }, 60);
    }

    private static void spawnSpikes(class_3218 world, class_243 pos, class_1309 attacker) {
        double angle;
        class_5819 rand = world.method_8409();
        SpellPower.Result spellResult = SpellPower.getSpellPower((SpellSchool)SpellSchools.ARCANE, (class_1309)attacker);
        float base = 5.0f + (float)spellResult.baseValue();
        float arcaneScale = ArcaneRuptureHandler.getAttr(attacker, KevsLibrary.ARCANE_RUPTURE_DAMAGE, 1.0f);
        float globalScale = ArcaneRuptureHandler.getAttr(attacker, KevsLibrary.DAMAGE, 1.0f);
        boolean isCrit = attacker.method_59922().method_43058() < spellResult.criticalChance();
        float finalDamage = isCrit ? base * arcaneScale * globalScale * (float)spellResult.criticalDamage() : base * arcaneScale * globalScale;
        for (int r = 0; r < 40; ++r) {
            angle = rand.method_43058() * 2.0 * Math.PI;
            double x = pos.field_1352 + Math.cos(angle) * 3.5;
            double z = pos.field_1350 + Math.sin(angle) * 3.5;
            double y = pos.field_1351;
            world.method_14199((class_2394)class_2398.field_11249, x, y + rand.method_43058() * 0.8, z, 2, 0.0, 0.0, 0.0, 0.01);
        }
        world.method_43128(null, pos.field_1352, pos.field_1351, pos.field_1350, class_3417.field_15236, class_3419.field_15248, 1.2f, 0.6f + rand.method_43057() * 0.4f);
        for (int i = 0; i < 30; ++i) {
            angle = rand.method_43058() * 2.0 * Math.PI;
            double pitch = rand.method_43058() * Math.PI / 2.0 + Math.toRadians(10.0);
            class_243 dir = new class_243(Math.cos(angle) * Math.cos(pitch), Math.sin(pitch), Math.sin(angle) * Math.cos(pitch)).method_1029();
            int segments = 10;
            double segmentLength = 0.5;
            for (int j = 1; j <= segments; ++j) {
                class_243 point = pos.method_1019(dir.method_1021((double)j * segmentLength));
                world.method_14199((class_2394)class_2398.field_11207, point.field_1352, point.field_1351, point.field_1350, 2, 0.0, 0.0, 0.0, 0.01);
                world.method_14199((class_2394)class_2398.field_11216, point.field_1352, point.field_1351, point.field_1350, 3, 0.0, 0.0, 0.0, 0.02);
                world.method_14199((class_2394)class_2398.field_11215, point.field_1352, point.field_1351, point.field_1350, 1, 0.0, 0.0, 0.0, 0.01);
                if (j != segments) continue;
                world.method_14199((class_2394)class_2398.field_28479, point.field_1352, point.field_1351, point.field_1350, 10, 0.2, 0.2, 0.2, 0.03);
                world.method_14199((class_2394)class_2398.field_17909, point.field_1352, point.field_1351, point.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
        List hit = world.method_8390(class_1309.class, new class_238(pos.field_1352 - 0.5, pos.field_1351 - 0.5, pos.field_1350 - 0.5, pos.field_1352 + 0.5, pos.field_1351 + 0.5, pos.field_1350 + 0.5).method_1014(3.5), e -> ArcaneRuptureHandler.isValidTarget(e, attacker));
        for (class_1309 target : hit) {
            target.field_6008 = 0;
            target.field_6235 = 0;
            target.method_5643(attacker.method_48923().method_48831(), finalDamage);
            class_243 pull = pos.method_1020(target.method_19538()).method_1029().method_1021(0.15);
            target.method_5762(pull.field_1352, 0.06, pull.field_1350);
            world.method_14199((class_2394)class_2398.field_11205, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 6, 0.2, 0.2, 0.2, 0.02);
        }
        double overloadChance = ArcaneRuptureHandler.getAttr(attacker, KevsLibrary.ARCANE_RUPTURE_OVERLOAD_CHANCE, 0.0f);
        if (attacker.method_59922().method_43058() < overloadChance) {
            ArcaneRuptureHandler.spawnArcaneShardOverload(world, pos, attacker, finalDamage);
        }
    }

    private static void spawnArcaneShardOverload(class_3218 world, class_243 center, class_1309 attacker, float baseDamage) {
        class_5819 rand = world.method_8409();
        float launchSpeed = 0.6f;
        for (int i = 0; i < 6; ++i) {
            double angle = rand.method_43058() * 2.0 * Math.PI;
            double pitch = Math.toRadians(40.0 + rand.method_43058() * 20.0);
            class_243 dir = new class_243(Math.cos(angle) * Math.cos(pitch), Math.sin(pitch), Math.sin(angle) * Math.cos(pitch)).method_1029();
            ArcaneShardEntity shard = ArcaneShardEntity.create((class_1937)world, attacker, dir, baseDamage);
            shard.method_5875(false);
            shard.method_33574(center);
            shard.method_18799(dir.method_1021((double)launchSpeed));
            world.method_8649((class_1297)shard);
        }
        world.method_14199((class_2394)class_2398.field_11207, center.field_1352, center.field_1351, center.field_1350, 20, 0.3, 0.3, 0.3, 0.01);
        world.method_60511(null, center.field_1352, center.field_1351, center.field_1350, (class_6880)class_3417.field_23117, class_3419.field_15248, 0.8f, 1.3f);
    }

    private static boolean isValidTarget(class_1309 entity, class_1309 attacker) {
        class_1321 tameable;
        return entity.method_5805() && !entity.equals((Object)attacker) && !entity.method_5722((class_1297)attacker) && !(entity instanceof class_1657) && entity.method_5864().method_5891().method_6136() && (!(entity instanceof class_1321) || !(tameable = (class_1321)entity).method_6181());
    }

    private static float getAttr(class_1309 entity, class_6880<class_1320> attr, float fallback) {
        class_1324 instance = entity.method_5996(attr);
        return instance != null ? (float)instance.method_6194() : fallback;
    }

    private static float computeScaledDamage(class_1309 attacker, class_1309 target, boolean applyCrit) {
        SpellPower.Result spellResult = SpellPower.getSpellPower((SpellSchool)SpellSchools.ARCANE, (class_1309)attacker);
        SpellPower.Vulnerability vuln = SpellPower.getVulnerability((class_1309)target, (SpellSchool)SpellSchools.ARCANE);
        float base = 5.0f + (float)spellResult.baseValue();
        float arcaneScale = ArcaneRuptureHandler.getAttr(attacker, KevsLibrary.ARCANE_RUPTURE_DAMAGE, 1.0f);
        float globalScale = ArcaneRuptureHandler.getAttr(attacker, KevsLibrary.DAMAGE, 1.0f);
        float scaled = base * arcaneScale * globalScale;
        if (applyCrit && attacker.method_59922().method_43058() < spellResult.criticalChance()) {
            return scaled * (float)spellResult.criticalDamage();
        }
        return scaled;
    }
}

