/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.power;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.power.ModPowerTypes;
import io.github.apace100.apoli.action.BiEntityAction;
import io.github.apace100.apoli.condition.BiEntityCondition;
import io.github.apace100.apoli.condition.DamageCondition;
import io.github.apace100.apoli.condition.EntityCondition;
import io.github.apace100.apoli.power.PowerConfiguration;
import io.github.apace100.apoli.power.type.CooldownPowerType;
import io.github.apace100.apoli.util.HudRender;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;

public class ActionOnTargetDeathPowerType
extends CooldownPowerType {
    private final Optional<BiEntityAction> biEntityAction;
    private final Optional<BiEntityCondition> biEntityCondition;
    private final Optional<DamageCondition> damageCondition;
    public static final PowerConfiguration<ActionOnTargetDeathPowerType> FACTORY = PowerConfiguration.conditionedOf((class_2960)MedievalOrigins.loc("action_on_target_death"), (SerializableData)new SerializableData().add("bientity_action", BiEntityAction.DATA_TYPE.optional(), Optional.empty()).add("bientity_condition", BiEntityCondition.DATA_TYPE.optional(), Optional.empty()).add("damage_condition", DamageCondition.DATA_TYPE.optional(), Optional.empty()).add("cooldown", SerializableDataTypes.INT, (Object)1).add("hud_render", HudRender.DATA_TYPE, (Object)HudRender.DONT_RENDER), (data, condition) -> new ActionOnTargetDeathPowerType((Optional)data.get("bientity_action"), (Optional)data.get("bientity_condition"), (Optional)data.get("damage_condition"), (HudRender)data.get("hud_render"), (Integer)data.get("cooldown"), (Optional<EntityCondition>)condition), (type, data) -> data.instance().set("bientity_action", type.biEntityAction).set("bientity_condition", type.biEntityCondition).set("damage_condition", type.damageCondition).set("cooldown", (Object)type.getCooldown()).set("hud_render", (Object)type.getRenderSettings()));

    public ActionOnTargetDeathPowerType(Optional<BiEntityAction> biEntityAction, Optional<BiEntityCondition> biEntityCondition, Optional<DamageCondition> damageCondition, HudRender hudRender, int cooldown, Optional<EntityCondition> condition) {
        super(cooldown, hudRender, condition);
        this.biEntityAction = biEntityAction;
        this.biEntityCondition = biEntityCondition;
        this.damageCondition = damageCondition;
    }

    public boolean doesApply(class_1297 target, class_1282 source, float amount) {
        return this.canUse() && this.damageCondition.map(condition -> condition.test(source, amount)).orElse(true) != false && this.biEntityCondition.map(condition -> condition.test((class_1297)this.getHolder(), target)).orElse(true) != false;
    }

    public void executeActions(class_1297 target, class_1282 source, float amount) {
        if (this.doesApply(target, source, amount)) {
            this.use();
            this.biEntityAction.ifPresent(action -> action.execute((class_1297)this.getHolder(), target));
        }
    }

    @NotNull
    public PowerConfiguration<?> getConfig() {
        return ModPowerTypes.ACTION_ON_TARGET_DEATH;
    }
}

