/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.entity;

import dev.muon.medievalorigins.MedievalOrigins;
import dev.muon.medievalorigins.action.ModEntityActionTypes;
import io.github.apace100.apoli.action.ActionConfiguration;
import io.github.apace100.apoli.action.context.EntityActionContext;
import io.github.apace100.apoli.action.type.EntityActionType;
import io.github.apace100.apoli.data.TypedDataObjectFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class AutoPlantSeedsActionType
extends EntityActionType {
    private final float chance;
    private final class_6862<class_2248> blockTagKey;
    private final int horizontalRadius;
    private final int verticalRadiusPlayer;
    private final Random random = new Random();
    public static final TypedDataObjectFactory<AutoPlantSeedsActionType> DATA_FACTORY = TypedDataObjectFactory.simple((SerializableData)new SerializableData().add("chance", SerializableDataTypes.FLOAT, (Object)Float.valueOf(0.25f)).add("block_tag", SerializableDataTypes.IDENTIFIER, (Object)MedievalOrigins.loc("crops")).add("horizontal_radius", SerializableDataTypes.INT, (Object)1).add("vertical_radius_player", SerializableDataTypes.INT, (Object)0), AutoPlantSeedsActionType::new, (type, data) -> {
        SerializableData.Instance inst = new SerializableData.Instance(data);
        inst.set("chance", (Object)Float.valueOf(type.chance));
        inst.set("block_tag", (Object)type.blockTagKey.comp_327());
        inst.set("horizontal_radius", (Object)type.horizontalRadius);
        inst.set("vertical_radius_player", (Object)type.verticalRadiusPlayer);
        return inst;
    });

    public AutoPlantSeedsActionType(SerializableData.Instance data) {
        this.chance = data.getFloat("chance");
        class_2960 tagId = data.getId("block_tag");
        this.blockTagKey = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)tagId);
        this.horizontalRadius = data.getInt("horizontal_radius");
        this.verticalRadiusPlayer = data.getInt("vertical_radius_player");
    }

    public void accept(EntityActionContext context) {
        class_1297 entity = context.entity();
        class_1937 level = entity.method_37908();
        if (level.field_9236 || !(level instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)level;
        if (this.random.nextFloat() >= this.chance) {
            return;
        }
        class_2338 entityBasePos = entity.method_24515();
        class_2378 blockRegistry = serverLevel.method_30349().method_30530(class_7924.field_41254);
        Optional optionalHolderSet = blockRegistry.method_40266(this.blockTagKey);
        if (optionalHolderSet.isEmpty() || ((class_6885.class_6888)optionalHolderSet.get()).method_40247() == 0) {
            return;
        }
        List<class_2248> possibleBlocks = ((class_6885.class_6888)optionalHolderSet.get()).method_40239().map(class_6880::comp_349).toList();
        if (possibleBlocks.isEmpty()) {
            return;
        }
        ArrayList<class_2338> potentialPlantingSpots = new ArrayList<class_2338>();
        for (int yOff = -this.verticalRadiusPlayer; yOff <= this.verticalRadiusPlayer; ++yOff) {
            for (int xOff = -this.horizontalRadius; xOff <= this.horizontalRadius; ++xOff) {
                for (int zOff = -this.horizontalRadius; zOff <= this.horizontalRadius; ++zOff) {
                    class_2338 candidatePlantPos = entityBasePos.method_10069(xOff, yOff, zOff);
                    class_2338 candidateFarmlandPos = candidatePlantPos.method_10074();
                    if (!level.method_8320(candidatePlantPos).method_26215() || !(level.method_8320(candidateFarmlandPos).method_26204() instanceof class_2344)) continue;
                    potentialPlantingSpots.add(candidatePlantPos);
                }
            }
        }
        if (potentialPlantingSpots.isEmpty()) {
            return;
        }
        Collections.shuffle(potentialPlantingSpots, this.random);
        for (class_2338 plantPos : potentialPlantingSpots) {
            class_2248 selectedBlock;
            class_2680 plantState;
            if (!level.method_8320(plantPos).method_26215() || !(level.method_8320(plantPos.method_10074()).method_26204() instanceof class_2344) || !(plantState = (selectedBlock = possibleBlocks.get(this.random.nextInt(possibleBlocks.size()))).method_9564()).method_26184((class_4538)serverLevel, plantPos) || !serverLevel.method_8652(plantPos, plantState, 3)) continue;
            serverLevel.method_8396(null, plantPos, class_3417.field_17611, class_3419.field_15245, 1.0f, 1.0f);
            serverLevel.method_33596(entity, (class_6880)class_5712.field_28164, plantPos);
            serverLevel.method_14199((class_2394)class_2398.field_11211, (double)plantPos.method_10263() + 0.5, (double)plantPos.method_10264() + 0.5, (double)plantPos.method_10260() + 0.5, 5, 0.3, 0.3, 0.3, 0.0);
            return;
        }
    }

    @NotNull
    public ActionConfiguration<?> getConfig() {
        return ModEntityActionTypes.AUTO_PLANT_SEEDS;
    }
}

