/*
 * Decompiled with CFR 0.152.
 */
package dev.muon.medievalorigins.action.bientity;

import dev.muon.medievalorigins.action.ModBientityActionTypes;
import dev.muon.medievalorigins.entity.SummonedMob;
import io.github.apace100.apoli.action.ActionConfiguration;
import io.github.apace100.apoli.action.context.BiEntityActionContext;
import io.github.apace100.apoli.action.type.BiEntityActionType;
import io.github.apace100.apoli.data.TypedDataObjectFactory;
import io.github.apace100.calio.data.SerializableData;
import io.github.apace100.calio.data.SerializableDataTypes;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1738;
import net.minecraft.class_1766;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1819;
import net.minecraft.class_1829;
import net.minecraft.class_1835;
import net.minecraft.class_238;
import net.minecraft.class_243;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TransferItemActionType
extends BiEntityActionType {
    private final class_1304 sourceSlot;
    private final class_1304 targetSlot;
    private final boolean prioritizeMainhandForTake;
    private final boolean allowEmptyHandMainhandTake;
    private static final double MAX_INTERACTION_DISTANCE = 6.0;
    public static final TypedDataObjectFactory<TransferItemActionType> DATA_FACTORY = TypedDataObjectFactory.simple((SerializableData)new SerializableData().add("source_slot", SerializableDataTypes.EQUIPMENT_SLOT, (Object)class_1304.field_6173).add("target_slot", SerializableDataTypes.EQUIPMENT_SLOT, null).add("prioritize_mainhand_for_take", SerializableDataTypes.BOOLEAN, (Object)false).add("allow_empty_hand_mainhand_take", SerializableDataTypes.BOOLEAN, (Object)false), TransferItemActionType::new, (type, data) -> data.instance().set("source_slot", (Object)type.sourceSlot).set("target_slot", (Object)type.targetSlot).set("prioritize_mainhand_for_take", (Object)type.prioritizeMainhandForTake).set("allow_empty_hand_mainhand_take", (Object)type.allowEmptyHandMainhandTake));

    public TransferItemActionType(SerializableData.Instance data) {
        this.sourceSlot = (class_1304)data.get("source_slot");
        this.targetSlot = (class_1304)data.get("target_slot");
        this.prioritizeMainhandForTake = (Boolean)data.get("prioritize_mainhand_for_take");
        this.allowEmptyHandMainhandTake = (Boolean)data.get("allow_empty_hand_mainhand_take");
    }

    public void accept(BiEntityActionContext context) {
        class_1799 playerItemInSourceSlot;
        class_1309 livingActor;
        class_243 hitVec;
        class_1297 target;
        block8: {
            block7: {
                class_1297 actor = context.actor();
                target = context.target();
                if (actor.method_37908().method_8608()) {
                    return;
                }
                hitVec = null;
                if (!(actor instanceof class_1309)) break block7;
                livingActor = (class_1309)actor;
                if (target instanceof class_1309) break block8;
            }
            return;
        }
        class_1309 livingTarget = (class_1309)target;
        class_243 eyePosition = livingActor.method_33571();
        class_243 lookVector = livingActor.method_5720();
        class_238 targetBoundingBox = livingTarget.method_5829();
        Optional clipResult = targetBoundingBox.method_992(eyePosition, eyePosition.method_1019(lookVector.method_1021(6.0)));
        if (clipResult.isPresent()) {
            hitVec = (class_243)clipResult.get();
        }
        if ((playerItemInSourceSlot = livingActor.method_6118(this.sourceSlot).method_7972()).method_7960()) {
            this.handleTakingItem(livingActor, livingTarget, hitVec);
        } else {
            this.handleGivingOrSwappingItem(livingActor, livingTarget, playerItemInSourceSlot, hitVec);
        }
    }

    private void handleTakingItem(class_1309 livingActor, class_1309 livingTarget, @Nullable class_243 hitVec) {
        class_1304 slotOnSummonToInteract = null;
        if (this.prioritizeMainhandForTake) {
            if (!livingTarget.method_6118(class_1304.field_6173).method_7960()) {
                slotOnSummonToInteract = class_1304.field_6173;
            } else if (hitVec != null) {
                slotOnSummonToInteract = this.getClickedSlotOnSummon(livingTarget, hitVec, true);
            }
        } else {
            if (hitVec != null) {
                slotOnSummonToInteract = this.getClickedSlotOnSummon(livingTarget, hitVec, true);
            }
            if (slotOnSummonToInteract == null && !livingTarget.method_6118(class_1304.field_6173).method_7960()) {
                slotOnSummonToInteract = class_1304.field_6173;
            }
        }
        if (slotOnSummonToInteract != null) {
            if (slotOnSummonToInteract == class_1304.field_6173 && !this.allowEmptyHandMainhandTake) {
                return;
            }
            class_1799 summonItemInClickedSlot = livingTarget.method_6118(slotOnSummonToInteract).method_7972();
            if (!summonItemInClickedSlot.method_7960()) {
                livingActor.method_5673(this.sourceSlot, summonItemInClickedSlot);
                livingTarget.method_5673(slotOnSummonToInteract, class_1799.field_8037);
                if (livingTarget instanceof SummonedMob) {
                    SummonedMob summon = (SummonedMob)livingTarget;
                    if (slotOnSummonToInteract == class_1304.field_6173) {
                        summon.method_6997();
                    }
                }
            }
        }
    }

    private void handleGivingOrSwappingItem(class_1309 livingActor, class_1309 livingTarget, class_1799 playerItemInSourceSlot, @Nullable class_243 hitVec) {
        class_1304 slotOnSummonToInteract = this.targetSlot != null ? this.targetSlot : this.getTargetSlotForPlayerItem(playerItemInSourceSlot, class_1304.field_6173);
        if (slotOnSummonToInteract == null) {
            return;
        }
        class_1799 summonItemInTargetSlot = livingTarget.method_6118(slotOnSummonToInteract).method_7972();
        livingTarget.method_5673(slotOnSummonToInteract, playerItemInSourceSlot);
        livingActor.method_5673(this.sourceSlot, summonItemInTargetSlot);
        if (livingTarget instanceof class_1308) {
            class_1308 mob = (class_1308)livingTarget;
            mob.method_5946(slotOnSummonToInteract, 1.0f);
            mob.method_5971();
            if (mob instanceof SummonedMob) {
                SummonedMob summon = (SummonedMob)mob;
                if (slotOnSummonToInteract == class_1304.field_6173) {
                    summon.method_6997();
                }
            }
        }
    }

    private class_1304 getTargetSlotForPlayerItem(class_1799 stack, class_1304 defaultSlot) {
        if (stack.method_7960()) {
            return defaultSlot;
        }
        class_1792 item = stack.method_7909();
        if (item instanceof class_1819) {
            return class_1304.field_6171;
        }
        if (item instanceof class_1738) {
            class_1738 armorItem = (class_1738)item;
            return armorItem.method_7685();
        }
        if (item instanceof class_1811 || item instanceof class_1829 || item instanceof class_1766 || item instanceof class_1835) {
            return class_1304.field_6173;
        }
        return defaultSlot;
    }

    @Nullable
    private class_1304 getClickedSlotOnSummon(class_1309 summon, class_243 worldHitPos, boolean forTakingItem) {
        double localOriginY = summon.method_23318();
        double hitY = worldHitPos.method_10214();
        double entityHeight = summon.method_17682();
        if (entityHeight <= 1.0E-5) {
            class_1304 fallbackSlot = class_1304.field_6173;
            if (forTakingItem && summon.method_6118(fallbackSlot).method_7960()) {
                return null;
            }
            return fallbackSlot;
        }
        double clampedHitY = Math.max(localOriginY, Math.min(hitY, localOriginY + entityHeight));
        double normalizedHitY = (clampedHitY - localOriginY) / entityHeight;
        class_1304 determinedArmorSlot = null;
        if (normalizedHitY >= 0.0 && normalizedHitY < 0.15) {
            determinedArmorSlot = class_1304.field_6166;
        } else if (normalizedHitY >= 0.15 && normalizedHitY < 0.5) {
            determinedArmorSlot = class_1304.field_6172;
        } else if (normalizedHitY >= 0.5 && normalizedHitY < 0.85) {
            determinedArmorSlot = class_1304.field_6174;
        } else if (normalizedHitY >= 0.85 && normalizedHitY <= 1.0) {
            determinedArmorSlot = class_1304.field_6169;
        } else if (normalizedHitY > 1.0 && normalizedHitY <= 1.15 && summon.method_6118(class_1304.field_6169).method_7909() instanceof class_1738) {
            determinedArmorSlot = class_1304.field_6169;
        }
        if (determinedArmorSlot != null) {
            if (forTakingItem) {
                class_1799 itemInDeterminedSlot = summon.method_6118(determinedArmorSlot);
                if (!itemInDeterminedSlot.method_7960()) {
                    return determinedArmorSlot;
                }
                if (determinedArmorSlot == class_1304.field_6169) {
                    if (!summon.method_6118(class_1304.field_6174).method_7960()) {
                        return class_1304.field_6174;
                    }
                } else if (determinedArmorSlot == class_1304.field_6174) {
                    if (!summon.method_6118(class_1304.field_6169).method_7960()) {
                        return class_1304.field_6169;
                    }
                    if (!summon.method_6118(class_1304.field_6172).method_7960()) {
                        return class_1304.field_6172;
                    }
                } else if (determinedArmorSlot == class_1304.field_6172) {
                    if (!summon.method_6118(class_1304.field_6166).method_7960()) {
                        return class_1304.field_6166;
                    }
                    if (!summon.method_6118(class_1304.field_6174).method_7960()) {
                        return class_1304.field_6174;
                    }
                } else if (determinedArmorSlot == class_1304.field_6166 && !summon.method_6118(class_1304.field_6172).method_7960()) {
                    return class_1304.field_6172;
                }
                return null;
            }
            return determinedArmorSlot;
        }
        class_1304 fallbackSlot = class_1304.field_6173;
        if (forTakingItem) {
            return summon.method_6118(fallbackSlot).method_7960() ? null : fallbackSlot;
        }
        return fallbackSlot;
    }

    @NotNull
    public ActionConfiguration<?> getConfig() {
        return ModBientityActionTypes.TRANSFER_ITEM;
    }
}

