/*
 * Decompiled with CFR 0.152.
 */
package com.github.teamfusion.rottencreatures.common.level.blockentities;

import com.github.teamfusion.rottencreatures.common.registries.RCBlockEntityTypes;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_7225;

public class TreasureChestBlockEntity
extends class_2586 {
    public static final int MAX_ITEMS = 64;
    public static final String TAG_ITEMS = "Items";
    public static final String TAG_OWNER_UUID = "OwnerUUID";
    public static final String TAG_MAX_STACK_SIZE = "MaxStackSize";
    private class_2371<class_1799> items = class_2371.method_10211();
    private int totalCount = 0;
    private UUID ownerUUID;
    public int maxStackSize = 64;

    public TreasureChestBlockEntity(class_2338 blockPos, class_2680 blockState) {
        super(RCBlockEntityTypes.TREASURE_CHEST.get(), blockPos, blockState);
    }

    public void method_11007(class_2487 tag, class_7225.class_7874 provider) {
        super.method_11007(tag, provider);
        if (!this.items.isEmpty()) {
            class_2499 itemsList = new class_2499();
            for (class_1799 stack : this.items) {
                class_2487 itemTag = new class_2487();
                stack.method_57376(provider, (class_2520)itemTag);
                itemsList.add((Object)itemTag);
            }
            tag.method_10566(TAG_ITEMS, (class_2520)itemsList);
        }
        if (this.ownerUUID != null) {
            tag.method_25927(TAG_OWNER_UUID, this.ownerUUID);
        }
        if (this.maxStackSize != 64) {
            tag.method_10569(TAG_MAX_STACK_SIZE, this.maxStackSize);
        }
        tag.method_10569("ItemCount", this.totalCount);
    }

    public void method_11014(class_2487 tag, class_7225.class_7874 registries) {
        super.method_11014(tag, registries);
        this.items = class_2371.method_10211();
        if (tag.method_10573(TAG_ITEMS, 9)) {
            class_2499 itemsList = tag.method_10554(TAG_ITEMS, 10);
            for (int i = 0; i < itemsList.size(); ++i) {
                class_2487 itemTag = itemsList.method_10602(i);
                Optional stack = class_1799.method_57360((class_7225.class_7874)registries, (class_2520)itemTag);
                stack.ifPresent(itemStack -> this.items.add(itemStack));
            }
        }
        if (tag.method_25928(TAG_OWNER_UUID)) {
            this.ownerUUID = tag.method_25926(TAG_OWNER_UUID);
        }
        this.maxStackSize = tag.method_10573(TAG_MAX_STACK_SIZE, 3) && !this.items.isEmpty() ? tag.method_10550(TAG_MAX_STACK_SIZE) : (!this.items.isEmpty() ? ((class_1799)this.items.getFirst()).method_7914() : 64);
        this.recalculateTotalCount();
    }

    public void recalculateTotalCount() {
        this.totalCount = 0;
        for (class_1799 stack : this.items) {
            this.totalCount += stack.method_7947();
        }
    }

    public class_2371<class_1799> getItems() {
        return this.items;
    }

    public boolean hasContents() {
        return !this.items.isEmpty() && this.totalCount != 0;
    }

    public class_2371<class_1799> addItemsWithReplacement(class_1799 stack, int count) {
        if (stack.method_7960() || count <= 0) {
            return class_2371.method_10211();
        }
        class_2371 replacedItems = class_2371.method_10211();
        int itemMaxStackSize = stack.method_7914();
        if (this.items.isEmpty()) {
            this.maxStackSize = itemMaxStackSize;
            this.addItem(stack, Math.min(count, this.maxStackSize));
            this.recalculateTotalCount();
            this.method_5431();
            return replacedItems;
        }
        if (((class_1799)this.items.get(0)).method_7914() != itemMaxStackSize) {
            replacedItems.addAll(this.removeAllItems());
            this.maxStackSize = itemMaxStackSize;
            this.addItem(stack, Math.min(count, this.maxStackSize));
            this.recalculateTotalCount();
            this.method_5431();
            return replacedItems;
        }
        int spaceLeft = this.maxStackSize - this.totalCount;
        int toAdd = Math.min(count, this.maxStackSize);
        if (spaceLeft >= toAdd) {
            int added = 0;
            for (int i = 0; i < this.items.size() && toAdd > 0; ++i) {
                int canAdd;
                class_1799 existingStack = (class_1799)this.items.get(i);
                if (!class_1799.method_31577((class_1799)existingStack, (class_1799)stack) || (canAdd = Math.min(toAdd, existingStack.method_7914() - existingStack.method_7947())) <= 0) continue;
                existingStack.method_7933(canAdd);
                toAdd -= canAdd;
                added += canAdd;
            }
            this.totalCount += added;
            if (toAdd > 0) {
                this.addItem(stack, toAdd);
            }
            this.method_5431();
        } else {
            class_1799 removedPortion;
            int canRemove;
            class_1799 oldStack;
            int itemsToReplaceCount = toAdd - spaceLeft;
            int currentReplacedCount = 0;
            class_2371 actuallyReplaced = class_2371.method_10211();
            int i = 0;
            while (i < this.items.size() && currentReplacedCount < itemsToReplaceCount) {
                oldStack = (class_1799)this.items.get(i);
                if (class_1799.method_31577((class_1799)oldStack, (class_1799)stack)) {
                    ++i;
                    continue;
                }
                canRemove = Math.min(oldStack.method_7947(), itemsToReplaceCount - currentReplacedCount);
                removedPortion = oldStack.method_7971(canRemove);
                actuallyReplaced.add((Object)removedPortion);
                currentReplacedCount += canRemove;
                this.totalCount -= canRemove;
                if (oldStack.method_7960()) {
                    this.items.remove(i);
                    continue;
                }
                ++i;
            }
            i = 0;
            while (i < this.items.size() && currentReplacedCount < itemsToReplaceCount) {
                oldStack = (class_1799)this.items.get(i);
                canRemove = Math.min(oldStack.method_7947(), itemsToReplaceCount - currentReplacedCount);
                removedPortion = oldStack.method_7971(canRemove);
                actuallyReplaced.add((Object)removedPortion);
                currentReplacedCount += canRemove;
                this.totalCount -= canRemove;
                if (oldStack.method_7960()) {
                    this.items.remove(i);
                    continue;
                }
                ++i;
            }
            int added = 0;
            for (int i2 = 0; i2 < this.items.size() && toAdd > 0; ++i2) {
                int canAdd;
                class_1799 existingStack = (class_1799)this.items.get(i2);
                if (!class_1799.method_31577((class_1799)existingStack, (class_1799)stack) || (canAdd = Math.min(toAdd, existingStack.method_7914() - existingStack.method_7947())) <= 0) continue;
                existingStack.method_7933(canAdd);
                toAdd -= canAdd;
                added += canAdd;
            }
            this.totalCount += added;
            if (toAdd > 0) {
                this.addItem(stack, toAdd);
            }
            replacedItems.addAll((Collection)actuallyReplaced);
            this.method_5431();
        }
        this.items.removeIf(class_1799::method_7960);
        this.recalculateTotalCount();
        return replacedItems;
    }

    private void addItem(class_1799 stack, int count) {
        int stackSize;
        if (stack.method_7960() || count <= 0) {
            return;
        }
        int itemMaxStackSize = stack.method_7914();
        for (int toAdd = count; toAdd > 0; toAdd -= stackSize) {
            class_1799 newStack = stack.method_7972();
            stackSize = Math.min(toAdd, itemMaxStackSize);
            newStack.method_7939(stackSize);
            this.items.add((Object)newStack);
            this.totalCount += stackSize;
        }
        this.method_5431();
    }

    public class_2371<class_1799> removeAllItems() {
        class_2371 result = class_2371.method_10211();
        result.addAll(this.items);
        this.items.clear();
        this.totalCount = 0;
        this.maxStackSize = 64;
        this.method_5431();
        return result;
    }

    public UUID getOwnerUUID() {
        return this.ownerUUID;
    }

    public void setOwnerUUID(UUID uuid) {
        this.ownerUUID = uuid;
        this.method_5431();
    }

    public boolean isOwner(UUID playerUUID) {
        return this.ownerUUID != null && this.ownerUUID.equals(playerUUID);
    }
}

