/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.starterkit_common_neoforge.events;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.natamus.starterkit_common_neoforge.config.ConfigHandler;
import com.natamus.starterkit_common_neoforge.functions.StarterDataFunctions;
import com.natamus.starterkit_common_neoforge.functions.StarterGearFunctions;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class StarterServerEvents {
    public static void onServerStarting(MinecraftServer minecraftServer) {
        StarterDataFunctions.init(minecraftServer);
    }

    public static void onSpawn(Level level, Entity entity) {
        if (level.isClientSide) {
            return;
        }
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        if (player.getTags().contains("collective.firstJoin.starterkit")) {
            return;
        }
        StarterGearFunctions.initStarterKitHandle(level, player, null);
    }

    public static void onCommand(String string, ParseResults<CommandSourceStack> parse) {
        CommandSourceStack source;
        Entity sourceentity;
        if (!ConfigHandler.enableFTBIslandCreateCompatibility) {
            return;
        }
        CommandContextBuilder context = parse.getContext();
        Command command = context.getCommand();
        if (command == null) {
            return;
        }
        String cmdstr = command.toString().toLowerCase();
        if (cmdstr.contains("ftbteamislands.commands.createislandcommand") && (sourceentity = (source = (CommandSourceStack)context.getSource()).getEntity()) instanceof Player) {
            Player player = (Player)sourceentity;
            Level level = player.level();
            if (!level.isClientSide) {
                StarterGearFunctions.initStarterKitHandle(level, player, null);
            }
        }
    }
}

