/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.spark.common.sampler.node;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.IntPredicate;
import me.lucko.spark.common.sampler.node.AbstractNode;
import me.lucko.spark.common.sampler.node.StackTraceNode;

public final class ThreadNode
extends AbstractNode {
    private final String name;
    public String label;

    public ThreadNode(String name) {
        this.name = name;
    }

    public String getThreadLabel() {
        return this.label != null ? this.label : this.name;
    }

    public String getThreadGroup() {
        return this.name;
    }

    public void setThreadLabel(String label) {
        this.label = label;
    }

    public <T> void log(StackTraceNode.Describer<T> describer, T[] stack, long time, int window) {
        if (stack.length == 0) {
            return;
        }
        this.getTimeAccumulator(window).add(time);
        AbstractNode node = this;
        Object previousElement = null;
        for (int offset = 0; offset < Math.min(MAX_STACK_DEPTH, stack.length); ++offset) {
            T element = stack[stack.length - 1 - offset];
            node = node.resolveChild(describer.describe(element, previousElement));
            node.getTimeAccumulator(window).add(time);
            previousElement = element;
        }
    }

    public boolean removeTimeWindowsRecursively(IntPredicate predicate) {
        ArrayDeque<AbstractNode> queue = new ArrayDeque<AbstractNode>();
        queue.add(this);
        while (!queue.isEmpty()) {
            AbstractNode node = (AbstractNode)queue.remove();
            Collection<StackTraceNode> children = node.getChildren();
            boolean needToProcessChildren = false;
            Iterator<StackTraceNode> it = children.iterator();
            while (it.hasNext()) {
                StackTraceNode child = it.next();
                boolean windowsWereRemoved = child.removeTimeWindows(predicate);
                boolean childIsNowEmpty = child.getTimeWindows().isEmpty();
                if (childIsNowEmpty) {
                    it.remove();
                    continue;
                }
                if (!windowsWereRemoved) continue;
                needToProcessChildren = true;
            }
            if (!needToProcessChildren) continue;
            queue.addAll(children);
        }
        this.removeTimeWindows(predicate);
        return this.getTimeWindows().isEmpty();
    }
}

