/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.animation;

import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.KeyframeAnimationContext;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import java.util.ArrayList;
import org.jetbrains.annotations.Nullable;

public interface AnimatedEntity {
    public AnimationContextTracker getAnimationContextTracker();

    public ArrayList<AnimationHolder> getTrackedAnimations();

    public AnimationHolder getMovementAnimation();

    public int getCurrentAnimationTick();

    public void setCurrentAnimationTick(int var1);

    @Nullable
    public AnimationHolder getAnimationByPose();

    default public int getCurrentKeyframeAnimationTick() {
        AnimationHolder animationHolder = this.getAnimationByPose();
        if (animationHolder == null) {
            return 0;
        }
        int totalAnimationTicks = animationHolder.get().lengthInTicks(this.getAnimationSpeedModifier());
        int remainingAnimationTicks = this.getCurrentAnimationTick();
        return totalAnimationTicks - remainingAnimationTicks;
    }

    default public float getAnimationSpeedModifier() {
        return 1.0f;
    }

    default public void updateCurrentAnimationTick() {
        if (!this.isAnyKeyframeAnimationRunning()) {
            return;
        }
        this.setCurrentAnimationTick(this.getCurrentAnimationTick() - 1);
        if (this.getCurrentAnimationTick() > 1) {
            return;
        }
        for (AnimationHolder animationHolder : this.getTrackedAnimations()) {
            KeyframeAnimationContext keyframeAnimationContext;
            if (!animationHolder.get().looping() || !(keyframeAnimationContext = this.getAnimationContextTracker().get(animationHolder)).isRunning()) continue;
            this.setCurrentAnimationTick(animationHolder.get().lengthInTicks(this.getAnimationSpeedModifier()));
        }
    }

    default public boolean isAnyKeyframeAnimationRunning() {
        return this.getCurrentAnimationTick() > 0;
    }

    default public boolean isKeyframeAnimationAtLastKeyframe(AnimationHolder animationHolder) {
        return this.getAnimationContextTracker().get(animationHolder).isAtLastKeyframe(animationHolder.get().lengthInTicks(this.getAnimationSpeedModifier()));
    }

    default public boolean isKeyframeAnimationRunning(AnimationHolder animationHolder) {
        return this.getAnimationContextTracker().get(animationHolder).isRunning();
    }

    default public void startKeyframeAnimation(AnimationHolder animationHolder, int initialTick) {
        KeyframeAnimationContext keyframeAnimationContext = this.getAnimationContextTracker().get(animationHolder);
        keyframeAnimationContext.setInitialTick(initialTick);
        keyframeAnimationContext.getAnimationState().start(initialTick);
    }

    default public void forceStartKeyframeAnimation(AnimationHolder animationHolder, int initialTick) {
        KeyframeAnimationContext keyframeAnimationContext = this.getAnimationContextTracker().get(animationHolder);
        keyframeAnimationContext.setInitialTick(initialTick);
        keyframeAnimationContext.getAnimationState().start(initialTick);
    }

    default public void stopRunningAnimations() {
        for (AnimationHolder animationHolder : this.getTrackedAnimations()) {
            if (this.getAnimationContextTracker().get(animationHolder).isRunning()) continue;
            this.stopKeyframeAnimation(animationHolder);
        }
    }

    default public void stopKeyframeAnimation(AnimationHolder animationHolder) {
        KeyframeAnimationContext keyframeAnimationContext = this.getAnimationContextTracker().get(animationHolder);
        keyframeAnimationContext.setInitialTick(0);
        keyframeAnimationContext.setCurrentTick(0);
        keyframeAnimationContext.getAnimationState().stop();
    }
}

