/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.variant;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.variant.BreedingResultModifier;
import com.github.nyuppo.variant.CustomEyesModifier;
import com.github.nyuppo.variant.CustomVariantNameModifier;
import com.github.nyuppo.variant.CustomWoolModifier;
import com.github.nyuppo.variant.DiscardableModifier;
import com.github.nyuppo.variant.MoonPhaseModifier;
import com.github.nyuppo.variant.NametagOverrideModifier;
import com.github.nyuppo.variant.ShearedWoolColorModifier;
import com.github.nyuppo.variant.ShinyModifier;
import com.github.nyuppo.variant.SpawnableBiomesModifier;
import com.github.nyuppo.variant.VariantModifier;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1959;
import net.minecraft.class_2960;
import net.minecraft.class_5819;
import net.minecraft.class_6880;

public class MobVariant {
    private final class_2960 identifier;
    private final int weight;
    private final List<VariantModifier> modifiers;

    public MobVariant(class_2960 identifier, int weight) {
        this.identifier = identifier;
        this.weight = weight;
        this.modifiers = new ArrayList<VariantModifier>();
    }

    public MobVariant(class_2960 identifier, int weight, List<VariantModifier> modifiers) {
        this.identifier = identifier;
        this.weight = weight;
        this.modifiers = modifiers;
    }

    public MobVariant addModifier(VariantModifier modifier) {
        this.modifiers.add(modifier);
        return this;
    }

    public class_2960 getIdentifier() {
        return this.hasCustomVariantName() ? this.getCustomVariantName() : this.identifier;
    }

    public class_2960 getRawIdentifier() {
        return this.identifier;
    }

    public int getWeight() {
        return this.weight;
    }

    public boolean isShiny() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof ShinyModifier)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomVariantName() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof CustomVariantNameModifier)) continue;
            return true;
        }
        return false;
    }

    public class_2960 getCustomVariantName() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof CustomVariantNameModifier)) continue;
            return class_2960.method_60655((String)this.identifier.method_12836(), (String)((CustomVariantNameModifier)modifier).variantName());
        }
        return MoreMobVariants.id("default");
    }

    public boolean shouldDiscard(class_5819 random) {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof DiscardableModifier)) continue;
            return ((DiscardableModifier)modifier).shouldDiscard(random);
        }
        return false;
    }

    public boolean isInSpawnBiome(class_6880<class_1959> biome) {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof SpawnableBiomesModifier)) continue;
            return ((SpawnableBiomesModifier)modifier).canSpawnInBiome(biome);
        }
        return true;
    }

    public boolean canBreed(MobVariant parent1, MobVariant parent2) {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof BreedingResultModifier)) continue;
            return ((BreedingResultModifier)modifier).validParents(parent1, parent2);
        }
        return false;
    }

    public boolean shouldBreed(class_5819 random) {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof BreedingResultModifier)) continue;
            return ((BreedingResultModifier)modifier).shouldBreed(random);
        }
        return false;
    }

    public boolean hasSpawnableBiomeModifier() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof SpawnableBiomesModifier)) continue;
            return true;
        }
        return false;
    }

    public boolean hasBreedingResultModifier() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof BreedingResultModifier)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomEyes() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof CustomEyesModifier)) continue;
            return true;
        }
        return false;
    }

    public boolean hasCustomWool() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof CustomWoolModifier)) continue;
            return true;
        }
        return false;
    }

    public boolean hasColorWhenSheared() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof ShearedWoolColorModifier)) continue;
            return true;
        }
        return false;
    }

    public boolean isNametagOverride() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof NametagOverrideModifier)) continue;
            return true;
        }
        return false;
    }

    public String getNametagOverride() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof NametagOverrideModifier)) continue;
            return ((NametagOverrideModifier)modifier).nametag();
        }
        return "error";
    }

    public boolean hasMinimumMoonSize() {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof MoonPhaseModifier)) continue;
            return true;
        }
        return false;
    }

    public boolean meetsMinimumMoonSize(float moonSize) {
        for (VariantModifier modifier : this.modifiers) {
            if (!(modifier instanceof MoonPhaseModifier)) continue;
            return ((MoonPhaseModifier)modifier).canSpawn(moonSize);
        }
        return false;
    }
}

