/*
 * Decompiled with CFR 0.152.
 */
package net.libz.network;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.ConfigHolder;
import me.shedaniel.autoconfig.ConfigManager;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.Jankson;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.api.SyntaxError;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.libz.access.MouseAccessor;
import net.libz.api.ConfigSync;
import net.libz.mixin.config.AutoConfigAccess;
import net.libz.network.packet.ConfigPacket;
import net.libz.network.packet.MousePacket;
import net.libz.util.ConfigHelper;

@Environment(value=EnvType.CLIENT)
public class LibzClientPacket {
    public static void init() {
        ClientPlayNetworking.registerGlobalReceiver(ConfigPacket.PACKET_ID, (payload, context) -> {
            String configName = payload.configName();
            boolean gson = payload.gson();
            ObjectMapper objectMapper = new ObjectMapper();
            byte[] jsonBytes = payload.bytes();
            context.client().execute(() -> {
                JsonNode oldJsonNode = ConfigHelper.getConfigNode(configName, gson, false);
                JsonNode jsonNode = ConfigHelper.readJsonTree(objectMapper, jsonBytes);
                if (oldJsonNode.isObject() && jsonNode.isObject()) {
                    ObjectNode existingObjectNode = (ObjectNode)oldJsonNode;
                    ObjectNode newObjectNode = (ObjectNode)jsonNode;
                    newObjectNode.fields().forEachRemaining(entry -> {
                        String fieldName = (String)entry.getKey();
                        JsonNode newValue = (JsonNode)entry.getValue();
                        existingObjectNode.set(fieldName, newValue);
                    });
                    Jankson jankson = Jankson.builder().build();
                    for (ConfigHolder<?> holder : AutoConfigAccess.getHolders().values()) {
                        if (!((ConfigManager)holder).getDefinition().name().equals(configName)) continue;
                        try {
                            ConfigData data = (ConfigData)jankson.fromJson(jankson.load(existingObjectNode.toString()), holder.getConfigClass());
                            ((ConfigManager)holder).setConfig(data);
                            if (!(holder.getConfig() instanceof ConfigSync)) break;
                            ((ConfigSync)holder.getConfig()).updateConfig(data);
                        }
                        catch (SyntaxError e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            });
        });
        ClientPlayNetworking.registerGlobalReceiver(MousePacket.PACKET_ID, (payload, context) -> {
            int mouseX = payload.mouseX();
            int mouseY = payload.mouseY();
            context.client().execute(() -> ((MouseAccessor)context.client().field_1729).setMousePosition(mouseX, mouseY));
        });
    }
}

