/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.bookofunlearning.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;
import net.pixeldreamstudios.bookofunlearning.BookOfUnlearning;

public class BookOfUnlearningConfig {
    private static final File CONFIG_FILE = new File("config/book_of_unlearning.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Set<class_2960> blacklistedTrees = new HashSet<class_2960>();

    public static void load() {
        try {
            if (!CONFIG_FILE.exists()) {
                BookOfUnlearning.LOGGER.info("No Book of Unlearning config found, generating default.");
                CONFIG_FILE.getParentFile().mkdirs();
                JsonObject defaultConfig = new JsonObject();
                defaultConfig.add("blacklisted_skill_trees", GSON.toJsonTree(Collections.emptyList()));
                try (FileWriter writer = new FileWriter(CONFIG_FILE);){
                    GSON.toJson((JsonElement)defaultConfig, (Appendable)writer);
                }
                return;
            }
            JsonObject obj = (JsonObject)GSON.fromJson((Reader)new FileReader(CONFIG_FILE), JsonObject.class);
            Type listType = new TypeToken<Set<String>>(){}.getType();
            Set rawList = (Set)GSON.fromJson(obj.get("blacklisted_skill_trees"), listType);
            for (String str : rawList) {
                try {
                    class_2960 id = class_2960.method_12829((String)str);
                    if (id != null) {
                        blacklistedTrees.add(id);
                        continue;
                    }
                    BookOfUnlearning.LOGGER.warn("Invalid identifier in config: {}", (Object)str);
                }
                catch (Exception e) {
                    BookOfUnlearning.LOGGER.warn("Error parsing identifier in config: {}", (Object)str, (Object)e);
                }
            }
            BookOfUnlearning.LOGGER.info("Loaded {} blacklisted skill trees.", (Object)blacklistedTrees.size());
        }
        catch (Exception e) {
            BookOfUnlearning.LOGGER.error("Failed to load Book of Unlearning config", (Throwable)e);
        }
    }

    public static boolean isBlacklisted(class_2960 id) {
        return blacklistedTrees.contains(id);
    }
}

