/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.bookofunlearning.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;
import net.minecraft.class_8710;
import net.pixeldreamstudios.bookofunlearning.network.ResetSkillTreePayload;

public class SkillTreeScreen
extends class_437 {
    private final List<class_2960> skillTrees;
    private final List<class_4185> buttons = new ArrayList<class_4185>();
    private static final class_2960 BACKGROUND_TEXTURE = class_2960.method_60655((String)"book-of-unlearning", (String)"textures/gui/skill_tree_bg.png");
    private int scrollOffset = 0;
    private int maxVisible = 5;
    private int cardHeight = 24;
    private int spacing = 10;
    private int scrollStep = this.cardHeight + this.spacing;

    public SkillTreeScreen(List<class_2960> skillTrees) {
        super((class_2561)class_2561.method_43471((String)"screen.book_of_unlearning.skill_trees").method_27661().method_10862(class_2583.field_24360.method_36139(15718564).method_10982(Boolean.valueOf(true))));
        this.skillTrees = skillTrees;
    }

    protected void method_25426() {
        this.method_37067();
        this.buttons.clear();
        int cardWidth = 100;
        int startY = this.field_22790 / 2 - this.maxVisible * (this.cardHeight + this.spacing) / 2 + 12;
        int visibleEnd = Math.min(this.skillTrees.size(), this.scrollOffset + this.maxVisible);
        for (int i = this.scrollOffset; i < visibleEnd; ++i) {
            class_2960 tree = this.skillTrees.get(i);
            String name = this.beautify(tree);
            class_5250 label = class_2561.method_43470((String)("\u27a4 " + name + " \u25c0")).method_27661().method_10862(class_2583.field_24360.method_36139(15259832).method_10978(Boolean.valueOf(true)));
            class_4185 button = class_4185.method_46430((class_2561)label, btn -> {
                ClientPlayNetworking.send((class_8710)new ResetSkillTreePayload(tree));
                this.method_25419();
            }).method_46433(this.field_22789 / 2 - cardWidth / 2, startY + (i - this.scrollOffset) * (this.cardHeight + this.spacing)).method_46437(cardWidth, this.cardHeight).method_46436(class_7919.method_47407((class_2561)class_2561.method_43471((String)"tooltip.book_of_unlearning.skill_tree_button"))).method_46431();
            this.buttons.add(button);
            this.method_37063((class_364)button);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int maxScroll = Math.max(0, this.skillTrees.size() - this.maxVisible);
        if (verticalAmount > 0.0) {
            this.scrollOffset = Math.max(0, this.scrollOffset - 1);
        } else if (verticalAmount < 0.0) {
            this.scrollOffset = Math.min(maxScroll, this.scrollOffset + 1);
        }
        this.method_25426();
        return true;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        int panelWidth = 200;
        int panelHeight = 200;
        int panelX = this.field_22789 / 2 - panelWidth / 2;
        int panelY = this.field_22790 / 2 - panelHeight / 2;
        context.method_25290(BACKGROUND_TEXTURE, panelX, panelY, 0.0f, 0.0f, panelWidth, panelHeight, panelWidth, panelHeight);
        context.method_25296(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -1441722095, -1440603614);
        context.method_49601(panelX, panelY, panelWidth, panelHeight, -2241366);
        context.method_27534(this.field_22793, this.field_22785, this.field_22789 / 2, panelY + 10, 16772055);
        for (class_4185 button : this.buttons) {
            int x = button.method_46426();
            int y = button.method_46427();
            int w = button.method_25368();
            int h = button.method_25364();
            int fillColor = button.method_49606() ? 0x44FFFFFF : 0x33111111;
            int borderColor = button.method_49606() ? -2699350 : -12303292;
            context.method_25294(x - 2, y - 2, x + w + 2, y + h + 2, fillColor);
            context.method_49601(x - 2, y - 2, w + 4, h + 4, borderColor);
        }
    }

    private String beautify(class_2960 id) {
        String path = id.method_12832().replace('_', ' ');
        return path.substring(0, 1).toUpperCase() + path.substring(1);
    }

    public boolean method_25421() {
        return false;
    }
}

