/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.scheduler;

import com.mojang.datafixers.util.Either;
import dev.upcraft.sparkweave.api.scheduler.Task;
import dev.upcraft.sparkweave.scheduler.AbstractTask;
import dev.upcraft.sparkweave.scheduler.RepeatingTask;
import dev.upcraft.sparkweave.scheduler.SingleRunTask;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.function.LongSupplier;
import net.minecraft.class_5268;
import net.minecraft.server.MinecraftServer;

public class ScheduledTaskQueue {
    private static final List<AbstractTask<?>> TASK_QUEUE = new ArrayList(16);
    private static volatile LongSupplier timeSupplier = () -> 0L;

    public static <T> CompletableFuture<Either<T, ? extends Exception>> scheduleEphemeral(Callable<T> task, long delayTicks) {
        SingleRunTask<T> scheduledTask = new SingleRunTask<T>(timeSupplier.getAsLong() + Math.max(delayTicks, 0L), task);
        TASK_QUEUE.add(scheduledTask);
        return scheduledTask.result();
    }

    public static <T> Task<T> scheduleEphemeralAtFixedRate(Callable<T> task, long delayTicks, long periodTicks) {
        RepeatingTask<T> scheduledTask = new RepeatingTask<T>(timeSupplier.getAsLong() + Math.max(delayTicks, 0L), periodTicks, task);
        TASK_QUEUE.add(scheduledTask);
        return scheduledTask;
    }

    public static void onServerStarting(MinecraftServer server) {
        TASK_QUEUE.clear();
        timeSupplier = () -> ((class_5268)server.method_27728().method_27859()).method_188();
    }

    public static void onServerStopped() {
        TASK_QUEUE.forEach(AbstractTask::cancel);
        TASK_QUEUE.clear();
        timeSupplier = () -> 0L;
    }

    public static void onServerTick() {
        if (TASK_QUEUE.isEmpty()) {
            return;
        }
        long time = timeSupplier.getAsLong();
        for (int i = 0; i < TASK_QUEUE.size(); ++i) {
            AbstractTask<?> task = TASK_QUEUE.get(i);
            if (task.isCancelled()) {
                TASK_QUEUE.remove(i--);
                continue;
            }
            if (task.nextExecutionTime() > time || task.run(timeSupplier)) continue;
            TASK_QUEUE.remove(i--);
        }
    }
}

