/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.event;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3722;
import net.minecraft.class_3908;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class LecternMenuRegistry {
    private static final Map<class_1792, MenuProviderFactory> FACTORIES = new Object2ObjectOpenHashMap();

    public static void register(MenuProviderFactory factory, Supplier<? extends class_1935> itemLike) {
        Preconditions.checkNotNull(itemLike, (Object)"Item for menu is null or doesn't exist");
        class_1792 item = (class_1792)Preconditions.checkNotNull((Object)itemLike.get().method_8389(), (Object)"Item for menu is null or doesn't exist");
        if (FACTORIES.putIfAbsent(item, factory) != null) {
            throw new IllegalArgumentException("Custom lectern menu already exists for " + String.valueOf(class_7923.field_41178.method_10221((Object)item)));
        }
    }

    public static void register(MenuProviderFactory factory, class_1935 item) {
        LecternMenuRegistry.register(factory, () -> item);
    }

    public static Set<class_1792> validItems() {
        return ImmutableSet.copyOf(FACTORIES.keySet());
    }

    public static Optional<MenuProviderFactory> get(class_1799 stack) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return Optional.ofNullable(FACTORIES.get(stack.method_7909()));
    }

    @FunctionalInterface
    public static interface MenuProviderFactory {
        @Nullable
        public class_3908 create(class_1937 var1, class_2338 var2, class_1657 var3, class_3722 var4, class_1799 var5);
    }
}

