/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import dev.upcraft.sparkweave.api.event.EntityTickEvents;
import dev.upcraft.sparkweave.api.event.Event;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;

public class EntityTickEventsImpl {
    private static final Multimap<Class<? extends class_1297>, EntityTickEvents.StartTick<class_1297>> START_TICK_HANDLERS = HashMultimap.create();
    private static final Multimap<Class<? extends class_1297>, EntityTickEvents.EndTick<class_1297>> END_TICK_HANDLERS = HashMultimap.create();
    private static final Map<Class<? extends class_1297>, Event<EntityTickEvents.StartTick<class_1297>>> COMPUTED_START_HANDLERS = new ConcurrentHashMap<Class<? extends class_1297>, Event<EntityTickEvents.StartTick<class_1297>>>();
    private static final Map<Class<? extends class_1297>, Event<EntityTickEvents.EndTick<class_1297>>> COMPUTED_END_HANDLERS = new ConcurrentHashMap<Class<? extends class_1297>, Event<EntityTickEvents.EndTick<class_1297>>>();

    public static <T extends class_1297> Event<EntityTickEvents.StartTick<T>> getOrCreateStartTick(final Class<T> entityClass) {
        return new Event<EntityTickEvents.StartTick<T>>(){

            @Override
            public void register(EntityTickEvents.StartTick<T> listener) {
                START_TICK_HANDLERS.put((Object)entityClass, listener);
                COMPUTED_START_HANDLERS.remove(entityClass);
            }

            @Override
            public void unregister(EntityTickEvents.StartTick<T> listener) {
                START_TICK_HANDLERS.remove((Object)entityClass, listener);
                COMPUTED_START_HANDLERS.remove(entityClass);
            }

            @Override
            public EntityTickEvents.StartTick<T> invoker() {
                return EntityTickEventsImpl.getStartHandler(entityClass).invoker();
            }

            @Override
            public int listenerCount() {
                Event<EntityTickEvents.StartTick<class_1297>> evt = COMPUTED_START_HANDLERS.get(entityClass);
                return evt != null ? evt.listenerCount() : 0;
            }
        };
    }

    public static Event<EntityTickEvents.StartTick<class_1297>> getStartHandler(Class<? extends class_1297> entityClass) {
        return COMPUTED_START_HANDLERS.computeIfAbsent(entityClass, key -> {
            Event<EntityTickEvents.StartTick> eventHandler = Event.create(EntityTickEvents.StartTick.class, (entity, level) -> false, listeners -> (entity, level) -> {
                for (EntityTickEvents.StartTick listener : listeners) {
                    if (!listener.startTick(entity, level)) continue;
                    return true;
                }
                return false;
            });
            Class clazz = entityClass;
            while (class_1297.class.isAssignableFrom(clazz)) {
                START_TICK_HANDLERS.get((Object)clazz).forEach(eventHandler::register);
                clazz = clazz.getSuperclass();
            }
            return eventHandler;
        });
    }

    public static <T extends class_1297> Event<EntityTickEvents.EndTick<T>> getOrCreateEndTick(final Class<T> entityClass) {
        return new Event<EntityTickEvents.EndTick<T>>(){

            @Override
            public void register(EntityTickEvents.EndTick<T> listener) {
                END_TICK_HANDLERS.put((Object)entityClass, listener);
                COMPUTED_END_HANDLERS.clear();
            }

            @Override
            public void unregister(EntityTickEvents.EndTick<T> listener) {
                END_TICK_HANDLERS.remove((Object)entityClass, listener);
                COMPUTED_END_HANDLERS.clear();
            }

            @Override
            public EntityTickEvents.EndTick<T> invoker() {
                return EntityTickEventsImpl.getEndHandler(entityClass).invoker();
            }

            @Override
            public int listenerCount() {
                Event<EntityTickEvents.EndTick<class_1297>> evt = COMPUTED_END_HANDLERS.get(entityClass);
                return evt != null ? evt.listenerCount() : 0;
            }
        };
    }

    public static Event<EntityTickEvents.EndTick<class_1297>> getEndHandler(Class<? extends class_1297> entityClass) {
        return COMPUTED_END_HANDLERS.computeIfAbsent(entityClass, key -> {
            Event<EntityTickEvents.EndTick> eventHandler = Event.create(EntityTickEvents.EndTick.class, (entity, level) -> {}, listeners -> (entity, level) -> {
                for (EntityTickEvents.EndTick listener : listeners) {
                    listener.endTick(entity, level);
                }
            });
            Class clazz = entityClass;
            while (class_1297.class.isAssignableFrom(clazz)) {
                END_TICK_HANDLERS.get((Object)clazz).forEach(eventHandler::register);
                clazz = clazz.getSuperclass();
            }
            return eventHandler;
        });
    }
}

