/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.client.event;

import com.google.common.base.Preconditions;
import dev.upcraft.sparkweave.api.client.render.LecternItemRenderer;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_310;
import net.minecraft.class_5614;
import net.minecraft.class_7923;

public class LecternItemRendererRegistry {
    private static final Map<class_1792, Optional<LecternItemRenderer>> RENDERERS = new Object2ObjectOpenHashMap();
    private static final Map<class_1792, LecternItemRenderer.Factory> FACTORIES = new Object2ObjectOpenHashMap();

    public static void register(LecternItemRenderer.Factory factory, Supplier<? extends class_1935> itemLike) {
        Preconditions.checkNotNull(itemLike, (Object)"Item is null or doesn't exist");
        class_1792 item = (class_1792)Preconditions.checkNotNull((Object)itemLike.get().method_8389(), (Object)"Item is null or doesn't exist");
        if (FACTORIES.putIfAbsent(item, factory) != null) {
            throw new IllegalArgumentException("Custom lectern item renderer already exists for " + String.valueOf(class_7923.field_41178.method_10221((Object)item)));
        }
    }

    public static Optional<LecternItemRenderer> get(class_1799 stack) {
        if (stack.method_7960()) {
            return Optional.empty();
        }
        return RENDERERS.computeIfAbsent(stack.method_7909(), key -> {
            LecternItemRenderer.Factory factory = FACTORIES.get(key);
            if (factory == null) {
                return Optional.empty();
            }
            class_310 mc = class_310.method_1551();
            class_5614.class_5615 ctx = new class_5614.class_5615(mc.method_31975(), mc.method_1541(), mc.method_1480(), mc.method_1561(), mc.method_31974(), mc.field_1772);
            return Optional.ofNullable(factory.create(ctx));
        });
    }
}

