/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.logging;

import dev.upcraft.sparkweave.api.annotation.CallerSensitive;
import dev.upcraft.sparkweave.api.platform.ModContainer;
import dev.upcraft.sparkweave.api.reflect.ContextHelper;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;

public class SparkweaveLoggerFactory {
    private static final LoggerContext ctx = Configurator.initialize((ClassLoader)SparkweaveLoggerFactory.class.getClassLoader(), (ConfigurationSource)ConfigurationSource.fromResource((String)"/assets/%s/log4j2.xml".formatted("sparkweave"), (ClassLoader)SparkweaveLoggerFactory.class.getClassLoader()));

    private SparkweaveLoggerFactory() {
    }

    public static Logger getLogger(String name) {
        return ctx.getLogger(name);
    }

    public static Logger getLogger(ModContainer mod) {
        String name = mod.metadata().displayName();
        return SparkweaveLoggerFactory.getLogger(!name.isBlank() ? name : mod.metadata().id());
    }

    @CallerSensitive
    public static Logger getLogger() {
        return SparkweaveLoggerFactory.getLogger(ContextHelper.getCallerContext());
    }
}

