/*
 * Decompiled with CFR 0.152.
 */
package dev.upcraft.sparkweave.api.client.render;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import dev.upcraft.sparkweave.api.client.render.DebugRenderable;
import dev.upcraft.sparkweave.api.client.render.LineRenderable;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_156;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class DebugRenderer {
    private static final Multimap<class_1921, DebugRenderable> renderables = MultimapBuilder.hashKeys().linkedListValues().build();
    private static final List<DebugRenderable> expired = new ArrayList<DebugRenderable>(10);
    private static final int[] colors = new int[]{255, 255, 255, 255};

    public static void setColor(int red, int green, int blue, int alpha) {
        DebugRenderer.colors[0] = red;
        DebugRenderer.colors[1] = green;
        DebugRenderer.colors[2] = blue;
        DebugRenderer.colors[3] = alpha;
    }

    public static void add(DebugRenderable renderable) {
        renderables.put((Object)renderable.getRenderLayer(), (Object)renderable);
    }

    public static void drawLine(float startX, float startY, float startZ, float endX, float endY, float endZ, long duration) {
        DebugRenderer.add(new LineRenderable(startX, startY, startZ, endX, endY, endZ, colors[0], colors[1], colors[2], colors[3], class_156.method_658(), duration));
    }

    public static void drawLine(class_4587 matrices, float startX, float startY, float startZ, float endX, float endY, float endZ, long duration) {
        Matrix4f model = matrices.method_23760().method_23761();
        Vector3f start = model.transformPosition(new Vector3f(startX, startY, startZ));
        Vector3f end = model.transformPosition(new Vector3f(endX, endY, endZ));
        DebugRenderer.drawLine(start.x(), start.y(), start.z(), end.x(), end.y(), end.z(), duration);
    }

    public static void render(class_4587 matrices, class_4597 bufferSource, class_4184 camera) {
        if (!renderables.isEmpty()) {
            DebugRenderer.setColor(255, 255, 255, 255);
            long currentTime = class_156.method_658();
            class_243 cameraPos = camera.method_19326();
            matrices.method_22903();
            matrices.method_22904(-cameraPos.method_10216(), -cameraPos.method_10214(), -cameraPos.method_10215());
            for (class_1921 renderLayer : renderables.keySet()) {
                class_4588 buffer = bufferSource.getBuffer(renderLayer);
                renderables.get((Object)renderLayer).forEach(it -> {
                    it.render(matrices, buffer);
                    if (it.getCreationTimeMs() + it.getRenderDurationMs() <= currentTime) {
                        expired.add((DebugRenderable)it);
                    }
                });
            }
            matrices.method_22909();
            if (!expired.isEmpty()) {
                expired.forEach(it -> renderables.remove((Object)it.getRenderLayer(), it));
                expired.clear();
            }
        }
    }
}

