/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.logbegone;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import mod.azure.logbegone.JavaUtilLog4jFilter;
import mod.azure.logbegone.platform.Services;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommonMod {
    public static final String MOD_ID = "logbegone";
    public static final Logger LOGGER = LogManager.getLogger((String)"logbegone");
    public static final JsonObject CONFIG = CommonMod.getConfig();
    public static final JavaUtilLog4jFilter FILTER = new JavaUtilLog4jFilter();

    public static boolean shouldFilterMessage(String message) {
        JsonArray regexes;
        JsonArray phrases = CONFIG.has(MOD_ID) ? CONFIG.getAsJsonObject(MOD_ID).getAsJsonArray("phrases") : null;
        JsonArray jsonArray = regexes = CONFIG.has(MOD_ID) ? CONFIG.getAsJsonObject(MOD_ID).getAsJsonArray("regex") : null;
        if (message != null) {
            if (phrases != null) {
                for (JsonElement phraseElement : phrases) {
                    String phrase = phraseElement.getAsString();
                    if (!message.contains(phrase)) continue;
                    return true;
                }
            }
            if (regexes != null) {
                for (JsonElement regexElement : regexes) {
                    String regex = regexElement.getAsString();
                    if (!message.matches(regex)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static JsonObject getConfig() {
        JsonObject jsonObject;
        File config = new File(String.valueOf(Services.PLATFORM.getConfigLocation()) + "/logbegone.json");
        if (!config.exists()) {
            try {
                Files.copy(CommonMod.class.getResourceAsStream("/assets/logbegone/config.json"), config.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                LOGGER.error("An error occurred when creating a new config", (Throwable)e);
            }
        }
        FileReader reader = new FileReader(config);
        try {
            jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonSyntaxException | IOException e) {
                LOGGER.error("An error occurred when reading the config file", e);
                return new JsonObject();
            }
        }
        reader.close();
        return jsonObject;
    }

    private static void saveConfig(JsonObject config) {
        File configFile = new File(String.valueOf(Services.PLATFORM.getConfigLocation()) + "/logbegone.json");
        try (FileWriter writer = new FileWriter(configFile);){
            new Gson().toJson((JsonElement)config, (Appendable)writer);
        }
        catch (IOException e) {
            LOGGER.error("An error occurred when saving the config file", (Throwable)e);
        }
    }

    public static final class SystemPrintFilter
    extends PrintStream {
        public SystemPrintFilter(PrintStream stream) {
            super(stream);
        }

        @Override
        public void println(String x) {
            if (!CommonMod.shouldFilterMessage(x)) {
                super.println(x);
            }
        }

        @Override
        public void print(String s) {
            if (!CommonMod.shouldFilterMessage(s)) {
                super.print(s);
            }
        }
    }
}

