/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.networking.client;

import com.mojang.logging.LogUtils;
import io.wispforest.accessories.api.AccessoriesCapability;
import io.wispforest.accessories.endec.NbtMapCarrier;
import io.wispforest.accessories.impl.AccessoriesHolderImpl;
import io.wispforest.accessories.networking.AccessoriesNetworking;
import io.wispforest.endec.Endec;
import io.wispforest.endec.SerializationAttribute;
import io.wispforest.endec.SerializationContext;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.serialization.RegistriesAttribute;
import java.util.HashSet;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3222;
import net.minecraft.class_5455;
import org.slf4j.Logger;

public record SyncEntireContainer(int entityId, NbtMapCarrier containerMap) {
    public static final StructEndec<SyncEntireContainer> ENDEC = StructEndecBuilder.of((StructField)Endec.VAR_INT.fieldOf("entityId", SyncEntireContainer::entityId), (StructField)NbtMapCarrier.ENDEC.fieldOf("containerTag", SyncEntireContainer::containerMap), SyncEntireContainer::new);
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void syncToAllTrackingAndSelf(class_3222 player) {
        SyncEntireContainer.syncTo((class_1309)player, channel -> {
            HashSet<class_3222> set = new HashSet<class_3222>(PlayerLookup.tracking((class_1297)player));
            set.add(player);
            return channel.serverHandle(set);
        });
    }

    public static void syncTo(class_1309 entity, Function<OwoNetChannel, OwoNetChannel.ServerHandle> handleCreator) {
        AccessoriesCapability capability = AccessoriesCapability.get(entity);
        if (capability == null) {
            return;
        }
        NbtMapCarrier carrier = NbtMapCarrier.of();
        ((AccessoriesHolderImpl)capability.getHolder()).write(carrier, SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)entity.method_37908().method_30349())}));
        handleCreator.apply(AccessoriesNetworking.CHANNEL).send((Record)new SyncEntireContainer(capability.entity().method_5628(), carrier));
    }

    @Environment(value=EnvType.CLIENT)
    public static void handlePacket(SyncEntireContainer packet, class_1657 player) {
        class_1937 level = player.method_37908();
        class_1297 entity = level.method_8469(packet.entityId());
        if (entity == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as it is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        if (!(entity instanceof class_1309)) {
            return;
        }
        class_1309 livingEntity = (class_1309)entity;
        AccessoriesCapability capability = AccessoriesCapability.get(livingEntity);
        if (capability == null) {
            LOGGER.error("Unable to Sync Container Data for a given Entity as its Capability is null on the Client! [EntityId: {}]", (Object)packet.entityId());
            return;
        }
        AccessoriesHolderImpl holder = (AccessoriesHolderImpl)capability.getHolder();
        holder.read(packet.containerMap(), SerializationContext.attributes((SerializationAttribute.Instance[])new SerializationAttribute.Instance[]{RegistriesAttribute.of((class_5455)level.method_30349())}));
        holder.init(capability);
    }
}

