/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.projectileimmunityfix.mixin;

import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.pixeldreamstudios.projectileimmunityfix.config.ProjectileImmunityFixConfig;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private int projectileHitCount = 0;
    @Unique
    private int projectileCooldown = 0;
    @Unique
    private int timeSinceLastProjectileHit = 0;

    public LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void tickProjectileTimers(CallbackInfo ci) {
        class_1309 self = (class_1309)this;
        ProjectileImmunityFixConfig.BaseProjectileConfig config = ProjectileImmunityFixConfig.INSTANCE.getEffectiveConfig((class_1297)self);
        if (config == null || !config.enabled) {
            return;
        }
        if (this.projectileCooldown > 0) {
            --this.projectileCooldown;
            if (this.projectileCooldown == 0) {
                this.projectileHitCount = 0;
            }
        } else if (this.projectileHitCount > 0) {
            ++this.timeSinceLastProjectileHit;
            if (this.timeSinceLastProjectileHit >= config.timeWithoutHitResetTicks) {
                this.projectileHitCount = 0;
                this.timeSinceLastProjectileHit = 0;
            }
        }
    }

    @Inject(method={"damage"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/LivingEntity;applyDamage(Lnet/minecraft/entity/damage/DamageSource;F)V")})
    private void modifyArrowIFrames(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 self = (class_1309)this;
        if (!(source.method_5526() instanceof class_1665)) {
            return;
        }
        ProjectileImmunityFixConfig.BaseProjectileConfig config = ProjectileImmunityFixConfig.INSTANCE.getEffectiveConfig((class_1297)self);
        if (config == null || !config.enabled) {
            return;
        }
        if (this.projectileCooldown > 0) {
            return;
        }
        ++this.projectileHitCount;
        this.timeSinceLastProjectileHit = 0;
        if (this.projectileHitCount <= config.maxHitsBeforeCooldown) {
            self.field_6254 = 0;
            self.field_6235 = 0;
            self.field_6008 = 0;
        } else {
            this.projectileCooldown = config.cooldownTicks;
        }
    }
}

