/*
 * Decompiled with CFR 0.152.
 */
package net.pixeldreamstudios.projectileimmunityfix.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1657;
import net.pixeldreamstudios.projectileimmunityfix.ProjectileImmunityFix;

public class ProjectileImmunityFixConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static File configFile;
    public static ProjectileImmunityFixConfig INSTANCE;
    public MobProjectileConfig mobConfig = new MobProjectileConfig(true, 10, 20, 20);
    public PlayerProjectileConfig playerConfig = new PlayerProjectileConfig(false, 6, 40, 40);

    public BaseProjectileConfig getEffectiveConfig(class_1297 entity) {
        if (entity instanceof class_1657) {
            return this.playerConfig.enabled ? this.playerConfig : null;
        }
        if (!this.mobConfig.enabled) {
            return null;
        }
        String id = class_1299.method_5890((class_1299)entity.method_5864()).toString();
        for (MobProjectileConfig.PerEntityOverride override : this.mobConfig.entities) {
            if (!override.mobId.equals(id)) continue;
            return new MobProjectileConfig(true, override.maxHitsBeforeCooldown, override.cooldownTicks, override.timeWithoutHitResetTicks);
        }
        return this.mobConfig;
    }

    public static void load(Path configDir) {
        configFile = configDir.resolve("projectileimmunityfix.json").toFile();
        ProjectileImmunityFix.LOGGER.info("Loading config from: " + configFile.getAbsolutePath());
        if (configFile.exists()) {
            try (FileReader reader = new FileReader(configFile);){
                JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                if (json.has("mobConfig")) {
                    ProjectileImmunityFixConfig.INSTANCE.mobConfig = (MobProjectileConfig)GSON.fromJson(json.get("mobConfig"), MobProjectileConfig.class);
                }
                if (json.has("playerConfig")) {
                    ProjectileImmunityFixConfig.INSTANCE.playerConfig = (PlayerProjectileConfig)GSON.fromJson(json.get("playerConfig"), PlayerProjectileConfig.class);
                }
                ProjectileImmunityFixConfig.save();
            }
            catch (IOException e) {
                ProjectileImmunityFix.LOGGER.error("Error reading config file", (Throwable)e);
            }
        } else {
            ProjectileImmunityFix.LOGGER.info("Config file not found. Creating new one.");
            ProjectileImmunityFixConfig.save();
        }
    }

    public static void save() {
        if (configFile == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)INSTANCE, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        INSTANCE = new ProjectileImmunityFixConfig();
    }

    public static class MobProjectileConfig
    extends BaseProjectileConfig {
        public List<PerEntityOverride> entities = new ArrayList<PerEntityOverride>();

        public MobProjectileConfig() {
        }

        public MobProjectileConfig(boolean enabled, int maxHitsBeforeCooldown, int cooldownTicks, int timeWithoutHitResetTicks) {
            super(enabled, maxHitsBeforeCooldown, cooldownTicks, timeWithoutHitResetTicks);
        }

        public static class PerEntityOverride {
            public String mobId;
            public int maxHitsBeforeCooldown;
            public int cooldownTicks;
            public int timeWithoutHitResetTicks;
        }
    }

    public static class PlayerProjectileConfig
    extends BaseProjectileConfig {
        public PlayerProjectileConfig() {
        }

        public PlayerProjectileConfig(boolean enabled, int maxHitsBeforeCooldown, int cooldownTicks, int timeWithoutHitResetTicks) {
            super(enabled, maxHitsBeforeCooldown, cooldownTicks, timeWithoutHitResetTicks);
        }
    }

    public static class BaseProjectileConfig {
        public boolean enabled;
        public int maxHitsBeforeCooldown;
        public int cooldownTicks;
        public int timeWithoutHitResetTicks;

        public BaseProjectileConfig() {
        }

        public BaseProjectileConfig(boolean enabled, int maxHitsBeforeCooldown, int cooldownTicks, int timeWithoutHitResetTicks) {
            this.enabled = enabled;
            this.maxHitsBeforeCooldown = maxHitsBeforeCooldown;
            this.cooldownTicks = cooldownTicks;
            this.timeWithoutHitResetTicks = timeWithoutHitResetTicks;
        }
    }
}

