/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.attributefix.common.impl.config;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.darkhax.attributefix.common.impl.Constants;
import net.darkhax.attributefix.common.mixin.AccessorRangedAttribute;
import net.darkhax.pricklemc.common.api.annotations.Value;
import net.minecraft.class_1329;
import net.minecraft.class_2960;

public class RangeConfig {
    private static final Map<class_2960, Double> NEW_DEFAULT_VALUES = ImmutableMap.of((Object)class_2960.method_60655((String)"minecraft", (String)"generic.max_health"), (Object)1000000.0, (Object)class_2960.method_60655((String)"minecraft", (String)"generic.armor"), (Object)1000000.0, (Object)class_2960.method_60655((String)"minecraft", (String)"generic.armor_toughness"), (Object)1000000.0, (Object)class_2960.method_60655((String)"minecraft", (String)"generic.attack_damage"), (Object)1000000.0, (Object)class_2960.method_60655((String)"minecraft", (String)"generic.attack_knockback"), (Object)1000000.0);
    private final transient class_2960 id;
    private final transient class_1329 attribute;
    @Value(comment="Determines if the range for the attribute should be modified or not.")
    public boolean modify_range;
    @Value(comment="The lowest possible value for the attribute.")
    public double min;
    @Value(comment="The highest possible value for the attribute.")
    public double max;

    public RangeConfig(class_2960 id, class_1329 attribute) {
        this.id = id;
        this.attribute = attribute;
        this.modify_range = NEW_DEFAULT_VALUES.containsKey(id);
        this.min = attribute.method_35061();
        this.max = NEW_DEFAULT_VALUES.getOrDefault(id, attribute.method_35062());
    }

    public void apply() {
        class_1329 class_13292;
        if (this.modify_range && (class_13292 = this.attribute) instanceof AccessorRangedAttribute) {
            AccessorRangedAttribute accessor = (AccessorRangedAttribute)class_13292;
            if (this.min >= this.max) {
                Constants.LOG.error("User Error: A minimum can not exceed or equal a maximum value! Attribute={} Min={} Max={}", new Object[]{this.id, this.min, this.max});
                throw new IllegalStateException("User Error: A minimum can not exceed or equal a maximum value! Attribute=" + String.valueOf(this.id) + " Min=" + this.min + " Max=" + this.max);
            }
            if (this.min != this.attribute.method_35061()) {
                Constants.LOG.info("Changing minimum value for {} from {} to {}.", new Object[]{this.id, this.attribute.method_35061(), this.min});
                accessor.attributefix$setMinValue(this.min);
            }
            if (this.max != this.attribute.method_35062()) {
                Constants.LOG.info("Changing maximum value for {} from {} to {}.", new Object[]{this.id, this.attribute.method_35062(), this.max});
                accessor.attributefix$setMaxValue(this.max);
            }
        }
    }
}

