/*
 * Decompiled with CFR 0.152.
 */
package net.archers.content;

import java.util.ArrayList;
import java.util.List;
import net.archers.content.ArcherSounds;
import net.archers.effect.ArcherEffects;
import net.minecraft.class_2960;
import net.spell_engine.api.render.LightEmission;
import net.spell_engine.api.spell.ExternalSpellSchools;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import org.jetbrains.annotations.Nullable;

public class ArcherSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    private static final String PRIMARY_GROUP = "primary";
    public static final Entry power_shot = ArcherSpells.add(ArcherSpells.power_shot());
    public static final Entry entangling_roots = ArcherSpells.add(ArcherSpells.entangling_roots());
    public static final Entry barrage = ArcherSpells.add(ArcherSpells.barrage());
    public static final Entry magic_arrow = ArcherSpells.add(ArcherSpells.magic_arrow());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    private static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.cast = new Spell.Active.Cast();
        spell.learn = new Spell.Learn();
        spell.active.scroll = new Spell.Active.Scroll();
        return spell;
    }

    private static Spell.Impact createEffectImpact(class_2960 effectId, float duration) {
        Spell.Impact buff = new Spell.Impact();
        buff.action = new Spell.Impact.Action();
        buff.action.type = Spell.Impact.Action.Type.STATUS_EFFECT;
        buff.action.status_effect = new Spell.Impact.Action.StatusEffect();
        buff.action.status_effect.effect_id = effectId.toString();
        buff.action.status_effect.duration = duration;
        return buff;
    }

    private static void configureCooldown(Spell spell, float duration) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.cooldown = new Spell.Cost.Cooldown();
        spell.cost.cooldown.duration = duration;
    }

    private static void configureArrowCost(Spell spell) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        spell.cost.item = new Spell.Cost.Item();
        spell.cost.item.id = "arrow";
    }

    private static Spell.Impact damage(float coefficient, float knockback) {
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = Spell.Impact.Action.Type.DAMAGE;
        impact.action.damage = new Spell.Impact.Action.Damage();
        impact.action.damage.spell_power_coefficient = coefficient;
        impact.action.damage.knockback = knockback;
        return impact;
    }

    private static Entry power_shot() {
        class_2960 id = class_2960.method_60655((String)"archers", (String)"power_shot");
        Spell spell = ArcherSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        spell.range = 0.0f;
        spell.tier = 1;
        spell.release.sound = Sound.withVolume((class_2960)ArcherSounds.MARKER_SHOT.id(), (float)0.5f);
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.RAGE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.STRIPE, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.FLOAT).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 10.0f, 0.01f, 0.1f)};
        spell.deliver.type = Spell.Delivery.Type.STASH_EFFECT;
        Spell.Delivery.StashEffect stash = new Spell.Delivery.StashEffect();
        stash.id = ArcherEffects.HUNTERS_MARK_STASH.id.toString();
        stash.duration = 12.0f;
        stash.amplifier = 2;
        Spell.Trigger shootTrigger = new Spell.Trigger();
        shootTrigger.type = Spell.Trigger.Type.ARROW_SHOT;
        stash.triggers = List.of(shootTrigger);
        stash.impact_mode = Spell.Delivery.StashEffect.ImpactMode.TRANSFER;
        spell.deliver.stash_effect = stash;
        Spell.Impact debuff = ArcherSpells.createEffectImpact(ArcherEffects.HUNTERS_MARK.id, 12.0f);
        debuff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        debuff.action.status_effect.amplifier = 2;
        debuff.particles = new ParticleBatch[]{new ParticleBatch("firework", ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.CENTER, 3.0f, 0.01f, 0.1f)};
        spell.impacts = List.of(debuff);
        spell.arrow_perks = new Spell.ArrowPerks();
        spell.arrow_perks.bypass_iframes = true;
        ArcherSpells.configureCooldown(spell, 8.0f);
        return new Entry(id, spell, "Power Shot", "", null);
    }

    private static Entry entangling_roots() {
        class_2960 id = class_2960.method_60655((String)"archers", (String)"entangling_roots");
        Spell spell = ArcherSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        spell.range = 0.0f;
        spell.tier = 2;
        spell.release.animation = "spell_engine:one_handed_area_release";
        spell.deliver.type = Spell.Delivery.Type.CLOUD;
        Spell.Delivery.Cloud cloud = new Spell.Delivery.Cloud();
        cloud.volume.radius = 3.5f;
        cloud.volume.area.vertical_range_multiplier = 0.3f;
        cloud.volume.sound = new Sound(ArcherSounds.ENTANGLING_ROOTS.id());
        cloud.impact_tick_interval = 15;
        cloud.time_to_live_seconds = 8.0f;
        cloud.client_data = new Spell.Delivery.Cloud.ClientData();
        cloud.client_data.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.roots.id().toString(), ParticleBatch.Shape.PILLAR, ParticleBatch.Origin.FEET, 2.0f, 0.0f, 0.0f)};
        spell.deliver.clouds = List.of(cloud);
        Spell.Impact debuff = ArcherSpells.createEffectImpact(ArcherEffects.ENTANGLING_ROOTS.id, 1.0f);
        debuff.action.status_effect.apply_mode = Spell.Impact.Action.StatusEffect.ApplyMode.SET;
        debuff.action.status_effect.apply_limit = new Spell.Impact.Action.StatusEffect.ApplyLimit();
        debuff.action.status_effect.apply_limit.health_base = 50.0f;
        debuff.action.status_effect.apply_limit.spell_power_multiplier = 5.0f;
        debuff.particles = new ParticleBatch[]{new ParticleBatch("falling_spore_blossom", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 2.0f, 0.1f, 0.2f)};
        spell.impacts = List.of(debuff);
        ArcherSpells.configureCooldown(spell, 18.0f);
        spell.cost.exhaust = 0.2f;
        return new Entry(id, spell, "Entangling Roots", "", null);
    }

    private static Entry barrage() {
        class_2960 id = class_2960.method_60655((String)"archers", (String)"barrage");
        Spell spell = ArcherSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        spell.range = 0.0f;
        spell.tier = 3;
        spell.active.cast.duration = 0.5f;
        spell.active.cast.animation = "spell_engine:archery_pull";
        spell.active.cast.animates_ranged_weapon = true;
        spell.active.cast.sound = new Sound(ArcherSounds.BOW_PULL.id());
        spell.release.animation = "spell_engine:archery_release";
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.SHOOT_ARROW;
        spell.deliver.shoot_arrow = new Spell.Delivery.ShootArrow();
        spell.deliver.shoot_arrow.launch_properties.velocity = 3.15f;
        spell.deliver.shoot_arrow.launch_properties.extra_launch_count = 2;
        spell.arrow_perks = new Spell.ArrowPerks();
        spell.arrow_perks.damage_multiplier = 0.75f;
        spell.arrow_perks.bypass_iframes = true;
        spell.arrow_perks.knockback = 0.5f;
        ArcherSpells.configureCooldown(spell, 10.0f);
        ArcherSpells.configureArrowCost(spell);
        spell.cost.item.consume = false;
        return new Entry(id, spell, "Barrage", "", null);
    }

    private static Entry magic_arrow() {
        class_2960 id = class_2960.method_60655((String)"archers", (String)"magic_arrow");
        Spell spell = ArcherSpells.activeSpellBase();
        spell.school = ExternalSpellSchools.PHYSICAL_RANGED;
        spell.range = 64.0f;
        spell.tier = 4;
        spell.active.cast.duration = 1.0f;
        spell.active.cast.animation = "spell_engine:archery_pull";
        spell.active.cast.animates_ranged_weapon = true;
        spell.active.cast.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.FLOAT).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.LAUNCH_POINT, 4.0f, 0.02f, 0.1f).invert().preSpawnTravel(14.0f)};
        spell.active.cast.sound = new Sound(SpellEngineSounds.GENERIC_WIND_CHARGING.id());
        spell.release.animation = "spell_engine:archery_release";
        spell.release.sound = new Sound(ArcherSounds.MAGIC_ARROW_RELEASE.id());
        spell.release.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.LAUNCH_POINT, ParticleBatch.Rotation.LOOK, 50.0f, 0.18f, 0.2f, 0.0f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.LAUNCH_POINT, ParticleBatch.Rotation.LOOK, 25.0f, 0.28f, 0.3f, 0.0f)};
        spell.target.type = Spell.Target.Type.AIM;
        spell.target.aim = new Spell.Target.Aim();
        spell.deliver.type = Spell.Delivery.Type.PROJECTILE;
        Spell.Delivery.ShootProjectile shoot = new Spell.Delivery.ShootProjectile();
        shoot.launch_properties.velocity = 1.5f;
        Spell.ProjectileData projectile = new Spell.ProjectileData();
        projectile.homing_angle = 2.0f;
        projectile.perks.pierce = 99999;
        projectile.client_data = new Spell.ProjectileData.Client();
        projectile.client_data.travel_particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.LINE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 5.0f, 0.14f, 0.15f, 0.0f).roll(18.0f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.LINE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 5.0f, 0.14f, 0.15f, 0.0f).rollOffset(180.0f).roll(18.0f), new ParticleBatch("firework", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 2.0f, 0.0f, 0.05f, 0.0f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.DECELERATE).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 10.0f, 0.0f, 0.05f, 0.0f)};
        projectile.client_data.light_level = 10;
        projectile.client_data.model = new Spell.ProjectileModel();
        projectile.client_data.model.model_id = "archers:projectile/magic_arrow";
        projectile.client_data.model.light_emission = LightEmission.RADIATE;
        projectile.client_data.model.scale = 1.2f;
        shoot.projectile = projectile;
        spell.deliver.projectile = shoot;
        Spell.Impact damage = ArcherSpells.damage(1.2f, 2.0f);
        damage.particles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.NATURE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.BURST).id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, 25.0f, 1.2f, 1.8f)};
        damage.sound = new Sound(ArcherSounds.MAGIC_ARROW_IMPACT.id());
        spell.impacts = List.of(damage);
        ArcherSpells.configureCooldown(spell, 8.0f);
        ArcherSpells.configureArrowCost(spell);
        return new Entry(id, spell, "Magic Arrow", "", null);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

