/*
 * Decompiled with CFR 0.152.
 */
package net.archers;

import net.archers.block.ArcherBlocks;
import net.archers.config.ArchersItemConfig;
import net.archers.config.Default;
import net.archers.config.TweaksConfig;
import net.archers.content.ArcherSounds;
import net.archers.effect.ArcherEffects;
import net.archers.item.Armors;
import net.archers.item.Group;
import net.archers.item.Weapons;
import net.archers.item.misc.Misc;
import net.archers.village.ArcherVillagers;
import net.fabric_extras.structure_pool.api.StructurePoolConfig;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.item.v1.EnchantmentEvents;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7923;
import net.spell_engine.api.config.ConfigFile;
import net.spell_engine.api.item.SpellBooks;
import net.spell_engine.api.spell.container.SpellContainer;
import net.tinyconfig.ConfigManager;

public class ArchersMod
implements ModInitializer {
    public static final String ID = "archers";
    public static ConfigManager<ArchersItemConfig> itemConfig = new ConfigManager("equipment", (Object)Default.itemConfig).builder().setDirectory("archers").sanitize(true).build();
    public static ConfigManager<ConfigFile.Effects> effectsConfig = new ConfigManager("effects", (Object)new ConfigFile.Effects()).builder().setDirectory("archers").sanitize(true).build();
    public static ConfigManager<StructurePoolConfig> villagesConfig = new ConfigManager("villages", (Object)Default.villages).builder().setDirectory("archers").sanitize(true).build();
    public static ConfigManager<TweaksConfig> tweaksConfig = new ConfigManager("tweaks", (Object)new TweaksConfig()).builder().setDirectory("archers").sanitize(true).build();

    public void onInitialize() {
        tweaksConfig.refresh();
        if (FabricLoader.getInstance().isDevelopmentEnvironment()) {
            ((TweaksConfig)ArchersMod.tweaksConfig.value).ignore_items_required_mods = true;
        }
        ArcherSounds.register();
        this.registerEffects();
        this.registerItemGroup();
        this.registerItems();
        this.registerVillages();
        this.subscribeEvents();
        if (((TweaksConfig)ArchersMod.tweaksConfig.value).enable_infinity_for_crossbows) {
            EnchantmentEvents.ALLOW_ENCHANTING.register((enchantment, target, enchantingContext) -> {
                if (target.method_7909() instanceof class_1764 && ((class_5321)enchantment.method_40230().get()).method_29177().equals((Object)class_1893.field_9125.method_29177())) {
                    return TriState.TRUE;
                }
                return TriState.DEFAULT;
            });
        }
    }

    private void registerItemGroup() {
        Group.ARCHERS = FabricItemGroup.builder().method_47320(() -> new class_1799((class_1935)Armors.archerArmorSet_T2.head.method_8389())).method_47321((class_2561)class_2561.method_43471((String)"itemGroup.archers.general")).method_47324();
        class_2378.method_39197((class_2378)class_7923.field_44687, Group.KEY, (Object)Group.ARCHERS);
    }

    private void registerItems() {
        itemConfig.refresh();
        SpellBooks.createAndRegister((class_2960)class_2960.method_60655((String)ID, (String)"archer"), (SpellContainer.ContentType)SpellContainer.ContentType.ARCHERY, Group.KEY);
        ArcherBlocks.register();
        Misc.register();
        Weapons.register(((ArchersItemConfig)ArchersMod.itemConfig.value).ranged_weapons, ((ArchersItemConfig)ArchersMod.itemConfig.value).melee_weapons);
        Armors.register(((ArchersItemConfig)ArchersMod.itemConfig.value).armor_sets);
        itemConfig.save();
    }

    private void registerVillages() {
        villagesConfig.refresh();
        ArcherVillagers.register();
    }

    private void registerEffects() {
        effectsConfig.refresh();
        ArcherEffects.register((ConfigFile.Effects)ArchersMod.effectsConfig.value);
        effectsConfig.save();
    }

    private void subscribeEvents() {
    }
}

