/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.universalshops.registry;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.protection.api.CommonProtection;
import eu.pb4.polymer.virtualentity.api.ElementHolder;
import eu.pb4.polymer.virtualentity.api.attachment.ChunkAttachment;
import eu.pb4.polymer.virtualentity.api.elements.ItemDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.TextDisplayElement;
import eu.pb4.polymer.virtualentity.api.elements.VirtualElement;
import eu.pb4.universalshops.gui.setup.ShopSettingsGui;
import eu.pb4.universalshops.other.EmptyInventory;
import eu.pb4.universalshops.other.LegacyNbtHelper;
import eu.pb4.universalshops.other.RemappedInventory;
import eu.pb4.universalshops.other.TextUtil;
import eu.pb4.universalshops.other.USUtil;
import eu.pb4.universalshops.registry.TradeShopBlock;
import eu.pb4.universalshops.registry.USRegistry;
import eu.pb4.universalshops.trade.PriceHandler;
import eu.pb4.universalshops.trade.StockHandler;
import java.util.stream.IntStream;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_811;
import net.minecraft.class_8113;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class TradeShopBlockEntity
extends class_2586
implements RemappedInventory,
class_1278,
class_1265 {
    private final TextDisplayElement textDisplay = new TextDisplayElement();
    private final ItemDisplayElement itemDisplay = new ItemDisplayElement();
    @Nullable
    public class_2338 containerPos;
    public boolean allowHoppers = false;
    public PriceHandler priceHandler = (PriceHandler)PriceHandler.Invalid.DEFINITION.createInitial(this);
    public StockHandler stockHandler = (StockHandler)StockHandler.Invalid.DEFINITION.createInitial(this);
    public GameProfile owner;
    public HologramMode hologramMode = HologramMode.FULL;
    private int[] cachedSlots = new int[0];
    private ElementHolder elementHolder;

    public TradeShopBlockEntity(class_2338 pos, class_2680 state) {
        super(USRegistry.BLOCK_ENTITY_TYPE, pos, state);
        this.containerPos = pos.method_10093((class_2350)state.method_11654(TradeShopBlock.ATTACHED));
        this.textDisplay.setBillboardMode(class_8113.class_8114.field_42409);
        this.textDisplay.setViewRange(0.5f);
        this.itemDisplay.setBillboardMode(class_8113.class_8114.field_42409);
        this.itemDisplay.setModelTransformation(class_811.field_4317);
        this.itemDisplay.setLeftRotation((Quaternionfc)new Quaternionf().rotateY((float)Math.PI));
        this.itemDisplay.setViewRange(0.5f);
        this.itemDisplay.setScale((Vector3fc)new Vector3f(0.6f, 0.6f, 0.01f));
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 lookup) {
        if (this.containerPos != null) {
            nbt.method_10566("ItemContainerPos", (class_2520)LegacyNbtHelper.fromBlockPos(this.containerPos));
        }
        if (this.owner != null) {
            nbt.method_10566("Owner", (class_2520)LegacyNbtHelper.writeGameProfile(new class_2487(), this.owner));
        }
        this.priceHandler.writeNbt(nbt, lookup);
        this.stockHandler.writeNbt(nbt, lookup);
        nbt.method_10556("AllowHoppers", this.allowHoppers);
        nbt.method_10582("HologramMode", this.hologramMode.name());
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 lookup) {
        if (nbt.method_10545("ItemContainerPos")) {
            this.containerPos = LegacyNbtHelper.toBlockPos(nbt.method_10562("ItemContainerPos"));
        }
        if (nbt.method_10545("Owner")) {
            this.owner = LegacyNbtHelper.toGameProfile(nbt.method_10562("Owner"));
        }
        try {
            this.hologramMode = HologramMode.valueOf(nbt.method_10558("HologramMode"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.priceHandler = PriceHandler.readNbt(nbt, this, lookup);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        try {
            this.stockHandler = StockHandler.readNbt(nbt, this, lookup);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.allowHoppers = nbt.method_10577("AllowHoppers");
    }

    public void tick() {
        this.tickHolo();
    }

    private void tickHolo() {
        if (this.hologramMode == HologramMode.DISABLED) {
            if (this.elementHolder != null) {
                this.elementHolder.destroy();
                this.elementHolder = null;
            }
            return;
        }
        if (this.elementHolder == null) {
            class_2350 dir = (class_2350)this.method_11010().method_11654(TradeShopBlock.ATTACHED);
            class_243 pos = class_243.method_26410((class_2382)this.method_11016(), (double)(dir == class_2350.field_11033 ? 0.6 : 0.8));
            if (dir != class_2350.field_11033) {
                pos = pos.method_1031((double)dir.method_10148() * 0.25, 0.0, (double)dir.method_10165() * 0.25);
            }
            this.elementHolder = new ElementHolder();
            ChunkAttachment.of((ElementHolder)this.elementHolder, (class_3218)((class_3218)this.field_11863), (class_243)pos);
        }
        if (this.isFullySetup()) {
            if (this.hologramMode == HologramMode.FULL) {
                if (this.field_11863.method_8510() % 32L != 0L) {
                    return;
                }
                boolean hasStock = this.stockHandler.getMaxAmount(null) != 0;
                this.itemDisplay.setItem(this.stockHandler.icon());
                int lines = 2;
                class_5250 text = class_2561.method_43473().method_10852(this.stockHandler.getStockName()).method_27693("\n").method_10852((class_2561)TextUtil.text("price", this.priceHandler.getText().method_27661().method_10862(class_2583.field_24360.method_27706(class_124.field_1068).method_10982(Boolean.valueOf(false)))).method_10862(class_2583.field_24360.method_27706(class_124.field_1077).method_10982(Boolean.valueOf(true))));
                if (!hasStock) {
                    ++lines;
                    text.method_27693("\n").method_10852((class_2561)(this.getContainer() != EmptyInventory.INSTANCE ? TextUtil.gui("out_of_stock", new Object[0]) : TextUtil.text("stock_missing", new Object[0])).method_27692(class_124.field_1061));
                }
                this.textDisplay.setText((class_2561)text);
                this.itemDisplay.setTranslation((Vector3fc)new Vector3f(0.0f, 0.25f + 0.28f * (float)lines, 0.0f));
                if (this.itemDisplay.getHolder() != this.elementHolder) {
                    this.elementHolder.addElement((VirtualElement)this.itemDisplay);
                }
                if (this.textDisplay.getHolder() != this.elementHolder) {
                    this.elementHolder.addElement((VirtualElement)this.textDisplay);
                }
            } else {
                if (this.field_11863.method_8510() % 12L != 0L) {
                    return;
                }
                class_1799 icon = this.stockHandler.getMaxAmount(null) != 0 || (this.field_11863.method_8510() / 12L & 2L) == 0L ? this.stockHandler.icon() : class_1802.field_8077.method_7854();
                this.itemDisplay.setItem(icon);
                this.itemDisplay.setTranslation((Vector3fc)new Vector3f(0.0f, 0.25f, 0.0f));
                if (this.itemDisplay.getHolder() != this.elementHolder) {
                    this.elementHolder.addElement((VirtualElement)this.itemDisplay);
                }
                if (this.textDisplay.getHolder() != null) {
                    this.elementHolder.removeElement((VirtualElement)this.textDisplay);
                }
            }
        } else {
            if (this.field_11863.method_8510() % 32L != 0L) {
                return;
            }
            this.textDisplay.setText((class_2561)TextUtil.text("requires_setup_by_owner", new Object[0]).method_27692(class_124.field_1061));
            if (this.itemDisplay.getHolder() != null) {
                this.elementHolder.removeElement((VirtualElement)this.itemDisplay);
            }
            if (this.textDisplay.getHolder() != this.elementHolder) {
                this.elementHolder.addElement((VirtualElement)this.textDisplay);
            }
        }
        this.elementHolder.tick();
    }

    public void method_11012() {
        super.method_11012();
        if (this.elementHolder != null) {
            this.elementHolder.destroy();
            this.elementHolder = null;
            this.itemDisplay.setHolder(null);
            this.textDisplay.setHolder(null);
        }
    }

    public void openGui(class_3222 serverPlayer) {
        if (this.isFullySetup()) {
            this.stockHandler.openTradeGui(serverPlayer);
        } else if (this.isOwner((class_1657)serverPlayer)) {
            this.openSettings(serverPlayer);
        } else {
            serverPlayer.method_43496(TextUtil.prefix((class_2561)TextUtil.text("requires_setup_by_owner", new Object[0]).method_27692(class_124.field_1061)));
        }
    }

    public boolean isOwner(class_1657 player) {
        return this.isAdmin() ? USUtil.checkAdmin(player, "admin") : this.isOwner(player.method_7334());
    }

    public boolean isOwner(GameProfile gameProfile) {
        return !this.isAdmin() && this.owner != null && this.owner.getId().equals(gameProfile.getId());
    }

    public boolean isFullySetup() {
        return this.priceHandler.isSetup() && this.stockHandler.isSetup();
    }

    public class_1263 getContainer() {
        class_1263 inv;
        if (this.containerPos != null && this.field_11863 != null && CommonProtection.canInteractBlock((class_1937)this.field_11863, (class_2338)this.containerPos, (GameProfile)this.owner, null) && (inv = USUtil.getInventoryAt(this.field_11863, this.containerPos)) != null) {
            return inv;
        }
        return EmptyInventory.INSTANCE;
    }

    public void openSettings(class_3222 player) {
        new ShopSettingsGui(player, this);
    }

    public class_2561 getTitle() {
        return TextUtil.gui("shop.title" + (this.isAdmin() ? ".admin" : ""), this.owner != null ? this.owner.getName() : class_2561.method_43470((String)"<???>"));
    }

    public boolean isAdmin() {
        return ((TradeShopBlock)this.method_11010().method_26204()).isAdmin;
    }

    @Override
    public class_1263 getInventory() {
        return this.allowHoppers ? this.priceHandler.getInventory() : EmptyInventory.INSTANCE;
    }

    public int[] method_5494(class_2350 side) {
        if (this.getInventory().method_5439() != this.cachedSlots.length) {
            this.cachedSlots = IntStream.range(0, this.getInventory().method_5439()).toArray();
        }
        return this.cachedSlots;
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return false;
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return this.allowHoppers;
    }

    public void method_5453(class_1263 sender) {
        this.method_5431();
    }

    public static enum HologramMode {
        FULL,
        ICON,
        DISABLED;

    }
}

