/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common;

import com.demonwav.mcdev.annotations.CheckEnv;
import com.demonwav.mcdev.annotations.Env;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;
import org.ladysnake.blabber.Blabber;
import org.ladysnake.blabber.api.illustration.DialogueIllustration;
import org.ladysnake.blabber.api.layout.DialogueLayout;
import org.ladysnake.blabber.impl.common.BlabberRegistrar;
import org.ladysnake.blabber.impl.common.InstancedDialogueAction;
import org.ladysnake.blabber.impl.common.PlayerDialogueTracker;
import org.ladysnake.blabber.impl.common.machine.AvailableChoice;
import org.ladysnake.blabber.impl.common.machine.ChoiceResult;
import org.ladysnake.blabber.impl.common.machine.DialogueStateMachine;
import org.ladysnake.blabber.impl.common.model.StateType;
import org.ladysnake.blabber.impl.common.packets.ChoiceAvailabilityPayload;

public class DialogueScreenHandler
extends class_1703 {
    private final DialogueStateMachine dialogue;
    @Nullable
    private final class_1297 interlocutor;

    public DialogueScreenHandler(int syncId, DialogueStateMachine dialogue, @Nullable class_1297 interlocutor) {
        this(BlabberRegistrar.DIALOGUE_SCREEN_HANDLER, syncId, dialogue, interlocutor);
    }

    public DialogueScreenHandler(@Nullable class_3917<?> type, int syncId, DialogueStateMachine dialogue, @Nullable class_1297 interlocutor) {
        super(type, syncId);
        this.dialogue = dialogue;
        this.interlocutor = interlocutor;
    }

    @Nullable
    public class_1297 getInterlocutor() {
        return this.interlocutor;
    }

    public DialogueLayout<DialogueLayout.Params> getLayout() {
        return this.dialogue.getLayout();
    }

    public boolean isUnskippable() {
        return this.dialogue.isUnskippable();
    }

    public class_2561 getCurrentText() {
        return this.dialogue.getCurrentText();
    }

    public List<String> getCurrentIllustrations() {
        return this.dialogue.getCurrentIllustrations();
    }

    public Map<String, DialogueIllustration> getIllustrations() {
        return this.dialogue.getIllustrations();
    }

    public ImmutableList<AvailableChoice> getAvailableChoices() {
        return this.dialogue.getAvailableChoices();
    }

    public String getCurrentStateKey() {
        return this.dialogue.getCurrentStateKey();
    }

    public void setCurrentState(String key) {
        this.dialogue.selectState(key);
    }

    public class_1799 method_7601(class_1657 player, int index) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void handleAvailabilityUpdate(ChoiceAvailabilityPayload packet) {
        this.dialogue.applyAvailabilityUpdate(packet);
    }

    @CheckEnv(value=Env.CLIENT)
    public StateType makeChoice(int choice) {
        return this.dialogue.choose(choice).type();
    }

    public boolean makeChoice(class_3222 player, int choice) {
        try {
            ChoiceResult result = this.dialogue.choose(choice);
            result.action().map(InstancedDialogueAction::action).ifPresent(action -> action.handle(player, this.interlocutor));
            if (result.type() == StateType.END_DIALOGUE && player.field_7512 == this) {
                PlayerDialogueTracker.get((class_1657)player).endDialogue();
            }
            return true;
        }
        catch (IllegalStateException e) {
            Blabber.LOGGER.error("{} made invalid choice {} in {}#{}: {}", (Object)player.method_5820(), (Object)choice, (Object)this.dialogue.getId(), (Object)this.getCurrentStateKey(), (Object)e.getMessage());
            return false;
        }
    }
}

