/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.SimpleResourceReloadListener;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_6860;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.ladysnake.blabber.Blabber;
import org.ladysnake.blabber.impl.common.DialogueRegistry;
import org.ladysnake.blabber.impl.common.PlayerDialogueTracker;
import org.ladysnake.blabber.impl.common.model.DialogueTemplate;
import org.ladysnake.blabber.impl.common.packets.DialogueListPayload;
import org.ladysnake.blabber.impl.common.validation.DialogueLoadingException;
import org.ladysnake.blabber.impl.common.validation.DialogueValidator;
import org.ladysnake.blabber.impl.common.validation.ValidationResult;

public final class DialogueLoader
implements SimpleResourceReloadListener<Map<class_2960, DialogueTemplate>>,
ServerLifecycleEvents.EndDataPackReload {
    public static final String BLABBER_DIALOGUES_PATH = "blabber/dialogues";
    public static final class_2960 ID = Blabber.id("dialogue_loader");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void init() {
        DialogueLoader instance = new DialogueLoader();
        ResourceManagerHelper.get((class_3264)class_3264.field_14190).registerReloadListener((IdentifiableResourceReloadListener)instance);
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((Object)instance);
    }

    public CompletableFuture<Map<class_2960, DialogueTemplate>> load(class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.supplyAsync(() -> {
            HashMap data = new HashMap();
            manager.method_14488(BLABBER_DIALOGUES_PATH, res -> res.method_12832().endsWith(".json")).forEach((location, resource) -> {
                try (InputStreamReader in = new InputStreamReader(resource.method_14482());){
                    JsonObject jsonObject = (JsonObject)GSON.fromJson((Reader)in, JsonObject.class);
                    class_2960 id = class_2960.method_60655((String)location.method_12836(), (String)location.method_12832().substring(BLABBER_DIALOGUES_PATH.length() + 1, location.method_12832().length() - 5));
                    DialogueTemplate dialogue = (DialogueTemplate)DialogueTemplate.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonObject).getOrThrow(message -> {
                        Blabber.LOGGER.error("(Blabber) Could not parse dialogue file from {}: {}", location, message);
                        return new RuntimeException((String)message);
                    });
                    ValidationResult validationResult = DialogueValidator.validateStructure(dialogue);
                    Objects.requireNonNull(validationResult);
                    ValidationResult selector0$temp = validationResult;
                    int index$1 = 0;
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ValidationResult.Error.class, ValidationResult.Warnings.class, ValidationResult.Success.class}, (Object)selector0$temp, index$1)) {
                        default: {
                            throw new MatchException(null, null);
                        }
                        case 0: {
                            ValidationResult.Error error = (ValidationResult.Error)selector0$temp;
                            Blabber.LOGGER.error("(Blabber) Could not validate dialogue {}: {}", (Object)id, (Object)error.message());
                            throw new DialogueLoadingException("Could not validate dialogue file from " + String.valueOf(location));
                        }
                        case 1: {
                            ValidationResult.Warnings warnings = (ValidationResult.Warnings)selector0$temp;
                            Blabber.LOGGER.warn("(Blabber) Dialogue {} had warnings: {}", (Object)id, (Object)warnings.message());
                            data.put(id, dialogue);
                            return;
                        }
                        case 2: {
                            ValidationResult.Success ignored = (ValidationResult.Success)selector0$temp;
                            data.put(id, dialogue);
                            return;
                        }
                    }
                }
                catch (JsonParseException | IOException e) {
                    Blabber.LOGGER.error("(Blabber) Could not read dialogue file from {}", location, (Object)e);
                    throw new DialogueLoadingException("Could not read dialogue file from " + String.valueOf(location), e);
                }
            });
            return data;
        }, executor);
    }

    public CompletableFuture<Void> apply(Map<class_2960, DialogueTemplate> data, class_3300 manager, class_3695 profiler, Executor executor) {
        return CompletableFuture.runAsync(() -> DialogueRegistry.setEntries(data), executor);
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public Collection<class_2960> getFabricDependencies() {
        return Set.of();
    }

    public void endDataPackReload(MinecraftServer server, class_6860 resourceManager, boolean success) {
        if (success) {
            Set<class_2960> dialogueIds = DialogueRegistry.getIds();
            DialogueListPayload idSyncPacket = new DialogueListPayload(dialogueIds);
            for (class_3222 player : server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)idSyncPacket);
                PlayerDialogueTracker.get((class_1657)player).updateDialogue();
            }
        }
    }

    private DialogueLoader() {
    }
}

