/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.client.compat;

import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class BlabberClientMixinPlugin
implements IMixinConfigPlugin {
    private static final String COMPAT_PREFIX = "org.ladysnake.blabber.mixin.client.compat.";
    private static final Pattern COMPAT_MIXIN_PATTERN = Pattern.compile(Pattern.quote("org.ladysnake.blabber.mixin.client.compat.") + "(?<modid>[a-z_]+?)\\..*");
    private final FabricLoader loader = FabricLoader.getInstance();

    public void onLoad(String mixinPackage) {
    }

    @Nullable
    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.startsWith(COMPAT_PREFIX)) {
            return true;
        }
        Matcher matcher = COMPAT_MIXIN_PATTERN.matcher(mixinClassName);
        if (!matcher.matches()) {
            throw new IllegalStateException("Bad compat mixin name " + mixinClassName);
        }
        String modId = matcher.group("modid");
        return this.loader.isModLoaded(modId);
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return List.of();
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

