/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.naturescompass.utils;

import com.chaosthedude.naturescompass.config.NaturesCompassConfig;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_1074;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.apache.commons.lang3.text.WordUtils;

public class BiomeUtils {
    public static class_2378<class_1959> getBiomeRegistry(class_1937 world) {
        return world.method_30349().method_30530(class_7924.field_41236);
    }

    public static class_2960 getIdentifierForBiome(class_1937 world, class_1959 biome) {
        return BiomeUtils.getBiomeRegistry(world).method_10221((Object)biome);
    }

    public static Optional<class_1959> getBiomeForIdentifier(class_1937 world, class_2960 id) {
        return BiomeUtils.getBiomeRegistry(world).method_17966(id);
    }

    public static List<class_2960> getAllowedBiomeIDs(class_1937 world) {
        ArrayList<class_2960> biomeIDs = new ArrayList<class_2960>();
        for (Map.Entry entry : BiomeUtils.getBiomeRegistry(world).method_29722()) {
            class_2960 biomeID;
            class_1959 biome = (class_1959)entry.getValue();
            if (biome == null || (biomeID = BiomeUtils.getIdentifierForBiome(world, biome)) == null || BiomeUtils.biomeIDIsBlacklisted(world, biomeID) || BiomeUtils.biomeIDIsHidden(world, biomeID)) continue;
            biomeIDs.add(biomeID);
        }
        return biomeIDs;
    }

    public static List<class_2960> getGeneratingDimensionIDs(class_3218 serverWorld, class_1959 biome) {
        ArrayList<class_2960> dimensions = new ArrayList<class_2960>();
        class_2378<class_1959> biomeRegistry = BiomeUtils.getBiomeRegistry((class_1937)serverWorld);
        for (class_3218 world : serverWorld.method_8503().method_3738()) {
            class_6880 biomeEntry;
            Set biomeSet = world.method_14178().method_12129().method_12098().method_28443();
            if (!biomeSet.contains(biomeEntry = (class_6880)biomeRegistry.method_40264((class_5321)biomeRegistry.method_29113((Object)biome).get()).get())) continue;
            dimensions.add(world.method_27983().method_29177());
        }
        return dimensions;
    }

    public static ListMultimap<class_2960, class_2960> getGeneratingDimensionsForAllowedBiomes(class_3218 serverWorld) {
        ArrayListMultimap dimensionsForAllowedStructures = ArrayListMultimap.create();
        for (class_2960 biomeID : BiomeUtils.getAllowedBiomeIDs((class_1937)serverWorld)) {
            Optional<class_1959> optionalBiome = BiomeUtils.getBiomeForIdentifier((class_1937)serverWorld, biomeID);
            if (!optionalBiome.isPresent()) continue;
            dimensionsForAllowedStructures.putAll((Object)biomeID, BiomeUtils.getGeneratingDimensionIDs(serverWorld, optionalBiome.get()));
        }
        return dimensionsForAllowedStructures;
    }

    public static int getBiomeSize(class_1937 world) {
        return 4;
    }

    public static int getDistanceToBiome(class_1657 player, int biomeX, int biomeZ) {
        return BiomeUtils.getDistanceToBiome(player.method_24515(), biomeX, biomeZ);
    }

    public static int getDistanceToBiome(class_2338 startPos, int biomeX, int biomeZ) {
        return (int)class_3532.method_15355((float)((float)startPos.method_10262((class_2382)new class_2338(biomeX, startPos.method_10264(), biomeZ))));
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeTags(class_1937 world, class_1959 biome) {
        List<String> tagPathsToIgnore = List.of("is_overworld");
        TreeSet<String> biomeCategories = new TreeSet<String>();
        class_2378<class_1959> biomeRegistry = BiomeUtils.getBiomeRegistry(world);
        if (biomeRegistry.method_29113((Object)biome).isPresent() && biomeRegistry.method_40264((class_5321)biomeRegistry.method_29113((Object)biome).get()).isPresent()) {
            class_6880 biomeEntry = (class_6880)biomeRegistry.method_40264((class_5321)biomeRegistry.method_29113((Object)biome).get()).get();
            List categoryTags = biomeEntry.method_40228().filter(tag -> tag.comp_327().method_12832().startsWith("is_")).collect(Collectors.toList());
            for (class_6862 tag2 : categoryTags) {
                String translatedCategoryKey;
                String translatedBiomeKey;
                String biomeKey;
                if (tagPathsToIgnore.contains(tag2.comp_327().method_12832())) continue;
                String fixedPath = tag2.comp_327().method_12832().replaceFirst("is_", "");
                if (fixedPath.contains("/")) {
                    fixedPath = fixedPath.substring(0, fixedPath.indexOf("/"));
                }
                if (!(biomeKey = class_156.method_646((String)"biome", (class_2960)class_2960.method_60655((String)tag2.comp_327().method_12836(), (String)fixedPath))).equals(translatedBiomeKey = class_1074.method_4662((String)biomeKey, (Object[])new Object[0]))) {
                    return translatedBiomeKey;
                }
                String categoryKey = class_156.method_646((String)"category", (class_2960)class_2960.method_60655((String)tag2.comp_327().method_12836(), (String)fixedPath));
                if (!categoryKey.equals(translatedCategoryKey = class_1074.method_4662((String)categoryKey, (Object[])new Object[0]))) {
                    return translatedCategoryKey;
                }
                biomeCategories.add(WordUtils.capitalize((String)fixedPath.replace('_', ' ')));
            }
        }
        if (biomeCategories.isEmpty()) {
            biomeCategories.add(class_1074.method_4662((String)"string.naturescompass.none", (Object[])new Object[0]));
        }
        return String.join((CharSequence)", ", biomeCategories);
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeNameForDisplay(class_1937 world, class_1959 biome) {
        if (biome != null) {
            if (NaturesCompassConfig.fixBiomeNames) {
                String original = BiomeUtils.getBiomeName(world, biome);
                Object fixed = "";
                char pre = ' ';
                for (int i = 0; i < original.length(); ++i) {
                    char c = original.charAt(i);
                    if (Character.isUpperCase(c) && Character.isLowerCase(pre) && Character.isAlphabetic(pre)) {
                        fixed = (String)fixed + " ";
                    }
                    fixed = (String)fixed + String.valueOf(c);
                    pre = c;
                }
                return fixed;
            }
            if (BiomeUtils.getIdentifierForBiome(world, biome) != null) {
                return class_1074.method_4662((String)BiomeUtils.getIdentifierForBiome(world, biome).toString(), (Object[])new Object[0]);
            }
        }
        return "";
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeName(class_1937 world, class_1959 biome) {
        return class_1074.method_4662((String)class_156.method_646((String)"biome", (class_2960)BiomeUtils.getIdentifierForBiome(world, biome)), (Object[])new Object[0]);
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeName(class_1937 world, class_2960 biomeID) {
        if (BiomeUtils.getBiomeForIdentifier(world, biomeID).isPresent()) {
            return BiomeUtils.getBiomeName(world, BiomeUtils.getBiomeForIdentifier(world, biomeID).get());
        }
        return "";
    }

    @Environment(value=EnvType.CLIENT)
    public static String getBiomeSource(class_1937 world, class_1959 biome) {
        String registryEntry = BiomeUtils.getIdentifierForBiome(world, biome).toString();
        String modid = registryEntry.substring(0, registryEntry.indexOf(":"));
        if (modid.equals("minecraft")) {
            return "Minecraft";
        }
        Optional sourceContainer = FabricLoader.getInstance().getModContainer(modid);
        if (sourceContainer.isPresent()) {
            return ((ModContainer)sourceContainer.get()).getMetadata().getName();
        }
        return modid;
    }

    @Environment(value=EnvType.CLIENT)
    private static String getDimensionName(class_2960 dimensionID) {
        String name = class_1074.method_4662((String)class_156.method_646((String)"dimension", (class_2960)dimensionID), (Object[])new Object[0]);
        if (name.equals(class_156.method_646((String)"dimension", (class_2960)dimensionID))) {
            name = dimensionID.toString();
            if (name.contains(":")) {
                name = name.substring(name.indexOf(":") + 1);
            }
            name = WordUtils.capitalize((String)name.replace('_', ' '));
        }
        return name;
    }

    @Environment(value=EnvType.CLIENT)
    public static String dimensionKeysToString(List<class_2960> dimensions) {
        HashSet dimensionNames = new HashSet();
        dimensions.forEach(key -> dimensionNames.add(BiomeUtils.getDimensionName(key)));
        return String.join((CharSequence)", ", dimensionNames);
    }

    public static boolean biomeIDIsBlacklisted(class_1937 world, class_2960 biomeID) {
        List<String> biomeBlacklist = NaturesCompassConfig.biomeBlacklist;
        for (String biomeKey : biomeBlacklist) {
            if (!biomeID.toString().matches(BiomeUtils.convertToRegex(biomeKey))) continue;
            return true;
        }
        return false;
    }

    public static boolean biomeIDIsHidden(class_1937 world, class_2960 biomeID) {
        class_1959 biome;
        class_2378<class_1959> biomeRegistry;
        if (BiomeUtils.getBiomeForIdentifier(world, biomeID).isPresent() && (biomeRegistry = BiomeUtils.getBiomeRegistry(world)).method_29113((Object)(biome = BiomeUtils.getBiomeForIdentifier(world, biomeID).get())).isPresent() && biomeRegistry.method_40264((class_5321)biomeRegistry.method_29113((Object)biome).get()).isPresent()) {
            class_6880 biomeHolder = (class_6880)biomeRegistry.method_40264((class_5321)biomeRegistry.method_29113((Object)biome).get()).get();
            return biomeHolder.method_40228().anyMatch(tag -> tag.comp_327().method_12832().equals("c:hidden_from_locator_selection"));
        }
        return false;
    }

    private static String convertToRegex(String glob) {
        Object regex = "^";
        for (int i = 0; i < glob.length(); i = (int)((char)(i + 1))) {
            char c = glob.charAt(i);
            regex = c == '*' ? (String)regex + ".*" : (c == '?' ? (String)regex + "." : (c == '.' ? (String)regex + "\\." : (String)regex + c));
        }
        regex = (String)regex + "$";
        return regex;
    }
}

