/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.hexblade.spells;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.cloth.clothconfig.shadowed.blue.endless.jankson.annotation.Nullable;
import net.minecraft.class_2960;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.api.spell.fx.ParticleBatch;
import net.spell_engine.api.spell.fx.Sound;
import net.spell_engine.client.gui.SpellTooltip;
import net.spell_engine.fx.SpellEngineParticles;
import net.spell_engine.fx.SpellEngineSounds;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;

public class HexbladeSpells {
    public static final List<Entry> entries = new ArrayList<Entry>();
    private static Entry frost_slash = HexbladeSpells.add(HexbladeSpells.frost_slash());
    private static Entry flame_slash = HexbladeSpells.add(HexbladeSpells.flame_slash());
    private static Entry amethyst_slash = HexbladeSpells.add(HexbladeSpells.amethyst_slash());
    private static Entry amethyst_slash2 = HexbladeSpells.add(HexbladeSpells.amethyst_slash2());

    private static Entry add(Entry entry) {
        entries.add(entry);
        return entry;
    }

    public static Spell activeSpellBase() {
        Spell spell = new Spell();
        spell.range = 0.0f;
        spell.tier = 7;
        spell.learn = new Spell.Learn();
        spell.type = Spell.Type.ACTIVE;
        spell.active = new Spell.Active();
        spell.active.scroll = new Spell.Active.Scroll();
        return spell;
    }

    private static Spell.Delivery createDelivery(Spell.Delivery.Type type) {
        Spell.Delivery delivery = new Spell.Delivery();
        delivery.type = type;
        return delivery;
    }

    private static Spell.Impact createImpact(Spell.Impact.Action.Type type, float coeff, float knockback) {
        Spell.Impact impact = new Spell.Impact();
        impact.action = new Spell.Impact.Action();
        impact.action.type = type;
        if (type == Spell.Impact.Action.Type.DAMAGE) {
            impact.action.damage = new Spell.Impact.Action.Damage();
            impact.action.damage.knockback = knockback;
            impact.action.damage.spell_power_coefficient = coeff;
        }
        return impact;
    }

    private static Spell projectileBase(SpellSchool school, class_2960 projIdentifier, float velocity, float knockback) {
        Spell spell = HexbladeSpells.activeSpellBase();
        spell.school = school;
        Spell.Delivery delivery = HexbladeSpells.createDelivery(Spell.Delivery.Type.PROJECTILE);
        delivery.projectile = new Spell.Delivery.ShootProjectile();
        delivery.projectile.launch_properties.velocity = velocity;
        delivery.projectile.projectile = new Spell.ProjectileData();
        delivery.projectile.projectile.client_data = new Spell.ProjectileData.Client();
        Spell.ProjectileModel model = new Spell.ProjectileModel();
        model.model_id = String.valueOf(projIdentifier);
        delivery.projectile.projectile.client_data.model = model;
        spell.deliver = delivery;
        Spell.Impact[] impact = new Spell.Impact[]{HexbladeSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, 1.8f, knockback)};
        spell.impacts = List.of(impact[0]);
        return spell;
    }

    public static Spell.Impact createArcaneImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = HexbladeSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.ARCANE;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_arcane_impact_burst", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_ARCANE_RELEASE.id());
        return impact;
    }

    public static Spell.Impact createLightningImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = HexbladeSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.LIGHTNING;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.WHITE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.IMPACT, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.BURST).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_LIGHTNING_RELEASE.id());
        return impact;
    }

    private static Spell.Impact createFrostImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = HexbladeSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.FROST;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_frost_impact_burst", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        impact.particles = hitParticles;
        Spell.TargetCondition targetCondition = new Spell.TargetCondition();
        targetCondition.entity_type = "#minecraft:freeze_immune_entity_types";
        Spell.Impact.TargetModifier targetModifier = new Spell.Impact.TargetModifier();
        targetModifier.conditions = List.of(targetCondition);
        targetModifier.modifier = new Spell.Impact.Modifier();
        targetModifier.modifier.power_multiplier = -0.3f;
        Spell.Impact.TargetModifier targetModifier2 = new Spell.Impact.TargetModifier();
        targetCondition.entity_type = "#minecraft:freeze_hurts_extra_types";
        targetModifier2.conditions = List.of(targetCondition);
        targetModifier2.modifier = new Spell.Impact.Modifier();
        targetModifier2.modifier.power_multiplier = 0.3f;
        impact.target_modifiers = List.of(targetModifier, targetModifier2);
        impact.sound = sound = new Sound(SpellEngineSounds.GENERIC_FROST_IMPACT.id());
        return impact;
    }

    private static Spell.Impact createFireImpact(float coeff, float knockback) {
        Sound sound;
        Spell.Impact impact = HexbladeSpells.createImpact(Spell.Impact.Action.Type.DAMAGE, coeff, knockback);
        impact.school = SpellSchools.FIRE;
        ParticleBatch[] hitParticles = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame_spark.id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f), new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, ParticleBatch.Rotation.LOOK, 20.0f, 0.2f, 0.7f, 360.0f)};
        Spell.TargetCondition targetCondition = new Spell.TargetCondition();
        targetCondition.entity_type = "#minecraft:freeze_immune_entity_types";
        Spell.Impact.TargetModifier targetModifier = new Spell.Impact.TargetModifier();
        targetModifier.conditions = List.of(targetCondition);
        targetModifier.modifier = new Spell.Impact.Modifier();
        targetModifier.modifier.critical_chance_bonus = 0.3f;
        impact.target_modifiers = List.of(targetModifier);
        impact.particles = hitParticles;
        impact.sound = sound = new Sound("minecraft:entity.player.hurt_on_fire");
        return impact;
    }

    private static ParticleBatch arcaneCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.ARCANE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static ParticleBatch fireCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static ParticleBatch frostCastingParticles() {
        return new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.FROST, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPELL, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.ASCEND).id().toString(), ParticleBatch.Shape.WIDE_PIPE, ParticleBatch.Origin.FEET, 1.0f, 0.05f, 0.1f);
    }

    private static Spell.Active.Cast createCast(int channelticks, float duration, String sound, String animation, @Nullable SpellSchool school) {
        Spell.Active.Cast cast = new Spell.Active.Cast();
        cast = new Spell.Active.Cast();
        cast.animation = animation;
        cast.sound = new Sound(sound);
        cast.channel_ticks = channelticks;
        cast.duration = duration;
        if (school != null) {
            if (school.equals(SpellSchools.FIRE)) {
                cast.particles = new ParticleBatch[]{HexbladeSpells.fireCastingParticles()};
            }
            if (school.equals(SpellSchools.FROST)) {
                cast.particles = new ParticleBatch[]{HexbladeSpells.frostCastingParticles()};
            }
            if (school.equals(SpellSchools.ARCANE)) {
                cast.particles = new ParticleBatch[]{HexbladeSpells.arcaneCastingParticles()};
            }
        }
        return cast;
    }

    private static void configureCooldown(Spell spell, float duration, boolean proportional, @Nullable String id) {
        if (spell.cost == null) {
            spell.cost = new Spell.Cost();
        }
        if (spell.cost.cooldown == null) {
            spell.cost.cooldown = new Spell.Cost.Cooldown();
        }
        if (id != null) {
            spell.cost.item = new Spell.Cost.Item();
            spell.cost.item.id = id;
            spell.cost.item.amount = 1;
        }
        if (proportional) {
            spell.cost.cooldown.proportional = true;
        }
        spell.cost.cooldown.duration = duration;
    }

    private static Entry frost_slash() {
        Spell spell = HexbladeSpells.projectileBase(SpellSchools.ARCANE, class_2960.method_60654((String)"spellbladenext:projectile/gladius"), 1.0f, 0.0f);
        spell.school = SpellSchools.FROST;
        class_2960 id = class_2960.method_60655((String)"hexblade", (String)"frost_slash");
        String description = "Attack with a flurry of frost blade projectiles, dealing {damage} Frost damage per second.";
        String title = "Amethyst Slash";
        spell.deliver.projectile.projectile.perks.ricochet = 2;
        spell.deliver.projectile.projectile.divergence = 15.0f;
        spell.deliver.projectile.projectile.client_data.model.scale = 1.0f;
        spell.deliver.projectile.projectile.homing_angle = 10.0f;
        spell.deliver.projectile.projectile.homing_after_absolute_distance = 8.0f;
        spell.deliver.projectile.projectile.homing_after_relative_distance = 0.4f;
        spell.learn = new Spell.Learn();
        spell.tier = 3;
        spell.range = 64.0f;
        spell.active.cast = HexbladeSpells.createCast(3, 6.0f, "spell_engine:generic_frost_casting", "spell_engine:flameslash", SpellSchools.FROST);
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_frost_spark_float", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, null, 2.0f, 0.05f, 0.1f, 360.0f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.FROST, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.FLOAT).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, null, 2.0f, 0.05f, 0.1f, 360.0f)};
        spell.deliver.projectile.projectile.client_data.travel_particles = particlebatch;
        Spell.Impact[] impacts = new Spell.Impact[]{HexbladeSpells.createFrostImpact(1.8f, 0.0f)};
        spell.impacts = List.of(impacts[0]);
        HexbladeSpells.configureCooldown(spell, 4.0f, true, "runes:frost_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry flame_slash() {
        Spell spell = HexbladeSpells.projectileBase(SpellSchools.ARCANE, class_2960.method_60654((String)"spellbladenext:projectile/flamewaveprojectile"), 1.0f, 0.0f);
        spell.school = SpellSchools.FIRE;
        class_2960 id = class_2960.method_60655((String)"hexblade", (String)"flame_slash");
        String description = "Attack with a flurry of flame wave projectiles, dealing {damage} Fire damage per second.";
        String title = "Flame Slash";
        spell.deliver.projectile.projectile.divergence = 15.0f;
        spell.deliver.projectile.projectile.client_data.model.scale = 1.0f;
        spell.deliver.projectile.projectile.homing_angle = 10.0f;
        spell.deliver.projectile.projectile.homing_after_absolute_distance = 8.0f;
        spell.deliver.projectile.projectile.homing_after_relative_distance = 0.4f;
        spell.learn = new Spell.Learn();
        spell.tier = 3;
        spell.range = 64.0f;
        spell.active.cast = HexbladeSpells.createCast(3, 6.0f, "spell_engine:generic_frost_casting", "spell_engine:flameslash", SpellSchools.FROST);
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch(SpellEngineParticles.flame.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 3.0f, 0.05f, 0.1f, 360.0f), new ParticleBatch(SpellEngineParticles.flame_medium_a.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 1.0f, 0.05f, 0.1f, 360.0f), new ParticleBatch(SpellEngineParticles.flame_medium_b.id().toString(), ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 1.0f, 0.05f, 0.1f, 360.0f), new ParticleBatch("minecraft:smoke", ParticleBatch.Shape.SPHERE, ParticleBatch.Origin.CENTER, null, 2.0f, 0.05f, 0.1f, 360.0f)};
        spell.deliver.projectile.projectile.client_data.travel_particles = particlebatch;
        Spell.Impact[] impacts = new Spell.Impact[]{HexbladeSpells.createFireImpact(1.0f, 0.0f)};
        spell.impacts = List.of(impacts[0]);
        HexbladeSpells.configureCooldown(spell, 4.0f, true, "runes:fire_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry amethyst_slash() {
        Spell spell = HexbladeSpells.projectileBase(SpellSchools.ARCANE, class_2960.method_60654((String)"spellbladenext:projectile/amethyst"), 1.0f, 0.0f);
        spell.school = SpellSchools.ARCANE;
        spell.deliver.projectile.projectile.perks.bounce = 4;
        spell.deliver.projectile.projectile.divergence = 15.0f;
        spell.deliver.projectile.projectile.client_data.model.scale = 1.0f;
        spell.deliver.projectile.projectile.homing_angle = 10.0f;
        spell.deliver.projectile.projectile.homing_after_absolute_distance = 8.0f;
        spell.deliver.projectile.projectile.homing_after_relative_distance = 0.4f;
        class_2960 id = class_2960.method_60655((String)"hexblade", (String)"amethyst_slash");
        String description = "Attack with a flurry of amethyst projectiles, dealing {damage} Arcane damage per second.";
        String title = "Amethyst Slash";
        spell.learn = new Spell.Learn();
        spell.tier = 3;
        spell.range = 64.0f;
        spell.active.cast = HexbladeSpells.createCast(3, 6.0f, "spell_engine:generic_arcane_casting", "spell_engine:flameslash", SpellSchools.ARCANE);
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_arcane_spark_float", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, null, 2.0f, 0.05f, 0.1f, 360.0f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.ARCANE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.FLOAT).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, null, 2.0f, 0.05f, 0.1f, 360.0f)};
        spell.deliver.projectile.projectile.client_data.travel_particles = particlebatch;
        Spell.Impact[] impacts = new Spell.Impact[]{HexbladeSpells.createArcaneImpact(1.0f, 0.0f)};
        spell.impacts = List.of(impacts[0]);
        HexbladeSpells.configureCooldown(spell, 4.0f, true, "runes:arcane_stone");
        return new Entry(id, spell, title, description, null);
    }

    private static Entry amethyst_slash2() {
        Spell spell = HexbladeSpells.projectileBase(SpellSchools.ARCANE, class_2960.method_60654((String)"spellbladenext:projectile/amethyst"), 0.1f, 0.0f);
        spell.school = SpellSchools.ARCANE;
        spell.deliver.projectile.projectile.perks.bounce = 4;
        spell.deliver.projectile.projectile.divergence = 15.0f;
        spell.deliver.projectile.projectile.client_data.model.scale = 1.0f;
        class_2960 id = class_2960.method_60655((String)"hexblade", (String)"amethyst_slash2");
        String description = "Attack with a flurry of amethyst projectiles, dealing {damage} Arcane damage per second.";
        String title = "Amethyst Slash";
        spell.learn = new Spell.Learn();
        spell.tier = 3;
        spell.range = 64.0f;
        spell.active.cast = HexbladeSpells.createCast(3, 6.0f, "spell_engine:generic_arcane_casting", "spell_engine:flameslash", SpellSchools.ARCANE);
        ParticleBatch[] particlebatch = new ParticleBatch[]{new ParticleBatch("spell_engine:magic_arcane_spark_float", ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, null, 2.0f, 0.05f, 0.1f, 360.0f), new ParticleBatch(SpellEngineParticles.getMagicParticleVariant((SpellEngineParticles.MagicParticleFamily)SpellEngineParticles.ARCANE, (SpellEngineParticles.MagicParticleFamily.Shape)SpellEngineParticles.MagicParticleFamily.Shape.SPARK, (SpellEngineParticles.MagicParticleFamily.Motion)SpellEngineParticles.MagicParticleFamily.Motion.FLOAT).id().toString(), ParticleBatch.Shape.CIRCLE, ParticleBatch.Origin.CENTER, null, 2.0f, 0.05f, 0.1f, 360.0f)};
        spell.deliver.projectile.projectile.client_data.travel_particles = particlebatch;
        Spell.Impact[] impacts = new Spell.Impact[]{HexbladeSpells.createArcaneImpact(1.0f, 0.0f)};
        spell.impacts = List.of(impacts[0]);
        HexbladeSpells.configureCooldown(spell, 4.0f, true, "runes:arcane_stone");
        return new Entry(id, spell, title, description, null);
    }

    public record Entry(class_2960 id, Spell spell, String title, String description, @Nullable SpellTooltip.DescriptionMutator mutator) {
    }
}

