/*
 * Decompiled with CFR 0.152.
 */
package com.cleannrooster.hexblade.entity.ai;

import com.cleannrooster.hexblade.entity.Magus;
import com.cleannrooster.hexblade.entity.ai.MagusJumpBack;
import com.cleannrooster.hexblade.entity.ai.MeleeAttack;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2338;
import net.minecraft.class_4051;
import net.minecraft.class_4095;
import net.minecraft.class_4101;
import net.minecraft.class_4107;
import net.minecraft.class_4109;
import net.minecraft.class_4110;
import net.minecraft.class_4117;
import net.minecraft.class_4140;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4215;
import net.minecraft.class_4818;
import net.minecraft.class_4822;
import net.minecraft.class_4824;
import net.minecraft.class_4828;
import net.minecraft.class_4829;
import net.minecraft.class_5321;

public class MagusAI {
    private static final int ANGER_DURATION = 600;
    private static final int MELEE_ATTACK_COOLDOWN = 20;
    private static final double ACTIVITY_SOUND_LIKELIHOOD_PER_TICK = 0.0125;
    private static final int MAX_LOOK_DIST = 8;
    private static final int INTERACTION_RANGE = 8;
    private static final double TARGETING_RANGE = 12.0;
    private static final float SPEED_MULTIPLIER_WHEN_IDLING = 0.6f;
    private static final int HOME_CLOSE_ENOUGH_DISTANCE = 2;
    private static final int HOME_TOO_FAR_DISTANCE = 100;
    private static final int HOME_STROLL_AROUND_DISTANCE = 5;
    private static final class_4051 ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT = class_4051.method_36625().method_18418(40.0).method_36627().method_18424();
    private static final class_4051 ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT = class_4051.method_36625().method_18418(40.0).method_36627();

    public static class_4095<?> makeBrain(Magus Magus2, class_4095<Magus> brain) {
        MagusAI.initCoreActivity(Magus2, brain);
        MagusAI.initIdleActivity(Magus2, brain);
        MagusAI.initFightActivity(Magus2, brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    protected static void initMemories(Magus Magus2) {
        class_4208 globalPos = class_4208.method_19443((class_5321)Magus2.method_37908().method_27983(), (class_2338)Magus2.method_24515());
        Magus2.method_18868().method_18878(class_4140.field_18438, (Object)globalPos);
    }

    private static void initCoreActivity(Magus Magus2, class_4095<Magus> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4110(45, 90), (Object)class_4117.method_47191((float)0.6f), (Object)class_4818.method_47014((float)1.0f), (Object)class_4107.method_46964(), (Object)class_4829.method_47143()));
    }

    private static void initIdleActivity(Magus Magus1, class_4095<Magus> brain) {
        brain.method_18882(class_4168.field_18595, 10, ImmutableList.of((Object)class_4824.method_47120(magus -> (Boolean)Magus1.method_5841().method_12789(Magus.DOWN2) == false, MagusAI::findNearestValidAttackTarget), (Object)new class_4101(30, 60), (Object)class_4818.method_47014((float)0.6f), (Object)class_4109.method_47082((class_1299)class_1299.field_6097, (int)4)));
    }

    private static void initFightActivity(Magus Magus1, class_4095<Magus> brain) {
        brain.method_24527(class_4168.field_22396, 10, ImmutableList.of((Object)class_4828.method_47138(livingEntity -> !MagusAI.isNearestValidAttackTarget(Magus1, livingEntity)), new MagusJumpBack(4.5, 1.0f), (Object)class_4822.method_47098(archmagus -> {
            if (!((Boolean)Magus1.method_5841().method_12789(Magus.DOWN2)).booleanValue() && ((Boolean)Magus1.method_5841().method_12789(Magus.BIDED)).booleanValue()) {
                return Float.valueOf(1.3f);
            }
            if (!((Boolean)Magus1.method_5841().method_12789(Magus.DOWN2)).booleanValue()) {
                return Float.valueOf(1.0f);
            }
            return Float.valueOf(0.0f);
        }), (Object)((Object)new MeleeAttack(20))), class_4140.field_22355);
    }

    public static void updateActivity(Magus Magus2) {
        class_4095 brain = Magus2.method_18868();
        class_4168 activity = brain.method_24538().orElse(null);
        brain.method_24531((List)ImmutableList.of((Object)class_4168.field_22396, (Object)class_4168.field_18595));
        class_4168 activity2 = brain.method_24538().orElse(null);
        if (activity != activity2) {
            MagusAI.playActivitySound(Magus2);
        }
        Magus2.method_19540(brain.method_18896(class_4140.field_22355));
    }

    private static boolean isNearestValidAttackTarget(Magus Magus2, class_1309 livingEntity) {
        return MagusAI.findNearestValidAttackTarget(Magus2).filter(livingEntity2 -> livingEntity2 == livingEntity).isPresent();
    }

    public static boolean isEntityAttackableIgnoringLineOfSight(class_1309 livingEntity, class_1309 livingEntity2) {
        return livingEntity.method_18868().method_29519(class_4140.field_22355, (Object)livingEntity2) ? ATTACK_TARGET_CONDITIONS_IGNORE_INVISIBILITY_AND_LINE_OF_SIGHT.method_18419(livingEntity, livingEntity2) : ATTACK_TARGET_CONDITIONS_IGNORE_LINE_OF_SIGHT.method_18419(livingEntity, livingEntity2);
    }

    private static Optional<? extends class_1309> findNearestValidAttackTarget(Magus Magus2) {
        Optional optional = class_4215.method_24560((class_1309)Magus2, (class_4140)class_4140.field_22333);
        if (optional.isPresent() && MagusAI.isEntityAttackableIgnoringLineOfSight((class_1309)Magus2, (class_1309)optional.get())) {
            return optional;
        }
        Optional optional2 = MagusAI.getTargetIfWithinRange(Magus2, (class_4140<? extends class_1309>)class_4140.field_22354);
        return optional2.isPresent() ? optional2 : Magus2.method_18868().method_46873(class_4140.field_25360);
    }

    private static Optional<? extends class_1309> getTargetIfWithinRange(Magus Magus2, class_4140<? extends class_1309> memoryModuleType) {
        return Magus2.method_18868().method_46873(memoryModuleType).filter(livingEntity -> livingEntity.method_24516((class_1297)Magus2, 36.0));
    }

    private static void playActivitySound(Magus Magus2) {
        Magus2.method_18868().method_24538().ifPresent(activity -> {});
    }
}

