/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.surface;

import com.mojang.datafixers.util.Pair;
import dev.worldgen.lithostitched.LithostitchedCommon;
import dev.worldgen.lithostitched.registry.LithostitchedRegistryKeys;
import dev.worldgen.lithostitched.worldgen.modifier.AddSurfaceRuleModifier;
import dev.worldgen.lithostitched.worldgen.surface.LithostitchedSurfaceRules;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2378;
import net.minecraft.class_2794;
import net.minecraft.class_2960;
import net.minecraft.class_3754;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5363;
import net.minecraft.class_5455;
import net.minecraft.class_6686;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;

public class SurfaceRuleManager {
    public static void applySurfaceRules(MinecraftServer server) {
        class_5455.class_6890 registryAccess = server.method_30611();
        Set surfaceRules = registryAccess.method_30530(LithostitchedRegistryKeys.WORLDGEN_MODIFIER).method_29722().stream().filter(entry -> entry.getValue() instanceof AddSurfaceRuleModifier).collect(Collectors.toSet());
        if (surfaceRules.isEmpty()) {
            return;
        }
        HashMap assignedSurfaceRules = new HashMap();
        for (Map.Entry assignedSurfaceRule : surfaceRules) {
            AddSurfaceRuleModifier slice = (AddSurfaceRuleModifier)assignedSurfaceRule.getValue();
            slice.levels().forEach(levelStemResourceKey -> assignedSurfaceRules.computeIfAbsent(levelStemResourceKey.method_29177(), __ -> new ArrayList()).add(Pair.of((Object)((class_5321)assignedSurfaceRule.getKey()).method_29177(), (Object)slice)));
        }
        class_2378 dimensions = registryAccess.method_30530(class_7924.field_41224);
        for (Map.Entry entry2 : dimensions.method_29722()) {
            class_2794 chunkGenerator;
            class_2960 location = ((class_5321)entry2.getKey()).method_29177();
            ArrayList surfaceRulesForKey = (ArrayList)assignedSurfaceRules.get(location);
            if (surfaceRulesForKey == null || !((chunkGenerator = ((class_5363)entry2.getValue()).comp_1013()) instanceof class_3754)) continue;
            class_5284 settings = (class_5284)((class_3754)chunkGenerator).method_41541().comp_349();
            class_6686.class_6708 oldRules = settings.comp_478();
            ((class_3754)chunkGenerator).field_24774 = class_6880.method_40223((Object)new class_5284(settings.comp_474(), settings.comp_475(), settings.comp_476(), settings.comp_477(), SurfaceRuleManager.buildModdedSurfaceRules(surfaceRulesForKey, oldRules), settings.comp_538(), settings.comp_479(), settings.comp_480(), settings.method_33757(), settings.comp_482(), settings.comp_483()));
            LithostitchedCommon.debug("Applied {} surface rule additions for '{}' dimension", surfaceRulesForKey.size(), location);
        }
    }

    private static class_6686.class_6708 buildModdedSurfaceRules(ArrayList<Pair<class_2960, AddSurfaceRuleModifier>> moddedSourceList, class_6686.class_6708 originalSource) {
        ArrayList<class_6686.class_6708> newRuleSourceList = new ArrayList<class_6686.class_6708>();
        moddedSourceList.forEach((Consumer<Pair<class_2960, AddSurfaceRuleModifier>>)((Consumer<Pair>)pair -> newRuleSourceList.add(((AddSurfaceRuleModifier)pair.getSecond()).surfaceRule())));
        newRuleSourceList.add(originalSource);
        if (originalSource instanceof LithostitchedSurfaceRules.TransientMergedRuleSource) {
            ((LithostitchedSurfaceRules.TransientMergedRuleSource)originalSource).sequence().addAll(newRuleSourceList);
            return originalSource;
        }
        return new LithostitchedSurfaceRules.TransientMergedRuleSource(newRuleSourceList, originalSource);
    }
}

