/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.item;

import dev.xylonity.knightquest.common.item.KQFullSetChecker;
import dev.xylonity.knightquest.common.material.KQArmorMaterials;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1811;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class KQArmorItem
extends class_1738 {
    public static final Map<UUID, Map<class_6880<class_1741>, Boolean>> effectAppliedByArmorMap = new ConcurrentHashMap<UUID, Map<class_6880<class_1741>, Boolean>>();
    private final String bonusTooltip;
    private final boolean hasTooltip;
    private static final class_1293 SHIELD_ARMOR = new class_1293(class_1294.field_5907, -1, 0, false, false, true);
    private static final class_1293 BAT_ARMOR = new class_1293(class_1294.field_5925, -1, 0, false, false, true);
    private static final class_1293 PATH_ARMOR = new class_1293(class_1294.field_5904, -1, 1, false, true, true);
    private static final class_1293 BOW_ARMOR = new class_1293(class_1294.field_5904, -1, 1, false, false, true);
    private static final class_1293 HORN_ARMOR = new class_1293(class_1294.field_5910, 400, 1, false, false, true);
    private static final class_1293 SEA_ARMOR = new class_1293(class_1294.field_5900, -1, 0, false, false, true);
    private static final class_1293 PIRATE_ARMOR = new class_1293(class_1294.field_5926, -1, 0, false, false, true);
    private static final class_1293 SPIDER_ARMOR = new class_1293(class_1294.field_5913, -1, 1, false, false, false);
    private static final class_1293 PHANTOM_ARMOR = new class_1293(class_1294.field_5904, -1, 0, false, false, true);
    private static final class_1293 NETHER_ARMOR = new class_1293(class_1294.field_5918, -1, 0, false, false, true);
    private static final class_1293 SKULK_ARMOR = new class_1293(class_1294.field_5907, -1, 1, false, false, true);
    private static final class_1293 STRAWHAT_ARMOR = new class_1293(class_1294.field_5923, -1, 0, false, false, true);

    public KQArmorItem(class_6880<class_1741> material, class_1738.class_8051 type, class_1792.class_1793 settings, boolean hasTooltip) {
        super(material, type, settings);
        this.bonusTooltip = KQArmorMaterials.getKeyNameFromMaterial(material);
        this.hasTooltip = hasTooltip;
    }

    private boolean isArmorSetConfigEnabled(String bonusTooltip) {
        try {
            ArmorSet armorSet = ArmorSet.valueOf(bonusTooltip.toUpperCase());
            return armorSet.isEnabled();
        }
        catch (Exception e) {
            return false;
        }
    }

    public void method_7851(@NotNull class_1799 stack, @NotNull class_1792.class_9635 context, @NotNull List<class_2561> tooltipComponents, @NotNull class_1836 tooltipFlag) {
        if (this.hasTooltip && this.isArmorSetConfigEnabled(this.bonusTooltip)) {
            if (!Objects.equals(this.bonusTooltip, "chainmail") && !Objects.equals(this.bonusTooltip, "tengu")) {
                if (KQConfigValues.REQUIRED_ARMOR_PIECES.get() < 4) {
                    tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.item.knightquest.set_bonus"));
                } else {
                    tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.item.knightquest.full_set_bonus"));
                }
                tooltipComponents.add((class_2561)class_2561.method_43469((String)("tooltip.item.knightquest." + this.bonusTooltip + "_helmet.bonus"), (Object[])new Object[]{class_2561.method_43470((String)("-" + (int)Math.floor(KQConfigValues.EVOKER_DARKNESS_CHANCE.get().floatValue() * 100.0f) + "%")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)("-" + (int)Math.floor(KQConfigValues.BLAZE_FIRE_CHANCE.get().floatValue() * 100.0f) + "%")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)("-" + (int)Math.floor(KQConfigValues.DRAGONSET_DAMAGE_MULTIPLIER.get().floatValue() * 100.0f - 100.0f) + "%")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)String.valueOf(KQConfigValues.SKULK_MAX_LIGHT_LEVEL.get())).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)("-" + (int)Math.floor(KQConfigValues.CHANCE_ENDERMANSET.get().floatValue() * 100.0f) + "%")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)String.valueOf(KQConfigValues.TELEPORT_RADIUS_ENDERMANSET.get())).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)("-" + (int)Math.floor(KQConfigValues.FORZESET_DEFLECT_CHANCE.get().floatValue() * 100.0f) + "%")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)(100.0 - KQConfigValues.CREEPER_EXPLOSION_DAMAGE_MULTIPLIER.get() * 100.0 + "%")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)("-" + (int)Math.floor(KQConfigValues.SILVERSET_BURN_CHANCE.get().floatValue() * 100.0f) + "%")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)((int)Math.floor(KQConfigValues.HOLLOWSET_HEALING_MULTIPLIER.get().floatValue() * 100.0f) + "%")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)("-" + (int)Math.floor(KQConfigValues.WITHERSET_WITHER_CHANCE.get().floatValue() * 100.0f) + "%")).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)String.valueOf(Math.floor(KQConfigValues.ZOMBIESET_HEALING_AMOUNT.get().floatValue()))).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)String.valueOf(KQConfigValues.ZOMBIESET_HEALING_TICKS.get() / 20)).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080}), class_2561.method_43470((String)String.valueOf(KQConfigValues.SILVERFISH_EFFECT_MAX_HEIGHT.get())).method_27695(new class_124[]{class_124.field_1056, class_124.field_1080})}));
            } else if (Objects.equals(this.bonusTooltip, "tengu")) {
                tooltipComponents.add((class_2561)class_2561.method_43471((String)"tooltip.item.knightquest.full_helmet_bonus"));
                tooltipComponents.add((class_2561)class_2561.method_43471((String)("tooltip.item.knightquest." + this.bonusTooltip + "_helmet.bonus")));
            }
        }
        super.method_7851(stack, context, tooltipComponents, tooltipFlag);
    }

    public void method_7888(@NotNull class_1799 stack, class_1937 level, @NotNull class_1297 entity, int slotId, boolean isSelected) {
        if (!level.method_8608() && entity instanceof class_1657) {
            class_1657 player = (class_1657)entity;
            UUID playerUUID = player.method_5667();
            if (KQConfigValues.PATHSET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.PATHSET) && level.method_8530()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.PATHSET, false))) {
                        player.method_6092(PATH_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PATHSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.PATHSET, false))) {
                    player.method_6016(class_1294.field_5904);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PATHSET, false);
                }
            }
            if (KQConfigValues.BOWSET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BOWSET) && player.method_6047().method_7909() instanceof class_1811) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.BOWSET, false))) {
                        player.method_6092(BOW_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BOWSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.BOWSET, false))) {
                    player.method_6016(class_1294.field_5904);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BOWSET, false);
                }
            }
            if (KQConfigValues.BATSET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BATSET) && level.method_23886()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.BATSET, false))) {
                        player.method_6092(BAT_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BATSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.BATSET, false))) {
                    player.method_6016(class_1294.field_5925);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.BATSET, false);
                }
            }
            if (KQConfigValues.SHIELDSET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SHIELDSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SHIELDSET, false))) {
                        player.method_6092(SHIELD_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SHIELDSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SHIELDSET, false))) {
                    player.method_6016(class_1294.field_5907);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SHIELDSET, false);
                }
            }
            if (KQConfigValues.PHANTOMSET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.PHANTOMSET) && level.method_23886()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.PHANTOMSET, false))) {
                        player.method_6092(PHANTOM_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PHANTOMSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.PHANTOMSET, false))) {
                    player.method_6016(class_1294.field_5904);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PHANTOMSET, false);
                }
            }
            if (KQConfigValues.HORNSET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HORNSET) && player.method_49107() != null) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.HORNSET, false))) {
                        player.method_6092(HORN_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.HORNSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.HORNSET, false))) {
                    player.method_6016(class_1294.field_5910);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.HORNSET, false);
                }
            }
            if (KQConfigValues.SEASET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SEASET) && player.method_5869()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SEASET, false))) {
                        player.method_6092(SEA_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SEASET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SEASET, false))) {
                    player.method_6016(class_1294.field_5900);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SEASET, false);
                }
            }
            if (KQConfigValues.PIRATESET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.PIRATESET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.PIRATESET, false))) {
                        player.method_6092(PIRATE_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PIRATESET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.PIRATESET, false))) {
                    player.method_6016(class_1294.field_5926);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.PIRATESET, false);
                }
            }
            if (KQConfigValues.SPIDERSET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SPIDERSET) && player.method_5715()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SPIDERSET, false))) {
                        player.method_6092(SPIDER_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SPIDERSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SPIDERSET, false))) {
                    player.method_6016(class_1294.field_5913);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SPIDERSET, false);
                }
            }
            if (KQConfigValues.NETHERSET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.NETHERSET)) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.NETHERSET, false))) {
                        player.method_6092(NETHER_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.NETHERSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.NETHERSET, false))) {
                    player.method_6016(class_1294.field_5918);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.NETHERSET, false);
                }
            }
            if (KQConfigValues.SKULK.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SKULK) && player.method_37908().method_22339(player.method_24515()) <= KQConfigValues.SKULK_MAX_LIGHT_LEVEL.get()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SKULK, false))) {
                        player.method_6092(SKULK_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SKULK, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SKULK, false))) {
                    player.method_6016(class_1294.field_5907);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.SKULK, false);
                }
            }
            if (KQConfigValues.STRAWHATSET.get().booleanValue()) {
                if (KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.STRAWHATSET) && player.method_5869()) {
                    if (!Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.STRAWHATSET, false))) {
                        player.method_6092(STRAWHAT_ARMOR);
                        effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.STRAWHATSET, true);
                    }
                } else if (Boolean.TRUE.equals(effectAppliedByArmorMap.computeIfAbsent(playerUUID, k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.STRAWHATSET, false))) {
                    player.method_6016(class_1294.field_5923);
                    effectAppliedByArmorMap.get(playerUUID).put(KQArmorMaterials.STRAWHATSET, false);
                }
            }
        }
        super.method_7888(stack, level, entity, slotId, isSelected);
    }

    public static enum ArmorSet {
        DEEPSLATE(KQConfigValues.DEEPSLATESET.get()),
        EVOKER(KQConfigValues.EVOKERSET.get()),
        SQUIRE(KQConfigValues.SQUIRESET.get()),
        BLAZE(KQConfigValues.BLAZESET.get()),
        DRAGON(KQConfigValues.DRAGONSET.get()),
        BAMBOO_GREEN(KQConfigValues.BAMBOOSET_GREEN.get()),
        SHINOBI(KQConfigValues.SHINOBI.get()),
        BAMBOO(KQConfigValues.BAMBOOSET.get()),
        PATH(KQConfigValues.PATHSET.get()),
        BOW(KQConfigValues.BOWSET.get()),
        BAT(KQConfigValues.BATSET.get()),
        SHIELD(KQConfigValues.SHIELDSET.get()),
        PHANTOM(KQConfigValues.PHANTOMSET.get()),
        HORN(KQConfigValues.HORNSET.get()),
        SEA(KQConfigValues.SEASET.get()),
        PIRATE(KQConfigValues.PIRATESET.get()),
        SPIDER(KQConfigValues.SPIDERSET.get()),
        NETHER(KQConfigValues.NETHERSET.get()),
        SKULK(KQConfigValues.SKULK.get()),
        STRAWHAT(KQConfigValues.STRAWHATSET.get()),
        ENDERMAN(KQConfigValues.ENDERMANSET.get()),
        VETERAN(KQConfigValues.VETERANSET.get()),
        FORZE(KQConfigValues.FORZESET.get()),
        CREEPER(KQConfigValues.CREEPERSET.get()),
        POLAR(KQConfigValues.POLAR.get()),
        SILVER(KQConfigValues.SILVERSET.get()),
        HOLLOW(KQConfigValues.HOLLOWSET.get()),
        WITHER(KQConfigValues.WITHERSET.get()),
        APPLE(KQConfigValues.APPLE_SET.get()),
        CONQUISTADOR(KQConfigValues.CONQUISTADORSET.get()),
        WITCH(KQConfigValues.WITCH.get()),
        TENGU(KQConfigValues.TENGU_HELMET.get()),
        HUSK(KQConfigValues.HUSKSET.get()),
        BAMBOO_BLUE(KQConfigValues.BAMBOOSET_BLUE.get()),
        WARLORD(KQConfigValues.WARLORDSET.get()),
        ZOMBIE(KQConfigValues.ZOMBIESET.get()),
        SILVERFISH(KQConfigValues.SILVERFISHSET.get()),
        SKELETON(KQConfigValues.SKELETONSET.get());

        private final Boolean configValue;

        private ArmorSet(Boolean configValue) {
            this.configValue = configValue;
        }

        public boolean isEnabled() {
            return this.configValue;
        }
    }
}

