/*
 * Decompiled with CFR 0.152.
 */
package dev.xylonity.knightquest.common.event;

import dev.xylonity.knightquest.common.item.KQArmorItem;
import dev.xylonity.knightquest.common.item.KQFullSetChecker;
import dev.xylonity.knightquest.common.item.weapons.PaladinWeapon;
import dev.xylonity.knightquest.common.material.KQArmorMaterials;
import dev.xylonity.knightquest.config.values.KQConfigValues;
import dev.xylonity.knightquest.registry.KnightQuestItems;
import dev.xylonity.knightquest.registry.KnightQuestWeapons;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerLivingEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1937;
import net.minecraft.class_1972;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2596;
import net.minecraft.class_2675;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_746;
import net.minecraft.class_8111;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class KQArmorEvents {
    private static final class_1293 HUSK_ARMOR = new class_1293(class_1294.field_5907, -1, 1, false, false, true);
    private static final class_1293 BAMBOO_BLUE = new class_1293(class_1294.field_5904, -1, 1, false, false, true);
    private static final class_1293 SILVERFISH_ARMOR = new class_1293(class_1294.field_5917, -1, 0, false, false, true);

    private static boolean isTeleportPositionValid(class_1937 level, class_2338 pos) {
        return !level.method_8320(pos.method_10074()).method_26215() && level.method_8320(pos).method_26215() && level.method_8320(pos.method_10084()).method_26215();
    }

    public static class OnEntityTickEvent
    implements ServerTickEvents.EndTick {
        public void onEndTick(MinecraftServer server) {
            for (class_3222 player : server.method_3760().method_14571()) {
                class_9279 customData = (class_9279)player.method_6047().method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
                class_2487 dataTag = customData.method_57461();
                if (player.method_6047().method_7909() instanceof PaladinWeapon && KQConfigValues.PALADIN.get().booleanValue() && player.field_6012 % KQConfigValues.REGEN_TICKS_PALADIN.get() == 0 && player.method_6032() < player.method_6063() * KQConfigValues.REGEN_MAX_PALADIN.get().floatValue() && dataTag.method_10577("Activated")) {
                    player.method_6025(KQConfigValues.REGEN_HP_PALADIN.get().floatValue());
                }
                if (KQConfigValues.HUSKSET.get().booleanValue()) {
                    if (KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.HUSKSET) && (player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9424) || player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9415) || player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9434))) {
                        if (!Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.HUSKSET, false))) {
                            player.method_6092(HUSK_ARMOR);
                            KQArmorItem.effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.HUSKSET, true);
                        }
                    } else if (Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.HUSKSET, false))) {
                        player.method_6016(class_1294.field_5907);
                        KQArmorItem.effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.HUSKSET, false);
                    }
                }
                if (KQConfigValues.BAMBOOSET_BLUE.get().booleanValue()) {
                    if (KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.BAMBOOSET_BLUE) && (player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9417) || player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_9440) || player.method_37908().method_23753(player.method_24515()).method_40225(class_1972.field_35118))) {
                        if (!Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                            player.method_6092(BAMBOO_BLUE);
                            KQArmorItem.effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.BAMBOOSET_BLUE, true);
                        }
                    } else if (Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.BAMBOOSET_BLUE, false))) {
                        player.method_6016(class_1294.field_5904);
                        KQArmorItem.effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.BAMBOOSET_BLUE, false);
                    }
                }
                if (KQConfigValues.WARLORDSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.WARLORDSET)) {
                    for (class_1297 entity : player.method_37908().method_18467(class_1657.class, player.method_5829().method_1014((double)KQConfigValues.WARLORD_SET_EFFECT_RADIUS.get().floatValue()))) {
                        class_1657 nearbyPlayer;
                        if (KQConfigValues.SHOULD_WARLORD_SET_EFFECT_APPLY_TO_ITSELF.get().booleanValue()) {
                            if (!(entity instanceof class_1657)) continue;
                            nearbyPlayer = (class_1657)entity;
                            nearbyPlayer.method_6092(new class_1293(class_1294.field_5907, 100, 0, false, false, true));
                            continue;
                        }
                        if (!(entity instanceof class_1657)) continue;
                        nearbyPlayer = (class_1657)entity;
                        if (entity == player) continue;
                        nearbyPlayer.method_6092(new class_1293(class_1294.field_5907, 100, 0, false, false, true));
                    }
                }
                if (!player.method_37908().method_8608()) {
                    if (KQConfigValues.ZOMBIESET.get().booleanValue() && KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.ZOMBIESET) && player.method_37908().method_23886() && player.field_6012 % KQConfigValues.ZOMBIESET_HEALING_TICKS.get() == 0) {
                        player.method_6025(KQConfigValues.ZOMBIESET_HEALING_AMOUNT.get().floatValue());
                    }
                    if (KQConfigValues.APPLE_SET.get().booleanValue() && KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.APPLE_SET) && player.field_6012 % 400 == 0) {
                        player.method_6025(1.0f);
                    }
                }
                if (KQConfigValues.POLAR.get().booleanValue() && KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.POLAR)) {
                    player.method_32317(0);
                }
                if (!KQConfigValues.SILVERFISHSET.get().booleanValue()) continue;
                if (KQFullSetChecker.hasFullSetOn((class_1657)player, KQArmorMaterials.SILVERFISHSET) && player.method_23318() < (double)KQConfigValues.SILVERFISH_EFFECT_MAX_HEIGHT.get().intValue()) {
                    if (Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SILVERFISHSET, false))) continue;
                    player.method_6092(SILVERFISH_ARMOR);
                    KQArmorItem.effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.SILVERFISHSET, true);
                    continue;
                }
                if (!Boolean.TRUE.equals(KQArmorItem.effectAppliedByArmorMap.computeIfAbsent(player.method_5667(), k -> new ConcurrentHashMap()).getOrDefault(KQArmorMaterials.SILVERFISHSET, false))) continue;
                player.method_6016(class_1294.field_5917);
                KQArmorItem.effectAppliedByArmorMap.get(player.method_5667()).put(KQArmorMaterials.SILVERFISHSET, false);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static class ClientEventHandlers {
        private static final Map<UUID, Boolean> doubleJumpStates = new ConcurrentHashMap<UUID, Boolean>();

        public static void registerClientEvents() {
            ClientTickEvents.END_CLIENT_TICK.register(ClientEventHandlers::onClientTick);
        }

        private static void onClientTick(class_310 client) {
            class_746 player = client.field_1724;
            if (player == null) {
                return;
            }
            class_9279 customData = (class_9279)client.field_1724.method_6047().method_57825(class_9334.field_49628, (Object)class_9279.field_49302);
            class_2487 dataTag = customData.method_57461();
            if (KQConfigValues.TENGU_HELMET.get().booleanValue() && player.method_31548().method_7372(3).method_7909() == KnightQuestItems.TENGU_HELMET.get() || KQConfigValues.NAIL.get().booleanValue() && player.method_6047().method_7909() == KnightQuestWeapons.NAIL && dataTag.method_10577("Activated")) {
                boolean canDoubleJump = doubleJumpStates.getOrDefault(player.method_5667(), true);
                if (!player.method_24828() && player.method_18798().field_1351 < 0.0 && canDoubleJump && client.field_1690.field_1903.method_1434()) {
                    ClientEventHandlers.handleClientSideDoubleJump(player);
                }
                if (player.method_24828()) {
                    doubleJumpStates.put(player.method_5667(), true);
                }
            }
        }

        private static void handleClientSideDoubleJump(class_746 player) {
            UUID playerUUID = player.method_5667();
            boolean canDoubleJump = doubleJumpStates.getOrDefault(playerUUID, true);
            if (canDoubleJump) {
                doubleJumpStates.put(playerUUID, false);
                for (int i = 0; i < 360; i += 60) {
                    double angleRadians = Math.toRadians(i);
                    double particleX = player.method_23317() + 0.4 * Math.cos(angleRadians);
                    double particleZ = player.method_23321() + 0.4 * Math.sin(angleRadians);
                    player.method_37908().method_8406((class_2394)class_2398.field_11204, particleX, player.method_23318(), particleZ, 0.0, 0.35, 0.0);
                }
                player.method_6043();
            }
        }
    }

    public static class OnEntityDeathWorldEvent
    implements ServerLivingEntityEvents.AfterDeath {
        public void afterDeath(class_1309 entity, class_1282 damageSource) {
            class_1297 class_12972;
            if (entity != null && (class_12972 = damageSource.method_5529()) instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                if (KQConfigValues.CONQUISTADORSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.CONQUISTADORSET)) {
                    player.method_6092(new class_1293(class_1294.field_5910, 200, 1, false, true, true));
                }
                if (KQConfigValues.WITCH.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITCH)) {
                    player.method_6092(new class_1293(class_1294.field_5924, 80, 0, false, true, true));
                }
            }
        }
    }

    public static class OnEntityJoinWorldEvent
    implements ServerEntityEvents.Load {
        public void onLoad(class_1297 entity, class_3218 world) {
            class_1657 player;
            class_1665 arrow;
            class_1297 class_12972;
            if (KQConfigValues.SKELETONSET.get().booleanValue() && entity instanceof class_1665 && (class_12972 = (arrow = (class_1665)entity).method_24921()) instanceof class_1657 && KQFullSetChecker.hasFullSetOn(player = (class_1657)class_12972, KQArmorMaterials.SKELETONSET)) {
                arrow.method_7438(arrow.method_7448() * 2.0);
            }
        }
    }

    public static class OnHurtPlayerHandler
    implements ServerLivingEntityEvents.AllowDamage {
        private static final ThreadLocal<Boolean> isProcessingDamage = ThreadLocal.withInitial(() -> false);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean allowDamage(class_1309 entity, class_1282 source, float amount) {
            class_1297 random;
            class_1657 player;
            class_1309 livingEntity;
            if (isProcessingDamage.get().booleanValue()) {
                return true;
            }
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_6047().method_7909() == KnightQuestWeapons.KUKRI && KQConfigValues.KUKRI.get().booleanValue()) {
                entity.method_32317(entity.method_32312() + KQConfigValues.FREEZE_TICKS_KUKRI.get());
            }
            if ((class_12972 = source.method_5529()) instanceof class_1309 && (livingEntity = (class_1309)class_12972).method_6047().method_7909() == KnightQuestWeapons.KHOPESH && KQConfigValues.KHOPESH.get().booleanValue() && livingEntity.method_59922().method_43057() <= KQConfigValues.CHANCE_BURN_KHOPESH.get().floatValue()) {
                entity.method_20803((livingEntity.method_59922().method_43048(7) + 1) * 20);
            }
            if (entity instanceof class_1657) {
                player = (class_1657)entity;
                if (KQConfigValues.EVOKERSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.EVOKERSET)) {
                    random = entity.method_37908().method_8409();
                    if (source.method_5529() instanceof class_1309 && random.method_43057() < KQConfigValues.EVOKER_DARKNESS_CHANCE.get().floatValue()) {
                        entity.method_6092(new class_1293(class_1294.field_38092, 120, 0, false, false, true));
                    }
                }
                if (KQConfigValues.BLAZESET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BLAZESET)) {
                    random = entity.method_37908().method_8409();
                    if (source.method_5529() != null && random.method_43057() < KQConfigValues.BLAZE_FIRE_CHANCE.get().floatValue()) {
                        source.method_5529().method_5639((float)random.method_43051(KQConfigValues.BLAZE_FIRE_DURATION_MIN.get().intValue(), KQConfigValues.BLAZE_FIRE_DURATION_MAX.get().intValue()));
                    }
                }
                if (KQConfigValues.DRAGONSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.DRAGONSET) && source.method_49708(class_8111.field_42351)) {
                    return false;
                }
                if (KQConfigValues.BAMBOOSET_GREEN.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET_GREEN) && player.method_6059(class_1294.field_5899) && (source.method_49708(class_8111.field_42349) || source.method_49708(class_8111.field_42329))) {
                    player.method_6016(class_1294.field_5899);
                    return false;
                }
                if (KQConfigValues.SHINOBI.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SHINOBI) && source.method_5529() != null) {
                    player.method_6092(new class_1293(class_1294.field_5904, 120, 1, false, false, true));
                }
                if (KQConfigValues.BAMBOOSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.BAMBOOSET) && source.method_49708(class_8111.field_42345)) {
                    class_3222 serverPlayer = (class_3222)player;
                    int particleCount = 80;
                    double particleRadius = 1.2;
                    for (int i = 0; i < particleCount; ++i) {
                        double angleOffset = Math.PI * 2 / (double)particleCount * (double)i;
                        double xParticleOffset = particleRadius * Math.cos(angleOffset);
                        double zParticleOffset = particleRadius * Math.sin(angleOffset);
                        serverPlayer.field_13987.method_14364((class_2596)new class_2675((class_2394)class_2398.field_17430, true, player.method_23317() + xParticleOffset, player.method_23318() + 0.1, player.method_23321() + zParticleOffset, 0.2f, 0.05f, 0.2f, 0.0f, 1));
                    }
                    Class classToPush = KQConfigValues.ENABLE_BAMBOOSET_PUSH_PLAYERS.get() != false ? class_1297.class : class_1657.class;
                    player.method_37908().method_18467(classToPush, player.method_5829().method_1014(3.5)).forEach(entity1 -> {
                        class_243 direction = entity1.method_19538().method_1020(player.method_19538()).method_1029().method_1021((double)amount * 0.5);
                        entity1.method_5762(direction.field_1352, direction.field_1351 + 0.5, direction.field_1350);
                    });
                }
                if (KQConfigValues.ENDERMANSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.ENDERMANSET) && source.method_5529() != null && (double)(random = entity.method_37908().method_8409()).method_43057() < 0.3) {
                    int radius = KQConfigValues.TELEPORT_RADIUS_ENDERMANSET.get();
                    class_2338 playerPos = player.method_24515();
                    ArrayList<class_2338> validPositions = new ArrayList<class_2338>();
                    for (int x = -radius; x <= radius; ++x) {
                        for (int y = -radius; y <= radius; ++y) {
                            for (int z = -radius; z <= radius; ++z) {
                                class_2338 targetPos = playerPos.method_10069(x, y, z);
                                if (!KQArmorEvents.isTeleportPositionValid(player.method_37908(), targetPos)) continue;
                                validPositions.add(targetPos);
                            }
                        }
                    }
                    if (!validPositions.isEmpty()) {
                        class_2338 randomPos = (class_2338)validPositions.get(random.method_43048(validPositions.size()));
                        player.method_37908().method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14879, class_3419.field_15248, 1.0f, 1.0f);
                        player.method_5859((double)randomPos.method_10263(), (double)randomPos.method_10264(), (double)randomPos.method_10260());
                        return false;
                    }
                }
                if (KQConfigValues.VETERANSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.VETERANSET) && (double)player.method_6032() < (double)player.method_6063() * 0.5) {
                    player.method_6092(new class_1293(class_1294.field_5910, 200, 0, false, false, true));
                    player.method_6092(new class_1293(class_1294.field_5907, 200, 1, false, false, true));
                }
                if (KQConfigValues.FORZESET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.FORZESET)) {
                    random = entity.method_37908().method_8409();
                    if (source.method_5529() != null && random.method_43057() < KQConfigValues.FORZESET_DEFLECT_CHANCE.get().floatValue()) {
                        isProcessingDamage.set(true);
                        try {
                            source.method_5529().method_5643(source, amount * KQConfigValues.FORZESET_DEFLECT_DAMAGE.get().floatValue());
                        }
                        finally {
                            isProcessingDamage.set(false);
                        }
                    }
                }
                if (KQConfigValues.POLAR.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.POLAR) && source.method_5529() != null && source.method_49708(class_8111.field_42354)) {
                    return false;
                }
            }
            if ((random = source.method_5529()) instanceof class_1657) {
                class_1297 class_12973;
                player = (class_1657)random;
                if (KQConfigValues.SILVERSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.SILVERSET) && player.method_37908().method_23886() && (random = entity.method_37908().method_8409()).method_43057() < KQConfigValues.SILVERSET_BURN_CHANCE.get().floatValue()) {
                    entity.method_56073(random.method_39332(2, 8) * 20);
                }
                if (KQConfigValues.HOLLOWSET.get().booleanValue() && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.HOLLOWSET) && (class_12973 = source.method_5529()) instanceof class_1309) {
                    class_1309 livingEntity2 = (class_1309)class_12973;
                    isProcessingDamage.set(true);
                    try {
                        player.method_6025(Math.min(amount * KQConfigValues.HOLLOWSET_HEALING_MULTIPLIER.get().floatValue(), livingEntity2.method_6032()));
                    }
                    finally {
                        isProcessingDamage.set(false);
                    }
                }
                if (KQConfigValues.WITHERSET.get().booleanValue() && source.method_49708(class_8111.field_42321) && KQFullSetChecker.hasFullSetOn(player, KQArmorMaterials.WITHERSET) && (random = entity.method_37908().method_8409()).method_43057() < KQConfigValues.WITHERSET_WITHER_CHANCE.get().floatValue()) {
                    entity.method_6092(new class_1293(class_1294.field_5920, 120, 0, false, false, false));
                }
            }
            return true;
        }
    }
}

