/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.data.builders;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_175;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1935;
import net.minecraft.class_2119;
import net.minecraft.class_2960;
import net.minecraft.class_5797;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_8782;
import net.minecraft.class_8790;
import net.minecraft.class_9326;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;
import wraith.alloyforgery.recipe.OutputData;
import wraith.alloyforgery.recipe.RawAlloyForgeRecipe;

public class AlloyForgeryRecipeBuilder
implements class_5797 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<String, class_175<?>> advancementBuilder = new LinkedHashMap();
    private String group = "";
    @Nullable
    private final class_6862<class_1792> outputTag;
    @Nullable
    private final class_1935 outputItem;
    private final int outputCount;
    private final Map<class_1856, Integer> inputs = new LinkedHashMap<class_1856, Integer>();
    private final Map<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride> ranges = new LinkedHashMap<AlloyForgeRecipe.OverrideRange, AlloyForgeRecipe.PendingOverride>();
    private final List<class_2960> priorities = new ArrayList<class_2960>();
    private int minimumTier = 1;
    private int fuelPerTick = 5;

    private AlloyForgeryRecipeBuilder(@Nullable class_6862<class_1792> outputTag, @Nullable class_1935 outputItem, int outputCount) {
        this.outputTag = outputTag;
        this.outputItem = outputItem;
        this.outputCount = outputCount;
    }

    public static AlloyForgeryRecipeBuilder create(class_1935 output) {
        return AlloyForgeryRecipeBuilder.create(output, 1);
    }

    public static AlloyForgeryRecipeBuilder create(class_1935 output, int outputCount) {
        return new AlloyForgeryRecipeBuilder(null, output, outputCount);
    }

    public static AlloyForgeryRecipeBuilder create(class_6862<class_1792> outputTag) {
        return AlloyForgeryRecipeBuilder.create(outputTag, 1);
    }

    public static AlloyForgeryRecipeBuilder create(class_6862<class_1792> outputTag, int outputCount) {
        return new AlloyForgeryRecipeBuilder(outputTag, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder addPriorityOutput(class_1935 ... outputs) {
        return this.addPriorityOutput((class_2960[])Arrays.stream(outputs).map(output -> class_7923.field_41178.method_10221((Object)output.method_8389())).toArray(class_2960[]::new));
    }

    public AlloyForgeryRecipeBuilder addPriorityOutput(class_2960 ... outputId) {
        this.priorities.addAll(List.of(outputId));
        return this;
    }

    public AlloyForgeryRecipeBuilder input(class_6862<class_1792> input, int count) {
        this.inputs.put(class_1856.method_8106(input), count);
        return this;
    }

    public AlloyForgeryRecipeBuilder input(class_1935 input, int count) {
        this.inputs.put(class_1856.method_8091((class_1935[])new class_1935[]{input}), count);
        return this;
    }

    public AlloyForgeryRecipeBuilder input(class_1799 inputStack) {
        this.inputs.put(class_1856.method_8091((class_1935[])new class_1935[]{inputStack.method_7909()}), inputStack.method_7947());
        return this;
    }

    public AlloyForgeryRecipeBuilder overrideRange(AlloyForgeRecipe.OverrideRange range, AlloyForgeRecipe.PendingOverride override) {
        this.ranges.put(range, override);
        return this;
    }

    public AlloyForgeryRecipeBuilder overrideRange(int start, int end, int outputCount) {
        return this.overrideRange(start, end, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder overrideRange(int start, int end, @Nullable class_1935 output, int outputCount) {
        this.ranges.put(new AlloyForgeRecipe.OverrideRange(start, end), new AlloyForgeRecipe.PendingOverride(output != null ? output.method_8389() : null, outputCount, class_9326.field_49588));
        return this;
    }

    public AlloyForgeryRecipeBuilder overrideRange(int index, int outputCount) {
        return this.overrideRange(index, false, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder overrideRange(int index, boolean includeUpperValues, int outputCount) {
        return this.overrideRange(index, includeUpperValues, null, outputCount);
    }

    public AlloyForgeryRecipeBuilder overrideRange(int index, boolean includeUpperValues, @Nullable class_1935 output, int outputCount) {
        this.ranges.put(new AlloyForgeRecipe.OverrideRange(index, includeUpperValues ? -1 : index), new AlloyForgeRecipe.PendingOverride(output != null ? output.method_8389() : null, outputCount, class_9326.field_49588));
        return this;
    }

    public AlloyForgeryRecipeBuilder setMinimumForgeTier(int tier) {
        this.minimumTier = tier;
        return this;
    }

    public AlloyForgeryRecipeBuilder setFuelPerTick(int fuelAmount) {
        this.fuelPerTick = fuelAmount;
        return this;
    }

    public AlloyForgeryRecipeBuilder criterion(String string, class_175 criterion) {
        this.advancementBuilder.put(string, criterion);
        return this;
    }

    public AlloyForgeryRecipeBuilder group(@Nullable String string) {
        this.group = string;
        return this;
    }

    public class_1792 method_36441() {
        return class_1802.field_8162;
    }

    public void method_17972(class_8790 exporter, class_2960 recipeId) {
        class_2960 advancementId = class_2960.method_60655((String)recipeId.method_12836(), (String)("recipes/alloy_forgery/" + recipeId.method_12832()));
        this.validate(recipeId);
        class_161.class_162 builder = exporter.method_53818().method_705("has_the_recipe", class_2119.method_27847((class_2960)recipeId)).method_703(class_170.class_171.method_753((class_2960)recipeId)).method_704(class_8782.class_8797.field_1257);
        this.advancementBuilder.forEach((arg_0, arg_1) -> ((class_161.class_162)builder).method_705(arg_0, arg_1));
        RawAlloyForgeRecipe recipe = new RawAlloyForgeRecipe(this.inputs, new OutputData(this.outputCount, this.outputItem != null ? this.outputItem.method_8389() : null, this.priorities.isEmpty() ? null : this.priorities, this.outputTag), this.minimumTier, this.fuelPerTick, this.ranges);
        exporter.method_53819(recipeId, (class_1860)recipe.generateRecipe(true), builder.method_695(advancementId));
    }

    public void method_10431(class_8790 exporter) {
        this.method_17972(exporter, this.getOutputId());
    }

    public void method_36443(class_8790 exporter, String recipePath) {
        class_2960 identifier2 = class_2960.method_60654((String)recipePath);
        if (identifier2.equals((Object)this.getOutputId())) {
            throw new IllegalStateException("Recipe " + recipePath + " should remove its 'save' argument as it is equal to default one");
        }
        this.method_17972(exporter, identifier2);
    }

    public void validate(class_2960 recipeId) {
        if (this.advancementBuilder.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe " + String.valueOf(recipeId));
        }
        if (this.inputs.isEmpty()) {
            throw new IllegalStateException("Missing inputs meaning such cannot be made " + String.valueOf(recipeId));
        }
    }

    private class_2960 getOutputId() {
        return this.outputTag != null ? this.outputTag.comp_327() : class_7923.field_41178.method_10221((Object)this.outputItem.method_8389());
    }
}

