/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.compat.rei;

import com.google.common.collect.ImmutableMap;
import io.wispforest.owo.serialization.endec.MinecraftEndecs;
import io.wispforest.owo.serialization.format.nbt.NbtDeserializer;
import io.wispforest.owo.serialization.format.nbt.NbtSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.DisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_8786;
import wraith.alloyforgery.compat.rei.AlloyForgeryCommonPlugin;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public class AlloyForgingDisplay
implements Display {
    private final List<EntryIngredient> inputs;
    private final EntryIngredient output;
    public final int minForgeTier;
    public final int requiredFuel;
    public final Map<AlloyForgeRecipe.OverrideRange, class_1799> overrides;
    public final Optional<class_2960> recipeID;

    private AlloyForgingDisplay(List<EntryIngredient> inputs, EntryIngredient output, int minForgeTier, int requiredFuel, Map<AlloyForgeRecipe.OverrideRange, class_1799> overrides, Optional<class_2960> recipeID) {
        this.inputs = inputs;
        this.output = output;
        this.minForgeTier = minForgeTier;
        this.requiredFuel = requiredFuel;
        this.overrides = overrides;
        this.recipeID = recipeID;
    }

    public static AlloyForgingDisplay of(class_8786<AlloyForgeRecipe> recipeEntry) {
        ArrayList<EntryIngredient> convertedInputs = new ArrayList<EntryIngredient>();
        AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeEntry.comp_1933();
        for (Map.Entry<class_1856, Integer> entry : recipe.getIngredientsMap().entrySet()) {
            int stackCount;
            for (int i = entry.getValue().intValue(); i > 0; i -= stackCount) {
                stackCount = Math.min(i, 64);
                convertedInputs.add(EntryIngredients.ofItemStacks(Arrays.stream(entry.getKey().method_8105()).map(class_1799::method_7972).peek(stack -> stack.method_7939(stackCount)).toList()));
            }
        }
        return new AlloyForgingDisplay((List<EntryIngredient>)convertedInputs, EntryIngredients.of((class_1799)recipe.getBaseResult()), recipe.getMinForgeTier(), recipe.getFuelPerTick(), (Map<AlloyForgeRecipe.OverrideRange, class_1799>)recipe.getTierOverrides(), recipe.secondaryID().or(() -> Optional.of(recipeEntry.comp_1932())));
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputs;
    }

    public List<EntryIngredient> getOutputEntries() {
        return Collections.singletonList(this.output);
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return AlloyForgeryCommonPlugin.ID;
    }

    public Optional<class_2960> getDisplayLocation() {
        return this.recipeID;
    }

    public static enum Serializer implements DisplaySerializer<AlloyForgingDisplay>
    {
        INSTANCE;


        public class_2487 save(class_2487 tag, AlloyForgingDisplay display) {
            tag.method_10569("fuel_per_tick", display.requiredFuel);
            tag.method_10569("min_forge_tier", display.minForgeTier);
            class_2499 inputs = new class_2499();
            inputs.addAll(display.inputs.stream().map(EntryIngredient::saveIngredient).toList());
            tag.method_10566("inputs", (class_2520)inputs);
            tag.method_10566("output", (class_2520)display.output.saveIngredient());
            class_2499 overrides = new class_2499();
            display.overrides.forEach((overrideRange, itemStack) -> {
                class_2487 overrideTag = new class_2487();
                overrideTag.method_10569("lower", overrideRange.lowerBound());
                overrideTag.method_10569("upper", overrideRange.upperBound());
                overrideTag.method_10566("stack", (class_2520)MinecraftEndecs.ITEM_STACK.encodeFully(NbtSerializer::of, itemStack));
                overrides.add((Object)overrideTag);
            });
            tag.method_10566("overrides", (class_2520)overrides);
            display.recipeID.ifPresent(id -> tag.method_10582("recipeID", id.toString()));
            return tag;
        }

        public AlloyForgingDisplay read(class_2487 tag) {
            int requiredFuel = tag.method_10550("fuel_per_tick");
            int minForgeTier = tag.method_10550("fuel_per_tick");
            ArrayList<EntryIngredient> input = new ArrayList<EntryIngredient>();
            tag.method_10554("inputs", 9).forEach(nbtElement -> input.add(EntryIngredient.read((class_2499)((class_2499)nbtElement))));
            EntryIngredient output = EntryIngredient.read((class_2499)tag.method_10554("output", 9));
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            tag.method_10554("overrides", 10).forEach(nbtElement -> {
                class_2487 overrideTag = (class_2487)nbtElement;
                AlloyForgeRecipe.OverrideRange range = new AlloyForgeRecipe.OverrideRange(overrideTag.method_10550("lower"), overrideTag.method_10550("upper"));
                class_1799 stack = (class_1799)MinecraftEndecs.ITEM_STACK.decodeFully(NbtDeserializer::of, (Object)overrideTag.method_10562("stack"));
                builder.put((Object)range, (Object)stack);
            });
            class_2960 recipeID = tag.method_10545("recipeID") ? class_2960.method_12829((String)tag.method_10558("recipeID")) : null;
            return new AlloyForgingDisplay(input, output, minForgeTier, requiredFuel, (Map<AlloyForgeRecipe.OverrideRange, class_1799>)builder.build(), Optional.ofNullable(recipeID));
        }
    }
}

