/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.compat.emi;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5481;
import net.minecraft.class_8786;
import org.apache.commons.lang3.mutable.MutableInt;
import org.jetbrains.annotations.Nullable;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.compat.emi.AlloyForgeryEmiPlugin;
import wraith.alloyforgery.compat.emi.CustomButtonWidget;
import wraith.alloyforgery.compat.emi.CustomSlotWidget;
import wraith.alloyforgery.compat.emi.CustomTextWidget;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;

public class AlloyForgeryEmiRecipe
implements EmiRecipe {
    static final class_2960 GUI_TEXTURE = AlloyForgery.id("textures/gui/forge_controller.png");
    private final List<EmiIngredient> inputs;
    private final EmiStack output;
    private final int minForgeTier;
    private final int requiredFuel;
    private final Map<AlloyForgeRecipe.OverrideRange, class_1799> overrides;
    private final class_2960 recipeID;

    public AlloyForgeryEmiRecipe(class_8786<AlloyForgeRecipe> recipeEntry) {
        AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeEntry.comp_1933();
        ArrayList<EmiIngredient> convertedInputs = new ArrayList<EmiIngredient>();
        for (Map.Entry<class_1856, Integer> entry : recipe.getIngredientsMap().entrySet()) {
            int stackCount;
            for (int i = entry.getValue().intValue(); i > 0; i -= stackCount) {
                stackCount = Math.min(i, 64);
                convertedInputs.add(EmiIngredient.of(Arrays.stream(entry.getKey().method_8105()).map(class_1799::method_7972).peek(stack -> stack.method_7939(stackCount)).map(EmiStack::of).toList()));
            }
        }
        this.inputs = convertedInputs;
        this.output = EmiStack.of((class_1799)recipe.getBaseResult());
        this.minForgeTier = recipe.getMinForgeTier();
        this.requiredFuel = recipe.getFuelPerTick();
        this.overrides = recipe.getTierOverrides();
        this.recipeID = recipe.secondaryID().orElse(recipeEntry.comp_1932());
    }

    public void addWidgets(WidgetHolder widgets) {
        CustomTextWidget tierTextWidget = (CustomTextWidget)widgets.add((Widget)new CustomTextWidget(AlloyForgeryEmiRecipe.minTierText(this.minForgeTier), 8, 7, 0x404040, false));
        widgets.addText(class_2561.method_43469((String)"container.alloy_forgery.rei.fuel_per_tick", (Object[])new Object[]{this.requiredFuel}).method_30937(), 8, 20, 0x404040, false);
        widgets.addTexture(GUI_TEXTURE, 6, 34, 92, 38, 42, 41);
        widgets.addTexture(GUI_TEXTURE, 107, 14, 10, 10, 208, 30);
        widgets.addTexture(GUI_TEXTURE, 111, 17, 16, 20, 176, 0);
        for (int i = 0; i < this.inputs.size(); ++i) {
            int x = 7 + i % 5 * 18;
            int y = 35 + i / 5 * 18;
            widgets.addTexture(GUI_TEXTURE, x, y, 18, 18, 208, 0);
            widgets.addSlot(this.inputs.get(i), x, y).drawBack(false);
        }
        CustomSlotWidget outputWidget = (CustomSlotWidget)widgets.add((Widget)new CustomSlotWidget((EmiIngredient)this.getOutputs().get(0), 104, 38, this));
        MutableInt index = new MutableInt(0);
        List overridesKeys = this.overrides.keySet().stream().toList();
        widgets.add((Widget)new CustomButtonWidget(127, 2, () -> !this.overrides.isEmpty(), (mouseX, mouseY, button) -> {
            EmiStack currentStack;
            Object tierArg;
            Integer currentIndex;
            if (index.incrementAndGet() > this.overrides.size()) {
                index.setValue(0);
            }
            if ((currentIndex = index.getValue()) == 0) {
                tierArg = this.minForgeTier;
                currentStack = this.getOutputs().get(0);
            } else {
                AlloyForgeRecipe.OverrideRange range = (AlloyForgeRecipe.OverrideRange)overridesKeys.get(currentIndex - 1);
                tierArg = range;
                currentStack = EmiStack.of((class_1799)this.overrides.get(range));
            }
            tierTextWidget.setText(AlloyForgeryEmiRecipe.minTierText(tierArg));
            outputWidget.setMutableStack((EmiIngredient)currentStack);
        }));
    }

    private static class_5481 minTierText(Object tierArg) {
        return class_2561.method_43469((String)"container.alloy_forgery.rei.min_tier", (Object[])new Object[]{tierArg}).method_30937();
    }

    public EmiRecipeCategory getCategory() {
        return AlloyForgeryEmiPlugin.FORGE_CATEGORY;
    }

    @Nullable
    public class_2960 getId() {
        return this.recipeID;
    }

    public List<EmiIngredient> getInputs() {
        return this.inputs;
    }

    public List<EmiStack> getOutputs() {
        return Collections.singletonList(this.output);
    }

    public int getDisplayWidth() {
        return 142;
    }

    public int getDisplayHeight() {
        return 78;
    }
}

